/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.type.DefaultSubtypeOfValue;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

class MapType
extends DefaultSubtypeOfValue {
    protected final Type fKeyType;
    protected final Type fValueType;

    MapType(Type keyType, Type valueType) {
        this.fKeyType = keyType;
        this.fValueType = valueType;
    }

    @Override
    public TypeFactory.TypeReifier getTypeReifier(TypeFactory.TypeValues symbols) {
        return new Info(symbols);
    }

    @Override
    public Type getKeyType() {
        return this.fKeyType;
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    public Type getValueType() {
        return this.fValueType;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public boolean hasFieldNames() {
        return false;
    }

    @Override
    public Type getFieldType(int i) {
        switch (i) {
            case 0: {
                return this.fKeyType;
            }
            case 1: {
                return this.fValueType;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Type select(int ... fields) {
        return TypeFactory.getInstance().setType(this.getFieldTypes().select(fields));
    }

    @Override
    public Type getFieldTypes() {
        return TypeFactory.getInstance().tupleType(this.fKeyType, this.fValueType);
    }

    @Override
    public Type carrier() {
        TypeFactory tf = TypeFactory.getInstance();
        return tf.setType(this.fKeyType.lub(this.fValueType));
    }

    @Override
    public int hashCode() {
        return 56509 + 3511 * this.fKeyType.hashCode() + 1171 * this.fValueType.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        MapType other = (MapType)obj;
        return this.fKeyType == other.fKeyType && this.fValueType == other.fValueType;
    }

    @Override
    public String toString() {
        return "map[" + this.fKeyType + ", " + this.fValueType + "]";
    }

    @Override
    public <T, E extends Throwable> T accept(ITypeVisitor<T, E> visitor) throws E {
        return visitor.visitMap(this);
    }

    @Override
    public boolean intersects(Type other) {
        return other.intersectsWithMap(this);
    }

    @Override
    protected boolean intersectsWithMap(Type type) {
        return true;
    }

    @Override
    protected boolean isSupertypeOf(Type type) {
        return type.isSubtypeOfMap(this);
    }

    @Override
    public Type lub(Type other) {
        return other.lubWithMap(this);
    }

    @Override
    public Type glb(Type type) {
        return type.glbWithMap(this);
    }

    @Override
    protected boolean isSubtypeOfMap(Type type) {
        return this.fKeyType.isSubtypeOf(type.getKeyType()) && this.fValueType.isSubtypeOf(type.getValueType());
    }

    @Override
    protected Type lubWithMap(Type type) {
        return this == type ? this : TF.mapTypeFromTuple(this.getFieldTypes().lub(type.getFieldTypes()));
    }

    @Override
    protected Type glbWithMap(Type type) {
        return this == type ? this : TF.mapTypeFromTuple(this.getFieldTypes().glb(type.getFieldTypes()));
    }

    @Override
    public boolean isOpen() {
        return this.fKeyType.isOpen() || this.fValueType.isOpen();
    }

    @Override
    public boolean match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        if (!super.match(matched, bindings)) {
            return false;
        }
        if (matched.isMap() || matched.isAliased() && matched.getAliased().isMap() || matched.isBottom()) {
            return this.getKeyType().match(matched.getKeyType(), bindings) && this.getValueType().match(matched.getValueType(), bindings);
        }
        return true;
    }

    @Override
    public Type instantiate(Map<Type, Type> bindings) {
        return TypeFactory.getInstance().mapType(this.getKeyType().instantiate(bindings), this.getValueType().instantiate(bindings));
    }

    @Override
    public IValue randomValue(Random random, IValueFactory vf, TypeStore store, Map<Type, Type> typeParameters, int maxDepth, int maxWidth) {
        IMapWriter result = vf.mapWriter();
        if (maxDepth > 0 && random.nextBoolean()) {
            int size = Math.min(maxWidth, 1 + random.nextInt(maxDepth));
            if (!this.getKeyType().isBottom() && !this.getValueType().isBottom()) {
                for (int i = 0; i < size; ++i) {
                    result.put(this.getKeyType().randomValue(random, vf, store, typeParameters, maxDepth - 1, maxWidth), this.getValueType().randomValue(random, vf, store, typeParameters, maxDepth - 1, maxWidth));
                }
            }
        }
        IMap done = (IMap)result.done();
        this.match(done.getType(), typeParameters);
        return done;
    }

    public static class Info
    extends TypeFactory.TypeReifier {
        public Info(TypeFactory.TypeValues symbols) {
            super(symbols);
        }

        @Override
        public Type getSymbolConstructorType() {
            return this.symbols().typeSymbolConstructor("map", this.symbols().symbolADT(), "from", this.symbols().symbolADT(), "to");
        }

        @Override
        public Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            IConstructor from = (IConstructor)symbol.get("from");
            IConstructor to = (IConstructor)symbol.get("to");
            String fromLabel = null;
            String toLabel = null;
            if (this.symbols().isLabel(from)) {
                fromLabel = this.symbols().getLabel(from);
                from = (IConstructor)from.get("symbol");
            }
            if (this.symbols().isLabel(to)) {
                toLabel = this.symbols().getLabel(to);
                to = (IConstructor)to.get("symbol");
            }
            if (fromLabel != null && toLabel != null) {
                return this.tf().mapType(this.symbols().fromSymbol(from, store, grammar), fromLabel, this.symbols().fromSymbol(to, store, grammar), toLabel);
            }
            return this.tf().mapType(this.symbols().fromSymbol(from, store, grammar), this.symbols().fromSymbol(to, store, grammar));
        }

        @Override
        public IConstructor toSymbol(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            if (type.hasFieldNames()) {
                return vf.constructor(this.getSymbolConstructorType(), this.symbols().labelSymbol(vf, type.getKeyType().asSymbol(vf, store, grammar, done), type.getKeyLabel()), this.symbols().labelSymbol(vf, type.getValueType().asSymbol(vf, store, grammar, done), type.getValueLabel()));
            }
            return vf.constructor(this.getSymbolConstructorType(), type.getKeyType().asSymbol(vf, store, grammar, done), type.getValueType().asSymbol(vf, store, grammar, done));
        }

        @Override
        public boolean isRecursive() {
            return false;
        }

        @Override
        public void asProductions(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            type.getKeyType().asProductions(vf, store, grammar, done);
            type.getValueType().asProductions(vf, store, grammar, done);
        }

        @Override
        public Type randomInstance(Supplier<Type> next, TypeStore store, TypeFactory.RandomTypesConfig rnd) {
            return this.tf().mapType(next.get(), next.get());
        }
    }
}

