/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.exceptions.UndeclaredFieldException;
import io.usethesource.vallang.type.MapType;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

final class MapTypeWithFieldNames
extends MapType {
    private final String fKeyLabel;
    private final String fValueLabel;

    MapTypeWithFieldNames(Type keyType, String keyLabel, Type valueType, String valueLabel) {
        super(keyType, valueType);
        this.fKeyLabel = keyLabel;
        this.fValueLabel = valueLabel;
    }

    @Override
    public String getValueLabel() {
        return this.fValueLabel;
    }

    @Override
    public String getKeyLabel() {
        return this.fKeyLabel;
    }

    @Override
    public boolean hasFieldNames() {
        return true;
    }

    @Override
    public Type getFieldType(String fieldName) throws FactTypeUseException {
        if (this.fKeyLabel.equals(fieldName)) {
            return this.fKeyType;
        }
        if (this.fValueLabel.equals(fieldName)) {
            return this.fValueType;
        }
        throw new UndeclaredFieldException(this, fieldName);
    }

    @Override
    public boolean hasField(String fieldName) {
        if (fieldName.equals(this.fKeyLabel)) {
            return true;
        }
        return fieldName.equals(this.fValueLabel);
    }

    @Override
    public String getFieldName(int i) {
        switch (i) {
            case 0: {
                return this.fKeyLabel;
            }
            case 1: {
                return this.fValueLabel;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Type select(String ... names) {
        return TypeFactory.getInstance().setType(this.getFieldTypes().select(names));
    }

    @Override
    public int getFieldIndex(String fieldName) {
        if (this.fKeyLabel.equals(fieldName)) {
            return 0;
        }
        if (this.fValueLabel.equals(fieldName)) {
            return 1;
        }
        throw new UndeclaredFieldException(this, fieldName);
    }

    @Override
    public Type getFieldTypes() {
        return TypeFactory.getInstance().tupleType(this.fKeyType, this.fKeyLabel, this.fValueType, this.fValueLabel);
    }

    @Override
    public int hashCode() {
        return 56509 + 3511 * this.fKeyType.hashCode() + 1171 * this.fValueType.hashCode() + 13 * this.fKeyLabel.hashCode() + 1331 * this.fValueLabel.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        MapTypeWithFieldNames other = (MapTypeWithFieldNames)obj;
        return this.fKeyType == other.fKeyType && this.fValueType == other.fValueType && this.fKeyLabel.equals(other.fKeyLabel) && this.fValueLabel.equals(other.fValueLabel);
    }

    @Override
    public String toString() {
        return "map[" + this.fKeyType + " " + this.fKeyLabel + ", " + this.fValueType + " " + this.fValueLabel + "]";
    }

    @Override
    public Type instantiate(Map<Type, Type> bindings) {
        return TypeFactory.getInstance().mapType(this.getKeyType().instantiate(bindings), this.fKeyLabel, this.getValueType().instantiate(bindings), this.fValueLabel);
    }
}

