/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.DefaultSubtypeOfValue;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

class NumberType
extends DefaultSubtypeOfValue {
    NumberType() {
    }

    public static NumberType getInstance() {
        return InstanceKeeper.sInstance;
    }

    @Override
    public TypeFactory.TypeReifier getTypeReifier(TypeFactory.TypeValues symbols) {
        return new Info(symbols);
    }

    @Override
    public String toString() {
        return "num";
    }

    @Override
    protected boolean isSupertypeOf(Type type) {
        return type.isSubtypeOfNumber(this);
    }

    @Override
    public Type lub(Type other) {
        return other.lubWithNumber(this);
    }

    @Override
    protected boolean isSubtypeOfNumber(Type type) {
        return true;
    }

    @Override
    public boolean intersects(Type other) {
        return other.intersectsWithNumber(this);
    }

    @Override
    protected boolean intersectsWithNumber(Type type) {
        return true;
    }

    @Override
    protected boolean intersectsWithInteger(Type type) {
        return true;
    }

    @Override
    protected boolean intersectsWithRational(Type type) {
        return true;
    }

    @Override
    protected boolean intersectsWithReal(Type type) {
        return true;
    }

    @Override
    protected Type lubWithNumber(Type type) {
        return type;
    }

    @Override
    protected Type lubWithInteger(Type type) {
        return NumberType.getInstance();
    }

    @Override
    protected Type lubWithReal(Type type) {
        return NumberType.getInstance();
    }

    @Override
    protected Type lubWithRational(Type type) {
        return NumberType.getInstance();
    }

    @Override
    public Type glb(Type type) {
        return type.glbWithNumber(this);
    }

    @Override
    protected Type glbWithNumber(Type type) {
        return this;
    }

    @Override
    protected Type glbWithInteger(Type type) {
        return type;
    }

    @Override
    protected Type glbWithReal(Type type) {
        return type;
    }

    @Override
    protected Type glbWithRational(Type type) {
        return type;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return o == NumberType.getInstance();
    }

    @Override
    public int hashCode() {
        return 133020331;
    }

    @Override
    public <T, E extends Throwable> T accept(ITypeVisitor<T, E> visitor) throws E {
        return visitor.visitNumber(this);
    }

    @Override
    public IValue randomValue(Random random, IValueFactory vf, TypeStore store, Map<Type, Type> typeParameters, int maxDepth, int maxWidth) {
        switch (random.nextInt(3)) {
            case 0: {
                return TypeFactory.getInstance().integerType().randomValue(random, vf, store, typeParameters, maxDepth, maxWidth);
            }
            case 1: {
                return TypeFactory.getInstance().realType().randomValue(random, vf, store, typeParameters, maxDepth, maxWidth);
            }
        }
        return TypeFactory.getInstance().rationalType().randomValue(random, vf, store, typeParameters, maxDepth, maxWidth);
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    public static class Info
    extends TypeFactory.TypeReifier {
        public Info(TypeFactory.TypeValues symbols) {
            super(symbols);
        }

        @Override
        public Type getSymbolConstructorType() {
            return this.symbols().typeSymbolConstructor("num", new Object[0]);
        }

        @Override
        public Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            return NumberType.getInstance();
        }

        @Override
        public Type randomInstance(Supplier<Type> next, TypeStore store, TypeFactory.RandomTypesConfig rnd) {
            return this.tf().numberType();
        }
    }

    private static final class InstanceKeeper {
        protected static final NumberType sInstance = new NumberType();

        private InstanceKeeper() {
        }
    }
}

