/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.exceptions.TypeParseError;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class TypeReader {
    private static final char TYPE_PARAMETER_TOKEN = '&';
    private static final char START_OF_ARGUMENTS = '[';
    private static final char END_OF_ARGUMENTS = ']';
    private static final char COMMA_SEPARATOR = ',';
    private static final TypeFactory types = TypeFactory.getInstance();
    private TypeStore store = new TypeStore(new TypeStore[0]);
    private NoWhiteSpaceReader stream = new NoWhiteSpaceReader(new StringReader(""));
    private int current;

    public Type read(TypeStore store, Reader stream) throws IOException {
        this.store = store;
        this.stream = new NoWhiteSpaceReader(stream);
        this.current = this.stream.read();
        Type result = this.readType();
        if (this.current != -1 || this.stream.read() != -1) {
            this.unexpected();
        }
        return result;
    }

    private Type readType() throws IOException {
        if (this.current == 38) {
            this.checkAndRead('&');
            return this.readTypeParameter();
        }
        if (Character.isJavaIdentifierStart(this.current)) {
            Type adt;
            String id;
            switch (id = this.readIdentifier()) {
                case "int": {
                    return types.integerType();
                }
                case "real": {
                    return types.realType();
                }
                case "rat": {
                    return types.rationalType();
                }
                case "num": {
                    return types.numberType();
                }
                case "bool": {
                    return types.boolType();
                }
                case "node": {
                    return types.nodeType();
                }
                case "void": {
                    return types.voidType();
                }
                case "value": {
                    return types.valueType();
                }
                case "loc": {
                    return types.sourceLocationType();
                }
                case "str": {
                    return types.stringType();
                }
                case "datetime": {
                    return types.dateTimeType();
                }
            }
            if (this.current == 91) {
                switch (id) {
                    case "list": {
                        return this.readComposite(t2 -> types.listType((Type)t2.get(0)));
                    }
                    case "set": {
                        return this.readComposite(t2 -> types.setType((Type)t2.get(0)));
                    }
                    case "map": {
                        return this.readComposite(t2 -> types.mapType((Type)t2.get(0), (Type)t2.get(1)));
                    }
                    case "tuple": {
                        return this.readComposite(t2 -> types.tupleType(t2.toArray(new Type[0])));
                    }
                    case "rel": {
                        return this.readComposite(t2 -> types.relType(t2.toArray(new Type[0])));
                    }
                    case "lrel": {
                        return this.readComposite(t2 -> types.lrelType(t2.toArray(new Type[0])));
                    }
                }
                adt = this.store.lookupAbstractDataType(id);
                if (adt != null) {
                    return this.readComposite(t2 -> types.abstractDataType(this.store, id, t2.toArray(new Type[0])));
                }
                throw new TypeParseError("undeclared type " + id, new NullPointerException());
            }
            adt = this.store.lookupAbstractDataType(id);
            if (adt != null) {
                return adt;
            }
            throw new TypeParseError("undeclared type " + id, new NullPointerException());
        }
        throw new TypeParseError("Unexpected " + (char)this.current, this.stream.getOffset());
    }

    private Type readTypeParameter() throws IOException {
        String name = this.readIdentifier();
        if (this.current == 60) {
            this.checkAndRead('<');
            this.checkAndRead(':');
            return types.parameterType(name, this.readType());
        }
        return types.parameterType(name);
    }

    private Type readComposite(Function<List<Type>, Type> wrap) throws IOException {
        ArrayList<Type> arr = new ArrayList<Type>();
        this.readFixed(']', arr);
        return wrap.apply(arr);
    }

    private String readIdentifier() throws IOException {
        boolean escaped;
        StringBuilder builder = new StringBuilder();
        boolean bl = escaped = this.current == 92;
        if (escaped) {
            this.current = this.stream.read();
        }
        while (Character.isJavaIdentifierStart(this.current) || Character.isJavaIdentifierPart(this.current) || escaped && this.current == 45) {
            builder.append((char)this.current);
            this.current = this.stream.read();
        }
        return builder.toString();
    }

    private void readFixed(char end, List<Type> arr) throws IOException {
        this.current = this.stream.read();
        while (this.current != end) {
            arr.add(this.readType());
            if (this.current == end) break;
            this.checkAndRead(',');
        }
        this.checkAndRead(end);
    }

    private void checkAndRead(char c) throws IOException {
        if (this.current != c) {
            this.unexpected(c);
        }
        this.current = this.stream.read();
    }

    private void unexpected(int c) {
        throw new TypeParseError("Expected " + (char)c + " but got " + (char)this.current, this.stream.getOffset());
    }

    private void unexpected() {
        throw new TypeParseError("Unexpected " + (char)this.current, this.stream.getOffset());
    }

    private static class NoWhiteSpaceReader
    extends Reader {
        private Reader wrapped;
        int offset;
        boolean inString = false;
        boolean escaping = false;

        public NoWhiteSpaceReader(Reader wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read() throws IOException {
            int r = this.wrapped.read();
            ++this.offset;
            if (!this.inString) {
                while (Character.isWhitespace(r)) {
                    ++this.offset;
                    r = this.wrapped.read();
                }
            }
            if (!this.inString && r == 34) {
                this.inString = true;
            } else if (this.inString) {
                if (this.escaping) {
                    this.escaping = false;
                } else if (r == 92) {
                    this.escaping = true;
                } else if (r == 34) {
                    this.inString = false;
                }
            }
            return r;
        }

        int getOffset() {
            return this.offset;
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
        }
    }
}

