/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.solvers;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.DifferentiableUnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverImpl;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverUtils;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class NewtonSolver
extends UnivariateRealSolverImpl {
    @Deprecated
    public NewtonSolver(DifferentiableUnivariateRealFunction f) {
        super(f, 100, 1.0E-6);
    }

    @Deprecated
    public NewtonSolver() {
        super(100, 1.0E-6);
    }

    @Deprecated
    public double solve(double min2, double max) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve(this.f, min2, max);
    }

    @Deprecated
    public double solve(double min2, double max, double startValue) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve(this.f, min2, max, startValue);
    }

    public double solve(int maxEval, UnivariateRealFunction f, double min2, double max) throws MaxIterationsExceededException, FunctionEvaluationException {
        this.setMaximalIterationCount(maxEval);
        return this.solve(f, min2, max);
    }

    @Deprecated
    public double solve(UnivariateRealFunction f, double min2, double max) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve(f, min2, max, UnivariateRealSolverUtils.midpoint(min2, max));
    }

    public double solve(int maxEval, UnivariateRealFunction f, double min2, double max, double startValue) throws MaxIterationsExceededException, FunctionEvaluationException {
        this.setMaximalIterationCount(maxEval);
        return this.solve(f, min2, max, startValue);
    }

    @Deprecated
    public double solve(UnivariateRealFunction f, double min2, double max, double startValue) throws MaxIterationsExceededException, FunctionEvaluationException {
        try {
            UnivariateRealFunction derivative = ((DifferentiableUnivariateRealFunction)f).derivative();
            this.clearResult();
            this.verifySequence(min2, startValue, max);
            double x0 = startValue;
            for (int i = 0; i < this.maximalIterationCount; ++i) {
                double x1 = x0 - f.value(x0) / derivative.value(x0);
                if (FastMath.abs(x1 - x0) <= this.absoluteAccuracy) {
                    this.setResult(x1, i);
                    return x1;
                }
                x0 = x1;
            }
            throw new MaxIterationsExceededException(this.maximalIterationCount);
        }
        catch (ClassCastException cce) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.FUNCTION_NOT_DIFFERENTIABLE, new Object[0]);
        }
    }
}

