/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.DateAndTime;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.JustDate;
import org.rascalmpl.ast.JustTime;

public abstract class DateTimeLiteral
extends AbstractAST {
    public DateTimeLiteral(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasDateAndTime() {
        return false;
    }

    public DateAndTime getDateAndTime() {
        throw new UnsupportedOperationException();
    }

    public boolean hasDate() {
        return false;
    }

    public JustDate getDate() {
        throw new UnsupportedOperationException();
    }

    public boolean hasTime() {
        return false;
    }

    public JustTime getTime() {
        throw new UnsupportedOperationException();
    }

    public boolean isDateAndTimeLiteral() {
        return false;
    }

    public boolean isDateLiteral() {
        return false;
    }

    public boolean isTimeLiteral() {
        return false;
    }

    public static class TimeLiteral
    extends DateTimeLiteral {
        private final JustTime time;

        public TimeLiteral(ISourceLocation src, IConstructor node, JustTime time) {
            super(src, node);
            this.time = time;
        }

        @Override
        public boolean isTimeLiteral() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitDateTimeLiteralTimeLiteral(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.time.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.time.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof TimeLiteral)) {
                return false;
            }
            TimeLiteral tmp = (TimeLiteral)o;
            return tmp.time.equals(this.time);
        }

        @Override
        public int hashCode() {
            return 373 + 149 * this.time.hashCode();
        }

        @Override
        public JustTime getTime() {
            return this.time;
        }

        @Override
        public boolean hasTime() {
            return true;
        }

        @Override
        public Object clone() {
            return TimeLiteral.newInstance(this.getClass(), this.src, null, this.clone(this.time));
        }
    }

    public static class DateLiteral
    extends DateTimeLiteral {
        private final JustDate date;

        public DateLiteral(ISourceLocation src, IConstructor node, JustDate date) {
            super(src, node);
            this.date = date;
        }

        @Override
        public boolean isDateLiteral() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitDateTimeLiteralDateLiteral(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.date.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.date.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof DateLiteral)) {
                return false;
            }
            DateLiteral tmp = (DateLiteral)o;
            return tmp.date.equals(this.date);
        }

        @Override
        public int hashCode() {
            return 907 + 857 * this.date.hashCode();
        }

        @Override
        public JustDate getDate() {
            return this.date;
        }

        @Override
        public boolean hasDate() {
            return true;
        }

        @Override
        public Object clone() {
            return DateLiteral.newInstance(this.getClass(), this.src, null, this.clone(this.date));
        }
    }

    public static class DateAndTimeLiteral
    extends DateTimeLiteral {
        private final DateAndTime dateAndTime;

        public DateAndTimeLiteral(ISourceLocation src, IConstructor node, DateAndTime dateAndTime) {
            super(src, node);
            this.dateAndTime = dateAndTime;
        }

        @Override
        public boolean isDateAndTimeLiteral() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitDateTimeLiteralDateAndTimeLiteral(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.dateAndTime.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.dateAndTime.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof DateAndTimeLiteral)) {
                return false;
            }
            DateAndTimeLiteral tmp = (DateAndTimeLiteral)o;
            return tmp.dateAndTime.equals(this.dateAndTime);
        }

        @Override
        public int hashCode() {
            return 643 + 751 * this.dateAndTime.hashCode();
        }

        @Override
        public DateAndTime getDateAndTime() {
            return this.dateAndTime;
        }

        @Override
        public boolean hasDateAndTime() {
            return true;
        }

        @Override
        public Object clone() {
            return DateAndTimeLiteral.newInstance(this.getClass(), this.src, null, this.clone(this.dateAndTime));
        }
    }
}

