/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.CommonKeywordParameters;
import org.rascalmpl.ast.FunctionDeclaration;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Kind;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.Tags;
import org.rascalmpl.ast.Type;
import org.rascalmpl.ast.UserType;
import org.rascalmpl.ast.Variant;
import org.rascalmpl.ast.Visibility;

public abstract class Declaration
extends AbstractAST {
    public Declaration(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasTypes() {
        return false;
    }

    public List<Type> getTypes() {
        throw new UnsupportedOperationException();
    }

    public boolean hasVariables() {
        return false;
    }

    public List<org.rascalmpl.ast.Variable> getVariables() {
        throw new UnsupportedOperationException();
    }

    public boolean hasVariants() {
        return false;
    }

    public List<Variant> getVariants() {
        throw new UnsupportedOperationException();
    }

    public boolean hasCommonKeywordParameters() {
        return false;
    }

    public CommonKeywordParameters getCommonKeywordParameters() {
        throw new UnsupportedOperationException();
    }

    public boolean hasFunctionDeclaration() {
        return false;
    }

    public FunctionDeclaration getFunctionDeclaration() {
        throw new UnsupportedOperationException();
    }

    public boolean hasKind() {
        return false;
    }

    public Kind getKind() {
        throw new UnsupportedOperationException();
    }

    public boolean hasName() {
        return false;
    }

    public Name getName() {
        throw new UnsupportedOperationException();
    }

    public boolean hasTags() {
        return false;
    }

    public Tags getTags() {
        throw new UnsupportedOperationException();
    }

    public boolean hasAnnoType() {
        return false;
    }

    public Type getAnnoType() {
        throw new UnsupportedOperationException();
    }

    public boolean hasBase() {
        return false;
    }

    public Type getBase() {
        throw new UnsupportedOperationException();
    }

    public boolean hasOnType() {
        return false;
    }

    public Type getOnType() {
        throw new UnsupportedOperationException();
    }

    public boolean hasType() {
        return false;
    }

    public Type getType() {
        throw new UnsupportedOperationException();
    }

    public boolean hasUser() {
        return false;
    }

    public UserType getUser() {
        throw new UnsupportedOperationException();
    }

    public boolean hasVisibility() {
        return false;
    }

    public Visibility getVisibility() {
        throw new UnsupportedOperationException();
    }

    public boolean isAlias() {
        return false;
    }

    public boolean isAnnotation() {
        return false;
    }

    public boolean isData() {
        return false;
    }

    public boolean isDataAbstract() {
        return false;
    }

    public boolean isFunction() {
        return false;
    }

    public boolean isTag() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public static class Variable
    extends Declaration {
        private final Tags tags;
        private final Visibility visibility;
        private final Type type;
        private final List<org.rascalmpl.ast.Variable> variables;

        public Variable(ISourceLocation src, IConstructor node, Tags tags, Visibility visibility, Type type, List<org.rascalmpl.ast.Variable> variables) {
            super(src, node);
            this.tags = tags;
            this.visibility = visibility;
            this.type = type;
            this.variables = variables;
        }

        @Override
        public boolean isVariable() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitDeclarationVariable(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.tags.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tags.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.visibility.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.visibility.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.type.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.type.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.variables) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Variable)) {
                return false;
            }
            Variable tmp = (Variable)o;
            return tmp.tags.equals(this.tags) && tmp.visibility.equals(this.visibility) && tmp.type.equals(this.type) && tmp.variables.equals(this.variables);
        }

        @Override
        public int hashCode() {
            return 859 + 599 * this.tags.hashCode() + 643 * this.visibility.hashCode() + 853 * this.type.hashCode() + 3 * this.variables.hashCode();
        }

        @Override
        public Tags getTags() {
            return this.tags;
        }

        @Override
        public boolean hasTags() {
            return true;
        }

        @Override
        public Visibility getVisibility() {
            return this.visibility;
        }

        @Override
        public boolean hasVisibility() {
            return true;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean hasType() {
            return true;
        }

        @Override
        public List<org.rascalmpl.ast.Variable> getVariables() {
            return this.variables;
        }

        @Override
        public boolean hasVariables() {
            return true;
        }

        @Override
        public Object clone() {
            return Variable.newInstance(this.getClass(), this.src, null, this.clone(this.tags), this.clone(this.visibility), this.clone(this.type), this.clone(this.variables));
        }
    }

    public static class Tag
    extends Declaration {
        private final Tags tags;
        private final Visibility visibility;
        private final Kind kind;
        private final Name name;
        private final List<Type> types;

        public Tag(ISourceLocation src, IConstructor node, Tags tags, Visibility visibility, Kind kind, Name name, List<Type> types) {
            super(src, node);
            this.tags = tags;
            this.visibility = visibility;
            this.kind = kind;
            this.name = name;
            this.types = types;
        }

        @Override
        public boolean isTag() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitDeclarationTag(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.tags.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tags.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.visibility.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.visibility.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.kind.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.kind.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.name.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.types) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Tag)) {
                return false;
            }
            Tag tmp = (Tag)o;
            return tmp.tags.equals(this.tags) && tmp.visibility.equals(this.visibility) && tmp.kind.equals(this.kind) && tmp.name.equals(this.name) && tmp.types.equals(this.types);
        }

        @Override
        public int hashCode() {
            return 101 + 479 * this.tags.hashCode() + 137 * this.visibility.hashCode() + 223 * this.kind.hashCode() + 307 * this.name.hashCode() + 733 * this.types.hashCode();
        }

        @Override
        public Tags getTags() {
            return this.tags;
        }

        @Override
        public boolean hasTags() {
            return true;
        }

        @Override
        public Visibility getVisibility() {
            return this.visibility;
        }

        @Override
        public boolean hasVisibility() {
            return true;
        }

        @Override
        public Kind getKind() {
            return this.kind;
        }

        @Override
        public boolean hasKind() {
            return true;
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public boolean hasTypes() {
            return true;
        }

        @Override
        public Object clone() {
            return Tag.newInstance(this.getClass(), this.src, null, this.clone(this.tags), this.clone(this.visibility), this.clone(this.kind), this.clone(this.name), this.clone(this.types));
        }
    }

    public static class Function
    extends Declaration {
        private final FunctionDeclaration functionDeclaration;

        public Function(ISourceLocation src, IConstructor node, FunctionDeclaration functionDeclaration) {
            super(src, node);
            this.functionDeclaration = functionDeclaration;
        }

        @Override
        public boolean isFunction() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitDeclarationFunction(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.functionDeclaration.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.functionDeclaration.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Function)) {
                return false;
            }
            Function tmp = (Function)o;
            return tmp.functionDeclaration.equals(this.functionDeclaration);
        }

        @Override
        public int hashCode() {
            return 13 + 7 * this.functionDeclaration.hashCode();
        }

        @Override
        public FunctionDeclaration getFunctionDeclaration() {
            return this.functionDeclaration;
        }

        @Override
        public boolean hasFunctionDeclaration() {
            return true;
        }

        @Override
        public Object clone() {
            return Function.newInstance(this.getClass(), this.src, null, this.clone(this.functionDeclaration));
        }
    }

    public static class DataAbstract
    extends Declaration {
        private final Tags tags;
        private final Visibility visibility;
        private final UserType user;
        private final CommonKeywordParameters commonKeywordParameters;

        public DataAbstract(ISourceLocation src, IConstructor node, Tags tags, Visibility visibility, UserType user, CommonKeywordParameters commonKeywordParameters) {
            super(src, node);
            this.tags = tags;
            this.visibility = visibility;
            this.user = user;
            this.commonKeywordParameters = commonKeywordParameters;
        }

        @Override
        public boolean isDataAbstract() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitDeclarationDataAbstract(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.tags.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tags.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.visibility.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.visibility.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.user.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.user.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.commonKeywordParameters.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.commonKeywordParameters.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof DataAbstract)) {
                return false;
            }
            DataAbstract tmp = (DataAbstract)o;
            return tmp.tags.equals(this.tags) && tmp.visibility.equals(this.visibility) && tmp.user.equals(this.user) && tmp.commonKeywordParameters.equals(this.commonKeywordParameters);
        }

        @Override
        public int hashCode() {
            return 397 + 131 * this.tags.hashCode() + 863 * this.visibility.hashCode() + 211 * this.user.hashCode() + 593 * this.commonKeywordParameters.hashCode();
        }

        @Override
        public Tags getTags() {
            return this.tags;
        }

        @Override
        public boolean hasTags() {
            return true;
        }

        @Override
        public Visibility getVisibility() {
            return this.visibility;
        }

        @Override
        public boolean hasVisibility() {
            return true;
        }

        @Override
        public UserType getUser() {
            return this.user;
        }

        @Override
        public boolean hasUser() {
            return true;
        }

        @Override
        public CommonKeywordParameters getCommonKeywordParameters() {
            return this.commonKeywordParameters;
        }

        @Override
        public boolean hasCommonKeywordParameters() {
            return true;
        }

        @Override
        public Object clone() {
            return DataAbstract.newInstance(this.getClass(), this.src, null, this.clone(this.tags), this.clone(this.visibility), this.clone(this.user), this.clone(this.commonKeywordParameters));
        }
    }

    public static class Data
    extends Declaration {
        private final Tags tags;
        private final Visibility visibility;
        private final UserType user;
        private final CommonKeywordParameters commonKeywordParameters;
        private final List<Variant> variants;

        public Data(ISourceLocation src, IConstructor node, Tags tags, Visibility visibility, UserType user, CommonKeywordParameters commonKeywordParameters, List<Variant> variants) {
            super(src, node);
            this.tags = tags;
            this.visibility = visibility;
            this.user = user;
            this.commonKeywordParameters = commonKeywordParameters;
            this.variants = variants;
        }

        @Override
        public boolean isData() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitDeclarationData(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.tags.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tags.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.visibility.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.visibility.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.user.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.user.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.commonKeywordParameters.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.commonKeywordParameters.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.variants) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Data)) {
                return false;
            }
            Data tmp = (Data)o;
            return tmp.tags.equals(this.tags) && tmp.visibility.equals(this.visibility) && tmp.user.equals(this.user) && tmp.commonKeywordParameters.equals(this.commonKeywordParameters) && tmp.variants.equals(this.variants);
        }

        @Override
        public int hashCode() {
            return 281 + 101 * this.tags.hashCode() + 433 * this.visibility.hashCode() + 419 * this.user.hashCode() + 911 * this.commonKeywordParameters.hashCode() + 191 * this.variants.hashCode();
        }

        @Override
        public Tags getTags() {
            return this.tags;
        }

        @Override
        public boolean hasTags() {
            return true;
        }

        @Override
        public Visibility getVisibility() {
            return this.visibility;
        }

        @Override
        public boolean hasVisibility() {
            return true;
        }

        @Override
        public UserType getUser() {
            return this.user;
        }

        @Override
        public boolean hasUser() {
            return true;
        }

        @Override
        public CommonKeywordParameters getCommonKeywordParameters() {
            return this.commonKeywordParameters;
        }

        @Override
        public boolean hasCommonKeywordParameters() {
            return true;
        }

        @Override
        public List<Variant> getVariants() {
            return this.variants;
        }

        @Override
        public boolean hasVariants() {
            return true;
        }

        @Override
        public Object clone() {
            return Data.newInstance(this.getClass(), this.src, null, this.clone(this.tags), this.clone(this.visibility), this.clone(this.user), this.clone(this.commonKeywordParameters), this.clone(this.variants));
        }
    }

    public static class Annotation
    extends Declaration {
        private final Tags tags;
        private final Visibility visibility;
        private final Type annoType;
        private final Type onType;
        private final Name name;

        public Annotation(ISourceLocation src, IConstructor node, Tags tags, Visibility visibility, Type annoType, Type onType, Name name) {
            super(src, node);
            this.tags = tags;
            this.visibility = visibility;
            this.annoType = annoType;
            this.onType = onType;
            this.name = name;
        }

        @Override
        public boolean isAnnotation() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitDeclarationAnnotation(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.tags.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tags.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.visibility.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.visibility.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.annoType.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.annoType.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.onType.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.onType.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.name.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Annotation)) {
                return false;
            }
            Annotation tmp = (Annotation)o;
            return tmp.tags.equals(this.tags) && tmp.visibility.equals(this.visibility) && tmp.annoType.equals(this.annoType) && tmp.onType.equals(this.onType) && tmp.name.equals(this.name);
        }

        @Override
        public int hashCode() {
            return 137 + 983 * this.tags.hashCode() + 677 * this.visibility.hashCode() + 433 * this.annoType.hashCode() + 673 * this.onType.hashCode() + 13 * this.name.hashCode();
        }

        @Override
        public Tags getTags() {
            return this.tags;
        }

        @Override
        public boolean hasTags() {
            return true;
        }

        @Override
        public Visibility getVisibility() {
            return this.visibility;
        }

        @Override
        public boolean hasVisibility() {
            return true;
        }

        @Override
        public Type getAnnoType() {
            return this.annoType;
        }

        @Override
        public boolean hasAnnoType() {
            return true;
        }

        @Override
        public Type getOnType() {
            return this.onType;
        }

        @Override
        public boolean hasOnType() {
            return true;
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public Object clone() {
            return Annotation.newInstance(this.getClass(), this.src, null, this.clone(this.tags), this.clone(this.visibility), this.clone(this.annoType), this.clone(this.onType), this.clone(this.name));
        }
    }

    public static class Alias
    extends Declaration {
        private final Tags tags;
        private final Visibility visibility;
        private final UserType user;
        private final Type base;

        public Alias(ISourceLocation src, IConstructor node, Tags tags, Visibility visibility, UserType user, Type base) {
            super(src, node);
            this.tags = tags;
            this.visibility = visibility;
            this.user = user;
            this.base = base;
        }

        @Override
        public boolean isAlias() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitDeclarationAlias(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.tags.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tags.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.visibility.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.visibility.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.user.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.user.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.base.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.base.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Alias)) {
                return false;
            }
            Alias tmp = (Alias)o;
            return tmp.tags.equals(this.tags) && tmp.visibility.equals(this.visibility) && tmp.user.equals(this.user) && tmp.base.equals(this.base);
        }

        @Override
        public int hashCode() {
            return 313 + 73 * this.tags.hashCode() + 499 * this.visibility.hashCode() + 691 * this.user.hashCode() + 227 * this.base.hashCode();
        }

        @Override
        public Tags getTags() {
            return this.tags;
        }

        @Override
        public boolean hasTags() {
            return true;
        }

        @Override
        public Visibility getVisibility() {
            return this.visibility;
        }

        @Override
        public boolean hasVisibility() {
            return true;
        }

        @Override
        public UserType getUser() {
            return this.user;
        }

        @Override
        public boolean hasUser() {
            return true;
        }

        @Override
        public Type getBase() {
            return this.base;
        }

        @Override
        public boolean hasBase() {
            return true;
        }

        @Override
        public Object clone() {
            return Alias.newInstance(this.getClass(), this.src, null, this.clone(this.tags), this.clone(this.visibility), this.clone(this.user), this.clone(this.base));
        }
    }
}

