/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Name;

public abstract class Label
extends AbstractAST {
    public Label(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasName() {
        return false;
    }

    public Name getName() {
        throw new UnsupportedOperationException();
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public static class Empty
    extends Label {
        public Empty(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitLabelEmpty(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Empty)) {
                return false;
            }
            Empty tmp = (Empty)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 233;
        }

        @Override
        public Object clone() {
            return Empty.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class Default
    extends Label {
        private final Name name;

        public Default(ISourceLocation src, IConstructor node, Name name) {
            super(src, node);
            this.name = name;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitLabelDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.name.equals(this.name);
        }

        @Override
        public int hashCode() {
            return 653 + 701 * this.name.hashCode();
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.name));
        }
    }
}

