/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.PreProtocolChars;
import org.rascalmpl.ast.ProtocolChars;
import org.rascalmpl.ast.ProtocolTail;

public abstract class ProtocolPart
extends AbstractAST {
    public ProtocolPart(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasExpression() {
        return false;
    }

    public Expression getExpression() {
        throw new UnsupportedOperationException();
    }

    public boolean hasPre() {
        return false;
    }

    public PreProtocolChars getPre() {
        throw new UnsupportedOperationException();
    }

    public boolean hasProtocolChars() {
        return false;
    }

    public ProtocolChars getProtocolChars() {
        throw new UnsupportedOperationException();
    }

    public boolean hasTail() {
        return false;
    }

    public ProtocolTail getTail() {
        throw new UnsupportedOperationException();
    }

    public boolean isInterpolated() {
        return false;
    }

    public boolean isNonInterpolated() {
        return false;
    }

    public static class NonInterpolated
    extends ProtocolPart {
        private final ProtocolChars protocolChars;

        public NonInterpolated(ISourceLocation src, IConstructor node, ProtocolChars protocolChars) {
            super(src, node);
            this.protocolChars = protocolChars;
        }

        @Override
        public boolean isNonInterpolated() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitProtocolPartNonInterpolated(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.protocolChars.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.protocolChars.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof NonInterpolated)) {
                return false;
            }
            NonInterpolated tmp = (NonInterpolated)o;
            return tmp.protocolChars.equals(this.protocolChars);
        }

        @Override
        public int hashCode() {
            return 73 + 439 * this.protocolChars.hashCode();
        }

        @Override
        public ProtocolChars getProtocolChars() {
            return this.protocolChars;
        }

        @Override
        public boolean hasProtocolChars() {
            return true;
        }

        @Override
        public Object clone() {
            return NonInterpolated.newInstance(this.getClass(), this.src, null, this.clone(this.protocolChars));
        }
    }

    public static class Interpolated
    extends ProtocolPart {
        private final PreProtocolChars pre;
        private final Expression expression;
        private final ProtocolTail tail;

        public Interpolated(ISourceLocation src, IConstructor node, PreProtocolChars pre, Expression expression, ProtocolTail tail) {
            super(src, node);
            this.pre = pre;
            this.expression = expression;
            this.tail = tail;
        }

        @Override
        public boolean isInterpolated() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitProtocolPartInterpolated(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.pre.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.pre.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.expression.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.expression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.tail.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tail.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Interpolated)) {
                return false;
            }
            Interpolated tmp = (Interpolated)o;
            return tmp.pre.equals(this.pre) && tmp.expression.equals(this.expression) && tmp.tail.equals(this.tail);
        }

        @Override
        public int hashCode() {
            return 701 + 283 * this.pre.hashCode() + 349 * this.expression.hashCode() + 139 * this.tail.hashCode();
        }

        @Override
        public PreProtocolChars getPre() {
            return this.pre;
        }

        @Override
        public boolean hasPre() {
            return true;
        }

        @Override
        public Expression getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasExpression() {
            return true;
        }

        @Override
        public ProtocolTail getTail() {
            return this.tail;
        }

        @Override
        public boolean hasTail() {
            return true;
        }

        @Override
        public Object clone() {
            return Interpolated.newInstance(this.getClass(), this.src, null, this.clone(this.pre), this.clone(this.expression), this.clone(this.tail));
        }
    }
}

