/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.MidProtocolChars;
import org.rascalmpl.ast.PostProtocolChars;

public abstract class ProtocolTail
extends AbstractAST {
    public ProtocolTail(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasExpression() {
        return false;
    }

    public Expression getExpression() {
        throw new UnsupportedOperationException();
    }

    public boolean hasMid() {
        return false;
    }

    public MidProtocolChars getMid() {
        throw new UnsupportedOperationException();
    }

    public boolean hasPost() {
        return false;
    }

    public PostProtocolChars getPost() {
        throw new UnsupportedOperationException();
    }

    public boolean hasTail() {
        return false;
    }

    public ProtocolTail getTail() {
        throw new UnsupportedOperationException();
    }

    public boolean isMid() {
        return false;
    }

    public boolean isPost() {
        return false;
    }

    public static class Post
    extends ProtocolTail {
        private final PostProtocolChars post;

        public Post(ISourceLocation src, IConstructor node, PostProtocolChars post) {
            super(src, node);
            this.post = post;
        }

        @Override
        public boolean isPost() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitProtocolTailPost(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.post.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.post.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Post)) {
                return false;
            }
            Post tmp = (Post)o;
            return tmp.post.equals(this.post);
        }

        @Override
        public int hashCode() {
            return 673 + 233 * this.post.hashCode();
        }

        @Override
        public PostProtocolChars getPost() {
            return this.post;
        }

        @Override
        public boolean hasPost() {
            return true;
        }

        @Override
        public Object clone() {
            return Post.newInstance(this.getClass(), this.src, null, this.clone(this.post));
        }
    }

    public static class Mid
    extends ProtocolTail {
        private final MidProtocolChars mid;
        private final Expression expression;
        private final ProtocolTail tail;

        public Mid(ISourceLocation src, IConstructor node, MidProtocolChars mid, Expression expression, ProtocolTail tail) {
            super(src, node);
            this.mid = mid;
            this.expression = expression;
            this.tail = tail;
        }

        @Override
        public boolean isMid() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitProtocolTailMid(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.mid.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.mid.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.expression.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.expression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.tail.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tail.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Mid)) {
                return false;
            }
            Mid tmp = (Mid)o;
            return tmp.mid.equals(this.mid) && tmp.expression.equals(this.expression) && tmp.tail.equals(this.tail);
        }

        @Override
        public int hashCode() {
            return 191 + 89 * this.mid.hashCode() + 787 * this.expression.hashCode() + 73 * this.tail.hashCode();
        }

        @Override
        public MidProtocolChars getMid() {
            return this.mid;
        }

        @Override
        public boolean hasMid() {
            return true;
        }

        @Override
        public Expression getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasExpression() {
            return true;
        }

        @Override
        public ProtocolTail getTail() {
            return this.tail;
        }

        @Override
        public boolean hasTail() {
            return true;
        }

        @Override
        public Object clone() {
            return Mid.newInstance(this.getClass(), this.src, null, this.clone(this.mid), this.clone(this.expression), this.clone(this.tail));
        }
    }
}

