/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Char;
import org.rascalmpl.ast.IASTVisitor;

public abstract class Range
extends AbstractAST {
    public Range(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasCharacter() {
        return false;
    }

    public Char getCharacter() {
        throw new UnsupportedOperationException();
    }

    public boolean hasEnd() {
        return false;
    }

    public Char getEnd() {
        throw new UnsupportedOperationException();
    }

    public boolean hasStart() {
        return false;
    }

    public Char getStart() {
        throw new UnsupportedOperationException();
    }

    public boolean isCharacter() {
        return false;
    }

    public boolean isFromTo() {
        return false;
    }

    public static class FromTo
    extends Range {
        private final Char start;
        private final Char end;

        public FromTo(ISourceLocation src, IConstructor node, Char start, Char end) {
            super(src, node);
            this.start = start;
            this.end = end;
        }

        @Override
        public boolean isFromTo() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitRangeFromTo(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.start.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.start.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.end.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.end.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof FromTo)) {
                return false;
            }
            FromTo tmp = (FromTo)o;
            return tmp.start.equals(this.start) && tmp.end.equals(this.end);
        }

        @Override
        public int hashCode() {
            return 233 + 709 * this.start.hashCode() + 503 * this.end.hashCode();
        }

        @Override
        public Char getStart() {
            return this.start;
        }

        @Override
        public boolean hasStart() {
            return true;
        }

        @Override
        public Char getEnd() {
            return this.end;
        }

        @Override
        public boolean hasEnd() {
            return true;
        }

        @Override
        public Object clone() {
            return FromTo.newInstance(this.getClass(), this.src, null, this.clone(this.start), this.clone(this.end));
        }
    }

    public static class Character
    extends Range {
        private final Char character;

        public Character(ISourceLocation src, IConstructor node, Char character) {
            super(src, node);
            this.character = character;
        }

        @Override
        public boolean isCharacter() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitRangeCharacter(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.character.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.character.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Character)) {
                return false;
            }
            Character tmp = (Character)o;
            return tmp.character.equals(this.character);
        }

        @Override
        public int hashCode() {
            return 499 + 919 * this.character.hashCode();
        }

        @Override
        public Char getCharacter() {
            return this.character;
        }

        @Override
        public boolean hasCharacter() {
            return true;
        }

        @Override
        public Object clone() {
            return Character.newInstance(this.getClass(), this.src, null, this.clone(this.character));
        }
    }
}

