/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.MidStringChars;
import org.rascalmpl.ast.StringTemplate;

public abstract class StringMiddle
extends AbstractAST {
    public StringMiddle(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasExpression() {
        return false;
    }

    public Expression getExpression() {
        throw new UnsupportedOperationException();
    }

    public boolean hasMid() {
        return false;
    }

    public MidStringChars getMid() {
        throw new UnsupportedOperationException();
    }

    public boolean hasTail() {
        return false;
    }

    public StringMiddle getTail() {
        throw new UnsupportedOperationException();
    }

    public boolean hasTemplate() {
        return false;
    }

    public StringTemplate getTemplate() {
        throw new UnsupportedOperationException();
    }

    public boolean isInterpolated() {
        return false;
    }

    public boolean isMid() {
        return false;
    }

    public boolean isTemplate() {
        return false;
    }

    public static class Template
    extends StringMiddle {
        private final MidStringChars mid;
        private final StringTemplate template;
        private final StringMiddle tail;

        public Template(ISourceLocation src, IConstructor node, MidStringChars mid, StringTemplate template, StringMiddle tail) {
            super(src, node);
            this.mid = mid;
            this.template = template;
            this.tail = tail;
        }

        @Override
        public boolean isTemplate() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStringMiddleTemplate(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.mid.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.mid.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.template.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.template.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.tail.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tail.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Template)) {
                return false;
            }
            Template tmp = (Template)o;
            return tmp.mid.equals(this.mid) && tmp.template.equals(this.template) && tmp.tail.equals(this.tail);
        }

        @Override
        public int hashCode() {
            return 521 + 839 * this.mid.hashCode() + 191 * this.template.hashCode() + 599 * this.tail.hashCode();
        }

        @Override
        public MidStringChars getMid() {
            return this.mid;
        }

        @Override
        public boolean hasMid() {
            return true;
        }

        @Override
        public StringTemplate getTemplate() {
            return this.template;
        }

        @Override
        public boolean hasTemplate() {
            return true;
        }

        @Override
        public StringMiddle getTail() {
            return this.tail;
        }

        @Override
        public boolean hasTail() {
            return true;
        }

        @Override
        public Object clone() {
            return Template.newInstance(this.getClass(), this.src, null, this.clone(this.mid), this.clone(this.template), this.clone(this.tail));
        }
    }

    public static class Mid
    extends StringMiddle {
        private final MidStringChars mid;

        public Mid(ISourceLocation src, IConstructor node, MidStringChars mid) {
            super(src, node);
            this.mid = mid;
        }

        @Override
        public boolean isMid() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStringMiddleMid(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.mid.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.mid.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Mid)) {
                return false;
            }
            Mid tmp = (Mid)o;
            return tmp.mid.equals(this.mid);
        }

        @Override
        public int hashCode() {
            return 131 + 331 * this.mid.hashCode();
        }

        @Override
        public MidStringChars getMid() {
            return this.mid;
        }

        @Override
        public boolean hasMid() {
            return true;
        }

        @Override
        public Object clone() {
            return Mid.newInstance(this.getClass(), this.src, null, this.clone(this.mid));
        }
    }

    public static class Interpolated
    extends StringMiddle {
        private final MidStringChars mid;
        private final Expression expression;
        private final StringMiddle tail;

        public Interpolated(ISourceLocation src, IConstructor node, MidStringChars mid, Expression expression, StringMiddle tail) {
            super(src, node);
            this.mid = mid;
            this.expression = expression;
            this.tail = tail;
        }

        @Override
        public boolean isInterpolated() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStringMiddleInterpolated(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.mid.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.mid.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.expression.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.expression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.tail.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tail.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Interpolated)) {
                return false;
            }
            Interpolated tmp = (Interpolated)o;
            return tmp.mid.equals(this.mid) && tmp.expression.equals(this.expression) && tmp.tail.equals(this.tail);
        }

        @Override
        public int hashCode() {
            return 653 + 13 * this.mid.hashCode() + 787 * this.expression.hashCode() + 37 * this.tail.hashCode();
        }

        @Override
        public MidStringChars getMid() {
            return this.mid;
        }

        @Override
        public boolean hasMid() {
            return true;
        }

        @Override
        public Expression getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasExpression() {
            return true;
        }

        @Override
        public StringMiddle getTail() {
            return this.tail;
        }

        @Override
        public boolean hasTail() {
            return true;
        }

        @Override
        public Object clone() {
            return Interpolated.newInstance(this.getClass(), this.src, null, this.clone(this.mid), this.clone(this.expression), this.clone(this.tail));
        }
    }
}

