/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.MidStringChars;
import org.rascalmpl.ast.PostStringChars;
import org.rascalmpl.ast.StringTemplate;

public abstract class StringTail
extends AbstractAST {
    public StringTail(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasExpression() {
        return false;
    }

    public Expression getExpression() {
        throw new UnsupportedOperationException();
    }

    public boolean hasMid() {
        return false;
    }

    public MidStringChars getMid() {
        throw new UnsupportedOperationException();
    }

    public boolean hasPost() {
        return false;
    }

    public PostStringChars getPost() {
        throw new UnsupportedOperationException();
    }

    public boolean hasTail() {
        return false;
    }

    public StringTail getTail() {
        throw new UnsupportedOperationException();
    }

    public boolean hasTemplate() {
        return false;
    }

    public StringTemplate getTemplate() {
        throw new UnsupportedOperationException();
    }

    public boolean isMidInterpolated() {
        return false;
    }

    public boolean isMidTemplate() {
        return false;
    }

    public boolean isPost() {
        return false;
    }

    public static class Post
    extends StringTail {
        private final PostStringChars post;

        public Post(ISourceLocation src, IConstructor node, PostStringChars post) {
            super(src, node);
            this.post = post;
        }

        @Override
        public boolean isPost() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStringTailPost(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.post.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.post.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Post)) {
                return false;
            }
            Post tmp = (Post)o;
            return tmp.post.equals(this.post);
        }

        @Override
        public int hashCode() {
            return 547 + 283 * this.post.hashCode();
        }

        @Override
        public PostStringChars getPost() {
            return this.post;
        }

        @Override
        public boolean hasPost() {
            return true;
        }

        @Override
        public Object clone() {
            return Post.newInstance(this.getClass(), this.src, null, this.clone(this.post));
        }
    }

    public static class MidTemplate
    extends StringTail {
        private final MidStringChars mid;
        private final StringTemplate template;
        private final StringTail tail;

        public MidTemplate(ISourceLocation src, IConstructor node, MidStringChars mid, StringTemplate template, StringTail tail) {
            super(src, node);
            this.mid = mid;
            this.template = template;
            this.tail = tail;
        }

        @Override
        public boolean isMidTemplate() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStringTailMidTemplate(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.mid.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.mid.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.template.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.template.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.tail.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tail.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof MidTemplate)) {
                return false;
            }
            MidTemplate tmp = (MidTemplate)o;
            return tmp.mid.equals(this.mid) && tmp.template.equals(this.template) && tmp.tail.equals(this.tail);
        }

        @Override
        public int hashCode() {
            return 281 + 409 * this.mid.hashCode() + 97 * this.template.hashCode() + 607 * this.tail.hashCode();
        }

        @Override
        public MidStringChars getMid() {
            return this.mid;
        }

        @Override
        public boolean hasMid() {
            return true;
        }

        @Override
        public StringTemplate getTemplate() {
            return this.template;
        }

        @Override
        public boolean hasTemplate() {
            return true;
        }

        @Override
        public StringTail getTail() {
            return this.tail;
        }

        @Override
        public boolean hasTail() {
            return true;
        }

        @Override
        public Object clone() {
            return MidTemplate.newInstance(this.getClass(), this.src, null, this.clone(this.mid), this.clone(this.template), this.clone(this.tail));
        }
    }

    public static class MidInterpolated
    extends StringTail {
        private final MidStringChars mid;
        private final Expression expression;
        private final StringTail tail;

        public MidInterpolated(ISourceLocation src, IConstructor node, MidStringChars mid, Expression expression, StringTail tail) {
            super(src, node);
            this.mid = mid;
            this.expression = expression;
            this.tail = tail;
        }

        @Override
        public boolean isMidInterpolated() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStringTailMidInterpolated(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.mid.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.mid.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.expression.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.expression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.tail.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tail.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof MidInterpolated)) {
                return false;
            }
            MidInterpolated tmp = (MidInterpolated)o;
            return tmp.mid.equals(this.mid) && tmp.expression.equals(this.expression) && tmp.tail.equals(this.tail);
        }

        @Override
        public int hashCode() {
            return 109 + 977 * this.mid.hashCode() + 2 * this.expression.hashCode() + 947 * this.tail.hashCode();
        }

        @Override
        public MidStringChars getMid() {
            return this.mid;
        }

        @Override
        public boolean hasMid() {
            return true;
        }

        @Override
        public Expression getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasExpression() {
            return true;
        }

        @Override
        public StringTail getTail() {
            return this.tail;
        }

        @Override
        public boolean hasTail() {
            return true;
        }

        @Override
        public Object clone() {
            return MidInterpolated.newInstance(this.getClass(), this.src, null, this.clone(this.mid), this.clone(this.expression), this.clone(this.tail));
        }
    }
}

