/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Prod;
import org.rascalmpl.ast.Start;
import org.rascalmpl.ast.Sym;
import org.rascalmpl.ast.Visibility;

public abstract class SyntaxDefinition
extends AbstractAST {
    public SyntaxDefinition(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasProduction() {
        return false;
    }

    public Prod getProduction() {
        throw new UnsupportedOperationException();
    }

    public boolean hasStart() {
        return false;
    }

    public Start getStart() {
        throw new UnsupportedOperationException();
    }

    public boolean hasDefined() {
        return false;
    }

    public Sym getDefined() {
        throw new UnsupportedOperationException();
    }

    public boolean hasVis() {
        return false;
    }

    public Visibility getVis() {
        throw new UnsupportedOperationException();
    }

    public boolean isKeyword() {
        return false;
    }

    public boolean isLanguage() {
        return false;
    }

    public boolean isLayout() {
        return false;
    }

    public boolean isLexical() {
        return false;
    }

    public static class Lexical
    extends SyntaxDefinition {
        private final Sym defined;
        private final Prod production;

        public Lexical(ISourceLocation src, IConstructor node, Sym defined, Prod production) {
            super(src, node);
            this.defined = defined;
            this.production = production;
        }

        @Override
        public boolean isLexical() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSyntaxDefinitionLexical(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.defined.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.defined.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.production.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.production.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Lexical)) {
                return false;
            }
            Lexical tmp = (Lexical)o;
            return tmp.defined.equals(this.defined) && tmp.production.equals(this.production);
        }

        @Override
        public int hashCode() {
            return 241 + 911 * this.defined.hashCode() + 827 * this.production.hashCode();
        }

        @Override
        public Sym getDefined() {
            return this.defined;
        }

        @Override
        public boolean hasDefined() {
            return true;
        }

        @Override
        public Prod getProduction() {
            return this.production;
        }

        @Override
        public boolean hasProduction() {
            return true;
        }

        @Override
        public Object clone() {
            return Lexical.newInstance(this.getClass(), this.src, null, this.clone(this.defined), this.clone(this.production));
        }
    }

    public static class Layout
    extends SyntaxDefinition {
        private final Visibility vis;
        private final Sym defined;
        private final Prod production;

        public Layout(ISourceLocation src, IConstructor node, Visibility vis, Sym defined, Prod production) {
            super(src, node);
            this.vis = vis;
            this.defined = defined;
            this.production = production;
        }

        @Override
        public boolean isLayout() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSyntaxDefinitionLayout(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.vis.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.vis.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.defined.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.defined.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.production.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.production.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Layout)) {
                return false;
            }
            Layout tmp = (Layout)o;
            return tmp.vis.equals(this.vis) && tmp.defined.equals(this.defined) && tmp.production.equals(this.production);
        }

        @Override
        public int hashCode() {
            return 269 + 839 * this.vis.hashCode() + 743 * this.defined.hashCode() + 751 * this.production.hashCode();
        }

        @Override
        public Visibility getVis() {
            return this.vis;
        }

        @Override
        public boolean hasVis() {
            return true;
        }

        @Override
        public Sym getDefined() {
            return this.defined;
        }

        @Override
        public boolean hasDefined() {
            return true;
        }

        @Override
        public Prod getProduction() {
            return this.production;
        }

        @Override
        public boolean hasProduction() {
            return true;
        }

        @Override
        public Object clone() {
            return Layout.newInstance(this.getClass(), this.src, null, this.clone(this.vis), this.clone(this.defined), this.clone(this.production));
        }
    }

    public static class Language
    extends SyntaxDefinition {
        private final Start start;
        private final Sym defined;
        private final Prod production;

        public Language(ISourceLocation src, IConstructor node, Start start, Sym defined, Prod production) {
            super(src, node);
            this.start = start;
            this.defined = defined;
            this.production = production;
        }

        @Override
        public boolean isLanguage() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSyntaxDefinitionLanguage(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.start.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.start.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.defined.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.defined.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.production.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.production.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Language)) {
                return false;
            }
            Language tmp = (Language)o;
            return tmp.start.equals(this.start) && tmp.defined.equals(this.defined) && tmp.production.equals(this.production);
        }

        @Override
        public int hashCode() {
            return 229 + 193 * this.start.hashCode() + 617 * this.defined.hashCode() + 521 * this.production.hashCode();
        }

        @Override
        public Start getStart() {
            return this.start;
        }

        @Override
        public boolean hasStart() {
            return true;
        }

        @Override
        public Sym getDefined() {
            return this.defined;
        }

        @Override
        public boolean hasDefined() {
            return true;
        }

        @Override
        public Prod getProduction() {
            return this.production;
        }

        @Override
        public boolean hasProduction() {
            return true;
        }

        @Override
        public Object clone() {
            return Language.newInstance(this.getClass(), this.src, null, this.clone(this.start), this.clone(this.defined), this.clone(this.production));
        }
    }

    public static class Keyword
    extends SyntaxDefinition {
        private final Sym defined;
        private final Prod production;

        public Keyword(ISourceLocation src, IConstructor node, Sym defined, Prod production) {
            super(src, node);
            this.defined = defined;
            this.production = production;
        }

        @Override
        public boolean isKeyword() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSyntaxDefinitionKeyword(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.defined.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.defined.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.production.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.production.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Keyword)) {
                return false;
            }
            Keyword tmp = (Keyword)o;
            return tmp.defined.equals(this.defined) && tmp.production.equals(this.production);
        }

        @Override
        public int hashCode() {
            return 443 + 11 * this.defined.hashCode() + 389 * this.production.hashCode();
        }

        @Override
        public Sym getDefined() {
            return this.defined;
        }

        @Override
        public boolean hasDefined() {
            return true;
        }

        @Override
        public Prod getProduction() {
            return this.production;
        }

        @Override
        public boolean hasProduction() {
            return true;
        }

        @Override
        public Object clone() {
            return Keyword.newInstance(this.getClass(), this.src, null, this.clone(this.defined), this.clone(this.production));
        }
    }
}

