/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.debug;

import io.usethesource.vallang.ISourceLocation;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jline.terminal.Terminal;
import org.rascalmpl.interpreter.BatchProgressMonitor;
import org.rascalmpl.interpreter.NullRascalMonitor;
import org.rascalmpl.repl.TerminalProgressBarMonitor;

public interface IRascalMonitor {
    public void jobStart(String var1, int var2, int var3);

    default public void jobStart(String name) {
        this.jobStart(name, 1, 100);
    }

    default public void jobStart(String name, int totalWork) {
        this.jobStart(name, 1, totalWork);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T job(String name, int totalWork, Supplier<T> block) {
        boolean result = false;
        try {
            this.jobStart(name, totalWork);
            T t2 = block.get();
            return t2;
        }
        finally {
            this.jobEnd(name, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T job(String name, int totalWork, Function<String, T> block) {
        boolean result = false;
        try {
            this.jobStart(name, totalWork);
            T t2 = block.apply(name);
            return t2;
        }
        finally {
            this.jobEnd(name, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T job(String name, int totalWork, BiFunction<String, BiConsumer<String, Integer>, T> block) {
        boolean result = false;
        try {
            this.jobStart(name, totalWork);
            T t2 = block.apply(name, (msg, worked) -> this.jobStep(name, (String)msg, (int)worked));
            return t2;
        }
        finally {
            this.jobEnd(name, result);
        }
    }

    public void jobStep(String var1, String var2, int var3);

    default public void jobStep(String name, String message) {
        this.jobStep(name, message, 1);
    }

    public int jobEnd(String var1, boolean var2);

    public boolean jobIsCanceled(String var1);

    public void jobTodo(String var1, int var2);

    public void endAllJobs();

    public void warning(String var1, ISourceLocation var2);

    public static IRascalMonitor buildConsoleMonitor(Terminal term) {
        return IRascalMonitor.buildConsoleMonitor(term, IRascalMonitor.inBatchMode());
    }

    public static boolean inBatchMode() {
        return "true".equals(System.getenv("CI")) || System.getProperty("rascal.monitor.batch") != null;
    }

    public static IRascalMonitor buildConsoleMonitor(Terminal terminal, boolean batchMode) {
        return !batchMode && TerminalProgressBarMonitor.shouldWorkIn(terminal) ? new TerminalProgressBarMonitor(terminal) : new BatchProgressMonitor(terminal.writer());
    }

    default public IRascalMonitor buildNullMonitor() {
        return new NullRascalMonitor();
    }
}

