/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.type.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.AbstractMatchingResult;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.matching.IVarPattern;
import org.rascalmpl.interpreter.matching.TuplePattern;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.semantics.dynamic.Tree;
import org.rascalmpl.types.RascalType;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class ConcreteApplicationPattern
extends AbstractMatchingResult {
    private IList subjectArgs;
    private final IMatchingResult tupleMatcher;
    private IConstructor production;
    private final ITuple tupleSubject;
    private final Type myType;
    private boolean isLiteral;

    public ConcreteApplicationPattern(IEvaluatorContext ctx, Tree.Appl x, List<IMatchingResult> list) {
        super(ctx, x);
        this.production = x.getProduction();
        this.tupleMatcher = new TuplePattern(ctx, x, list);
        this.tupleSubject = new TreeAsTuple();
        this.myType = x.getConcreteSyntaxType();
    }

    @Override
    public List<IVarPattern> getVariables() {
        return this.tupleMatcher.getVariables();
    }

    @Override
    public void initMatch(Result<IValue> subject) {
        this.hasNext = false;
        Type subjectType = subject.getValue().getType();
        super.initMatch(subject);
        if (subjectType.isExternalType() && ((RascalType)subjectType).isNonterminal() && subject.getValue() instanceof ITree) {
            ITree treeSubject = (ITree)subject.getValue();
            if (!TreeAdapter.isAppl(treeSubject)) {
                this.hasNext = false;
                return;
            }
            if (!TreeAdapter.getProduction(treeSubject).equals(this.production)) {
                this.hasNext = false;
                return;
            }
            IConstructor symbol = ProductionAdapter.getType(this.production);
            if (!SymbolAdapter.isLiteral(symbol) && !SymbolAdapter.isCILiteral(symbol)) {
                this.subjectArgs = TreeAdapter.getNonLayoutArgs(treeSubject);
                this.tupleMatcher.initMatch(ResultFactory.makeResult(this.tupleSubject.getType(), this.tupleSubject, this.ctx));
                this.hasNext = this.tupleMatcher.hasNext();
                this.isLiteral = false;
            } else {
                this.isLiteral = true;
                this.hasNext = true;
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.isLiteral) {
            return this.tupleMatcher.hasNext();
        }
        return true;
    }

    @Override
    public boolean next() {
        this.checkInitialized();
        if (this.hasNext && !this.isLiteral) {
            return this.tupleMatcher.next();
        }
        if (this.hasNext) {
            this.hasNext = false;
            return true;
        }
        return false;
    }

    @Override
    public Type getType(Environment env, HashMap<String, IVarPattern> patternVars) {
        return this.myType;
    }

    public String toString() {
        return this.production.toString();
    }

    private class TreeAsTuple
    implements ITuple {
        private TreeAsTuple() {
        }

        @Override
        public int arity() {
            return ConcreteApplicationPattern.this.subjectArgs.length();
        }

        @Override
        public IValue get(int i) throws IndexOutOfBoundsException {
            return ConcreteApplicationPattern.this.subjectArgs.get(i);
        }

        @Override
        public Type getType() {
            Type[] fields = new Type[this.arity()];
            for (int i = 0; i < fields.length; ++i) {
                fields[i] = this.get(i).getType();
            }
            return ConcreteApplicationPattern.this.tf.tupleType(fields);
        }

        @Override
        public Iterator<IValue> iterator() {
            return new Iterator<IValue>(){
                int currentIndex = 0;

                @Override
                public boolean hasNext() {
                    return this.currentIndex < TreeAsTuple.this.arity();
                }

                @Override
                public IValue next() {
                    return TreeAsTuple.this.get(this.currentIndex++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public IValue get(String label) throws FactTypeUseException {
            throw new UnsupportedOperationException();
        }

        @Override
        public IValue select(int ... fields) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public IValue selectByFieldNames(String ... fields) throws FactTypeUseException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ITuple set(int i, IValue arg) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ITuple set(String label, IValue arg) throws FactTypeUseException {
            throw new UnsupportedOperationException();
        }
    }
}

