/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.control_exceptions.Failure;
import org.rascalmpl.interpreter.control_exceptions.MatchFailed;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.types.RascalType;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class AbstractPatternDispatchedFunction
extends AbstractFunction {
    private final Map<String, List<AbstractFunction>> alternatives;
    private final int arity;
    private final boolean isStatic;
    private final String name;
    private final int index;

    public AbstractPatternDispatchedFunction(IEvaluator<Result<IValue>> eval, int index, String name, Map<String, List<AbstractFunction>> alternatives) {
        super(null, eval, alternatives.values().stream().flatMap(l -> l.stream()).map(f -> f.getStaticType()).reduce(TF.voidType(), (it, n) -> it.lub((Type)n)), alternatives.values().stream().flatMap(l -> l.stream()).map(f -> f.getType()).reduce(TF.voidType(), (it, n) -> it.lub((Type)n)), Collections.emptyList(), AbstractPatternDispatchedFunction.checkVarArgs(alternatives), null);
        this.index = index;
        this.alternatives = alternatives;
        this.arity = AbstractPatternDispatchedFunction.minArity(alternatives);
        this.isStatic = AbstractPatternDispatchedFunction.checkStatic(alternatives);
        this.name = name;
    }

    @Override
    public int getIndexedArgumentPosition() {
        return this.index;
    }

    @Override
    public AbstractPatternDispatchedFunction cloneInto(Environment env) {
        HashMap<String, List<AbstractFunction>> newAlts = new HashMap<String, List<AbstractFunction>>();
        for (String name : this.alternatives.keySet()) {
            ArrayList<AbstractFunction> alts = new ArrayList<AbstractFunction>();
            for (AbstractFunction alt : (List)newAlts.get(name)) {
                alts.add((AbstractFunction)alt.cloneInto(env));
            }
            newAlts.put(name, alts);
        }
        return new AbstractPatternDispatchedFunction(this.getEval(), this.index, this.name, newAlts);
    }

    public Map<String, List<AbstractFunction>> getMap() {
        return this.alternatives;
    }

    @Override
    public boolean isPatternDispatched() {
        return true;
    }

    private static boolean checkVarArgs(Map<String, List<AbstractFunction>> alts) {
        int arity = -1;
        for (List<AbstractFunction> l : alts.values()) {
            for (AbstractFunction f : l) {
                if (arity != -1) {
                    if (arity != f.getArity()) {
                        return true;
                    }
                } else {
                    arity = f.getArity();
                }
                if (!f.hasVarArgs()) continue;
                return true;
            }
        }
        return false;
    }

    private static int minArity(Map<String, List<AbstractFunction>> alts) {
        int min2 = Integer.MAX_VALUE;
        for (List<AbstractFunction> l : alts.values()) {
            for (AbstractFunction f : l) {
                if (f.getArity() >= min2) continue;
                min2 = f.getArity();
            }
        }
        return min2;
    }

    @Override
    public Type getStaticType() {
        return this.type;
    }

    @Override
    public Type getFunctionType() {
        return super.getStaticType();
    }

    @Override
    public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
        return v.visitExternal(this);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() == this.getClass()) {
            AbstractPatternDispatchedFunction other = (AbstractPatternDispatchedFunction)arg0;
            return other.alternatives.equals(this.alternatives);
        }
        return false;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public Result<IValue> call(Type[] argTypes, IValue[] argValues, Map<String, IValue> keyArgValues) {
        String label = null;
        if (argTypes.length < this.index) {
            throw new MatchFailed();
        }
        Type indexedType = argValues[this.index].getType();
        if (indexedType.isAbstractData() || indexedType.isConstructor() || indexedType.isExternalType() && ((RascalType)indexedType).isNonterminal()) {
            IConstructor cons = (IConstructor)argValues[this.index];
            label = cons.getConstructorType().getName();
            List<AbstractFunction> funcs = this.alternatives.get(label);
            if (funcs == null && cons.getConstructorType() == RascalValueFactory.Tree_Appl) {
                label = TreeAdapter.getConstructorName((ITree)cons);
                funcs = this.alternatives.get(label);
            }
            if (funcs != null) {
                for (AbstractFunction candidate : funcs) {
                    if ((!candidate.hasVarArgs() || argValues.length < candidate.getArity() - 1) && candidate.getArity() != argValues.length) continue;
                    try {
                        return candidate.call(argTypes, argValues, keyArgValues);
                    }
                    catch (MatchFailed matchFailed) {
                    }
                    catch (Failure failure) {
                    }
                }
                throw new MatchFailed();
            }
        }
        throw new MatchFailed();
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    private static boolean checkStatic(Map<String, List<AbstractFunction>> m4) {
        for (List<AbstractFunction> l : m4.values()) {
            for (AbstractFunction f : l) {
                if (f.isStatic()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        for (List<AbstractFunction> l : this.alternatives.values()) {
            for (AbstractFunction f : l) {
                b.append(f.toString() + " (abstract pattern); ");
            }
            b.append(' ');
        }
        return b.toString();
    }
}

