/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.type.TypeFactory;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.BoolResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;

public class LessThanOrEqualResult
extends BoolResult {
    private final boolean less;
    private final boolean equal;

    public LessThanOrEqualResult(boolean less, boolean equal, IEvaluatorContext ctx) {
        super(TypeFactory.getInstance().boolType(), ctx.getValueFactory().bool(less || equal), ctx);
        this.less = less;
        this.equal = equal;
        if (less && equal) {
            throw new ImplementationError("something can not be both less and equal at the same time");
        }
    }

    public boolean getLess() {
        return this.less;
    }

    public boolean getEqual() {
        return this.equal;
    }

    public Result<IBool> isLess() {
        return ResultFactory.bool(this.less, this.ctx);
    }

    public Result<IBool> isEqual() {
        return ResultFactory.bool(this.equal, this.ctx);
    }
}

