/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.exceptions.UndeclaredFieldException;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeStore;
import java.util.Iterator;
import java.util.Map;
import org.rascalmpl.ast.Field;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.ElementResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.ListRelationResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.UndeclaredField;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.staticErrors.UnsupportedOperation;
import org.rascalmpl.interpreter.staticErrors.UnsupportedSubscriptArity;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.values.ValueFactoryFactory;

public class MapResult
extends ElementResult<IMap> {
    public MapResult(Type type, IMap map, IEvaluatorContext ctx) {
        super(type, map, ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> add(Result<V> result) {
        return result.addMap(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> subtract(Result<V> result) {
        return result.subtractMap(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> intersect(Result<V> result) {
        return result.intersectMap(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> subscript(Result<?>[] subscripts) {
        if (subscripts.length != 1) {
            throw new UnsupportedSubscriptArity(this.getStaticType(), subscripts.length, this.ctx.getCurrentAST());
        }
        Result<?> key = subscripts[0];
        if (!this.getStaticType().getKeyType().comparable(key.getStaticType())) {
            throw new UnexpectedType(this.getStaticType().getKeyType(), key.getStaticType(), this.ctx.getCurrentAST());
        }
        IValue v = ((IMap)this.getValue()).get((IValue)key.getValue());
        if (v == null) {
            throw RuntimeExceptionFactory.noSuchKey(key.getValue(), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
        }
        return ResultFactory.makeResult(this.getStaticType().getValueType(), v, this.ctx);
    }

    @Override
    public Result<IBool> isKeyDefined(Result<?>[] subscripts) {
        if (subscripts.length != 1) {
            throw new UnsupportedSubscriptArity(this.getStaticType(), subscripts.length, this.ctx.getCurrentAST());
        }
        Result<?> key = subscripts[0];
        if (!this.getStaticType().getKeyType().comparable(key.getStaticType())) {
            throw new UnexpectedType(this.getStaticType().getKeyType(), key.getStaticType(), this.ctx.getCurrentAST());
        }
        IValue v = ((IMap)this.getValue()).get((IValue)key.getValue());
        if (v == null) {
            return ResultFactory.makeResult(this.getTypeFactory().boolType(), this.getValueFactory().bool(false), this.ctx);
        }
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), this.getValueFactory().bool(true), this.ctx);
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToMap(this);
    }

    @Override
    public <U extends IValue> Result<U> fieldAccess(String name, TypeStore store) {
        if (name.equals(this.type.getKeyLabel())) {
            ISetWriter w = this.getValueFactory().setWriter();
            w.insertAll((Iterable)((Object)this.value));
            return ResultFactory.makeResult(this.getTypeFactory().setType(this.type.getKeyType()), w.done(), this.ctx);
        }
        if (name.equals(this.type.getValueLabel())) {
            ISetWriter w = this.getValueFactory().setWriter();
            Iterator<IValue> it = ((IMap)this.value).valueIterator();
            while (it.hasNext()) {
                w.insert(it.next());
            }
            return ResultFactory.makeResult(this.getTypeFactory().setType(this.type.getValueType()), w.done(), this.ctx);
        }
        throw new UndeclaredField(name, this.type, this.ctx.getCurrentAST());
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> fieldUpdate(String name, Result<V> repl, TypeStore store) {
        if (this.type.getKeyLabel() != null) {
            if (this.type.getKeyLabel().equals(name)) {
                throw new UnsupportedOperation("You can not update the keys of a map using the field update operator", this.ctx.getCurrentAST());
            }
            if (this.type.getValueLabel().equals(name)) {
                if (!repl.getStaticType().isSubtypeOf(this.type.getValueType())) {
                    throw new UnexpectedType(this.type.getValueType(), repl.getStaticType(), this.ctx.getCurrentAST());
                }
                IMapWriter w = this.getValueFactory().mapWriter();
                for (IValue key : (IMap)this.value) {
                    w.put(key, (IValue)repl.getValue());
                }
                return ResultFactory.makeResult(this.type, w.done(), this.ctx);
            }
        }
        throw new UndeclaredFieldException(this.type, name);
    }

    @Override
    public <V extends IValue> Result<IBool> nonEquals(Result<V> that) {
        return that.nonEqualToMap(this);
    }

    @Override
    public <V extends IValue> Result<IBool> lessThan(Result<V> that) {
        return that.lessThanMap(this);
    }

    @Override
    public <V extends IValue> LessThanOrEqualResult lessThanOrEqual(Result<V> that) {
        return that.lessThanOrEqualMap(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThan(Result<V> that) {
        return that.greaterThanMap(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThanOrEqual(Result<V> that) {
        return that.greaterThanOrEqualMap(this);
    }

    @Override
    public <V extends IValue> Result<IBool> in(Result<V> result) {
        return result.inMap(this);
    }

    @Override
    public <V extends IValue> Result<IBool> notIn(Result<V> result) {
        return result.notInMap(this);
    }

    protected <V extends IValue> Result<IBool> elementOf(ElementResult<V> elementResult) {
        return ResultFactory.bool(((IMap)this.getValue()).containsKey((IValue)elementResult.getValue()), this.ctx);
    }

    protected <V extends IValue> Result<IBool> notElementOf(ElementResult<V> elementResult) {
        return ResultFactory.bool(!((IMap)this.getValue()).containsKey((IValue)elementResult.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addMap(MapResult m4) {
        return ResultFactory.makeResult(this.getStaticType().lub(m4.getStaticType()), ((IMap)m4.value).join((IMap)this.value), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addListRelation(ListRelationResult that) {
        return that.addMap(this);
    }

    @Override
    protected <U extends IValue> Result<U> subtractMap(MapResult m4) {
        return ResultFactory.makeResult(m4.getStaticType(), ((IMap)m4.getValue()).remove((IMap)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> intersectMap(MapResult m4) {
        return ResultFactory.makeResult(m4.getStaticType(), ((IMap)m4.getValue()).common((IMap)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> equalToMap(MapResult that) {
        return that.equalityBoolean(this);
    }

    @Override
    protected Result<IBool> nonEqualToMap(MapResult that) {
        return that.nonEqualityBoolean(this);
    }

    @Override
    protected Result<IBool> lessThanMap(MapResult that) {
        return ResultFactory.bool(((IMap)that.getValue()).isSubMap((IMap)this.getValue()) && !((IMap)that.getValue()).equals(this.getValue()), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualMap(MapResult that) {
        boolean subMap = ((IMap)that.getValue()).isSubMap((IMap)this.getValue());
        boolean equals = ((IMap)that.getValue()).equals(this.getValue());
        return new LessThanOrEqualResult(subMap && !equals, equals, this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanMap(MapResult that) {
        LessThanOrEqualResult loe = that.lessThanOrEqualMap(this);
        if (!loe.getEqual()) {
            return loe.isLess();
        }
        return ResultFactory.bool(false, this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualMap(MapResult that) {
        return that.lessThanOrEqualMap(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> compose(Result<V> right) {
        return right.composeMap(this);
    }

    @Override
    public <U extends IValue> Result<U> composeMap(MapResult left) {
        if (left.getStaticType().getValueType().comparable(this.getStaticType().getKeyType())) {
            Type mapType = this.getTypeFactory().mapType(left.getStaticType().getKeyType(), this.getStaticType().getValueType());
            return ResultFactory.makeResult(mapType, ((IMap)left.getValue()).compose((IMap)this.getValue()), this.ctx);
        }
        return this.undefinedError("composition", left);
    }

    @Override
    public Result<IValue> fieldSelect(int[] selectedFields) {
        ISetWriter w = this.getValueFactory().setWriter();
        Iterator<Map.Entry<IValue, IValue>> it = ((IMap)this.value).entryIterator();
        while (it.hasNext()) {
            Map.Entry<IValue, IValue> entry = it.next();
            w.insert(this.getValueFactory().tuple(entry.getKey(), entry.getValue()));
        }
        return ResultFactory.makeResult(this.getTypeFactory().setType(this.type.getFieldTypes()), w.done(), this.ctx).fieldSelect(selectedFields);
    }

    @Override
    public Result<IValue> fieldSelect(Field[] selectedFields) {
        int nFields = selectedFields.length;
        int[] fieldIndices = new int[nFields];
        Type baseType = this.getStaticType();
        for (int i = 0; i < nFields; ++i) {
            Field f = selectedFields[i];
            if (f.isIndex()) {
                fieldIndices[i] = ((IInteger)f.getFieldIndex().interpret(this.ctx.getEvaluator()).getValue()).intValue();
            } else {
                String fieldName = Names.name(f.getFieldName());
                try {
                    fieldIndices[i] = baseType.getFieldIndex(fieldName);
                }
                catch (UndeclaredFieldException e) {
                    throw new UndeclaredField(fieldName, baseType, this.ctx.getCurrentAST());
                }
            }
            if (fieldIndices[i] >= 0 && fieldIndices[i] <= 1) continue;
            throw RuntimeExceptionFactory.indexOutOfBounds(ValueFactoryFactory.getValueFactory().integer(fieldIndices[i]), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
        }
        return this.fieldSelect(fieldIndices);
    }
}

