/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.ElementResult;
import org.rascalmpl.interpreter.result.IntegerResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.RationalResult;
import org.rascalmpl.interpreter.result.RealResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.values.ValueFactoryFactory;

public class NumberResult
extends ElementResult<INumber> {
    public NumberResult(Type type, INumber value, IEvaluatorContext ctx) {
        super(type, value, ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> add(Result<V> result) {
        return result.addNumber(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> multiply(Result<V> result) {
        return result.multiplyNumber(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> divide(Result<V> result) {
        return result.divideNumber(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> makeRange(Result<V> that) {
        return that.makeRangeFromNumber(this);
    }

    @Override
    public <U extends IValue, V extends IValue, W extends IValue> Result<U> makeStepRange(Result<V> to, Result<W> step) {
        return to.makeStepRangeFromNumber(this, step);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> subtract(Result<V> result) {
        return result.subtractNumber(this);
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToNumber(this);
    }

    @Override
    public <V extends IValue> Result<IBool> nonEquals(Result<V> that) {
        return that.nonEqualToNumber(this);
    }

    @Override
    public <V extends IValue> Result<IBool> lessThan(Result<V> result) {
        return result.lessThanNumber(this);
    }

    @Override
    protected Result<IBool> lessThanReal(RealResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IReal)that.getValue()).less((INumber)this.getValue()), this.ctx);
    }

    @Override
    public <V extends IValue> LessThanOrEqualResult lessThanOrEqual(Result<V> result) {
        return result.lessThanOrEqualNumber(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThan(Result<V> result) {
        return result.greaterThanNumber(this);
    }

    @Override
    protected Result<IBool> greaterThanReal(ElementResult<IReal> that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IReal)that.getValue()).greater((INumber)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualReal(ElementResult<IReal> that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IReal)that.getValue()).greaterEqual((INumber)this.getValue()), this.ctx);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThanOrEqual(Result<V> result) {
        return result.greaterThanOrEqualNumber(this);
    }

    @Override
    public <U extends IValue> Result<U> negative() {
        return ResultFactory.makeResult(this.type, ((INumber)this.getValue()).negate(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addInteger(IntegerResult n) {
        return ResultFactory.makeResult(this.type, ((INumber)this.getValue()).add((IInteger)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> subtractInteger(IntegerResult n) {
        return ResultFactory.makeResult(this.type, ((IInteger)n.getValue()).subtract((INumber)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyInteger(IntegerResult n) {
        return ResultFactory.makeResult(this.type, ((INumber)this.getValue()).multiply((IInteger)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> divideInteger(IntegerResult n) {
        try {
            int prec = ValueFactoryFactory.getValueFactory().getPrecision();
            return ResultFactory.makeResult(this.type, ((IInteger)n.getValue()).divide((INumber)this.getValue(), prec), this.ctx);
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), this.ctx.getCurrentAST(), null);
        }
    }

    @Override
    protected <U extends IValue> Result<U> addReal(ElementResult<IReal> n) {
        return ResultFactory.makeResult(this.type, ((INumber)this.getValue()).add((IReal)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addRational(RationalResult that) {
        return ResultFactory.makeResult(this.type, ((INumber)this.getValue()).add((IRational)that.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> subtractReal(ElementResult<IReal> n) {
        return ResultFactory.makeResult(this.type, ((IReal)n.getValue()).subtract((INumber)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyReal(ElementResult<IReal> n) {
        return ResultFactory.makeResult(this.type, ((INumber)this.getValue()).multiply((IReal)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> divideReal(ElementResult<IReal> n) {
        try {
            int prec = ValueFactoryFactory.getValueFactory().getPrecision();
            return ResultFactory.makeResult(this.type, ((IReal)n.getValue()).divide((INumber)this.getValue(), prec), this.ctx);
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), this.ctx.getCurrentAST(), null);
        }
    }

    @Override
    protected Result<IBool> equalToReal(RealResult that) {
        return ResultFactory.bool(((IReal)that.getValue()).equal((INumber)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> nonEqualToReal(RealResult that) {
        return ResultFactory.bool(!((IReal)that.getValue()).equal((INumber)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> equalToRational(RationalResult that) {
        return ResultFactory.bool(((IRational)that.getValue()).equal((INumber)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> nonEqualToRational(RationalResult that) {
        return ResultFactory.bool(!((IRational)that.getValue()).equal((INumber)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualReal(ElementResult<IReal> that) {
        return new LessThanOrEqualResult(((IReal)that.getValue()).less((INumber)this.getValue()).getValue(), ((IReal)that.getValue()).equal((INumber)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualRational(RationalResult that) {
        return new LessThanOrEqualResult(((IRational)that.getValue()).less((INumber)this.getValue()).getValue(), ((IRational)that.getValue()).equal((INumber)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addNumber(NumberResult n) {
        return ResultFactory.makeResult(this.type, ((INumber)this.getValue()).add((INumber)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> subtractNumber(NumberResult n) {
        return ResultFactory.makeResult(this.type, ((INumber)n.getValue()).subtract((INumber)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyNumber(NumberResult n) {
        return ResultFactory.makeResult(this.type, ((INumber)this.getValue()).multiply((INumber)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> divideNumber(NumberResult n) {
        try {
            int prec = ValueFactoryFactory.getValueFactory().getPrecision();
            return ResultFactory.makeResult(this.type, ((INumber)n.getValue()).divide((INumber)this.getValue(), prec), this.ctx);
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), this.ctx.getCurrentAST(), null);
        }
    }

    @Override
    protected Result<IBool> equalToNumber(NumberResult that) {
        return ResultFactory.bool(((INumber)that.getValue()).equal((INumber)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> nonEqualToNumber(NumberResult that) {
        return ResultFactory.bool(!((INumber)that.getValue()).equal((INumber)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualNumber(NumberResult that) {
        return new LessThanOrEqualResult(((INumber)that.getValue()).less((INumber)this.getValue()).getValue(), ((INumber)that.getValue()).equal((INumber)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualNumber(NumberResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((INumber)that.getValue()).greaterEqual((INumber)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanNumber(NumberResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((INumber)that.getValue()).greater((INumber)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> equalToInteger(IntegerResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IInteger)that.getValue()).equal((INumber)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> nonEqualToInteger(IntegerResult that) {
        return that.nonEqualityBoolean(this);
    }

    @Override
    protected Result<IBool> lessThanInteger(IntegerResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IInteger)that.getValue()).less((INumber)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> lessThanNumber(NumberResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((INumber)that.getValue()).less((INumber)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> lessThanRational(RationalResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IRational)that.getValue()).less((INumber)this.getValue()), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualInteger(IntegerResult that) {
        return new LessThanOrEqualResult(((IInteger)that.getValue()).less((INumber)this.getValue()).getValue(), ((IInteger)that.getValue()).equal((INumber)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanInteger(IntegerResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IInteger)that.getValue()).greater((INumber)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualInteger(IntegerResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IInteger)that.getValue()).greaterEqual((INumber)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> makeRangeFromInteger(IntegerResult from) {
        return this.makeRangeWithDefaultStep(from, this.getValueFactory().integer(1));
    }

    @Override
    protected <U extends IValue, V extends IValue> Result<U> makeStepRangeFromInteger(IntegerResult from, Result<V> second) {
        return IntegerResult.makeStepRangeFromToWithSecond(from, this, second, this.getValueFactory(), this.getTypeFactory(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> makeRangeFromReal(ElementResult<IReal> from) {
        return this.makeRangeWithDefaultStep(from, this.getValueFactory().real(1.0));
    }

    @Override
    protected <U extends IValue, V extends IValue> Result<U> makeStepRangeFromReal(ElementResult<IReal> from, Result<V> second) {
        return IntegerResult.makeStepRangeFromToWithSecond(from, this, second, this.getValueFactory(), this.getTypeFactory(), this.ctx);
    }

    @Override
    protected <U extends IValue, V extends IValue> Result<U> makeStepRangeFromNumber(NumberResult from, Result<V> second) {
        return IntegerResult.makeStepRangeFromToWithSecond(from, this, second, this.getValueFactory(), this.getTypeFactory(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> makeRangeFromNumber(NumberResult from) {
        if (this.getStaticType().lub(from.getStaticType()).isInteger()) {
            return this.makeRangeWithDefaultStep(from, this.getValueFactory().integer(1));
        }
        if (this.getStaticType().lub(from.getStaticType()).isReal()) {
            return this.makeRangeWithDefaultStep(from, this.getValueFactory().real(1.0));
        }
        if (this.getStaticType().lub(from.getStaticType()).isNumber()) {
            return this.makeRangeWithDefaultStep(from, this.getValueFactory().integer(1));
        }
        throw new ImplementationError("Unknown number type in makeRangeFromNumber");
    }

    private <U extends IValue, V extends INumber> Result<U> makeRangeWithDefaultStep(Result<V> from, INumber step) {
        if (((INumber)from.getValue()).less((INumber)this.getValue()).getValue()) {
            return IntegerResult.makeStepRangeFromToWithSecond(from, this, ResultFactory.makeResult(from.getStaticType(), ((INumber)from.getValue()).add(step), this.ctx), this.getValueFactory(), this.getTypeFactory(), this.ctx);
        }
        return IntegerResult.makeStepRangeFromToWithSecond(from, this, ResultFactory.makeResult(from.getStaticType(), ((INumber)from.getValue()).subtract(step), this.ctx), this.getValueFactory(), this.getTypeFactory(), this.ctx);
    }
}

