/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Iterator;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.BoolResult;
import org.rascalmpl.interpreter.result.DateTimeResult;
import org.rascalmpl.interpreter.result.ElementResult;
import org.rascalmpl.interpreter.result.IntegerResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.ListResult;
import org.rascalmpl.interpreter.result.MapResult;
import org.rascalmpl.interpreter.result.NodeResult;
import org.rascalmpl.interpreter.result.NumberResult;
import org.rascalmpl.interpreter.result.RationalResult;
import org.rascalmpl.interpreter.result.RealResult;
import org.rascalmpl.interpreter.result.RelationResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.result.SetResult;
import org.rascalmpl.interpreter.result.SourceLocationResult;
import org.rascalmpl.interpreter.result.StringResult;
import org.rascalmpl.interpreter.result.TupleResult;

public class ValueResult
extends ElementResult<IValue> {
    public ValueResult(Type type, IValue value, IEvaluatorContext ctx) {
        super(type, value, ctx);
    }

    public ValueResult(Type type, IValue value, Iterator<Result<IValue>> iter, IEvaluatorContext ctx) {
        super(type, value, iter, ctx);
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToValue(this);
    }

    @Override
    public <V extends IValue> Result<IBool> nonEquals(Result<V> that) {
        return this.equals(that).negate();
    }

    @Override
    public <V extends IValue> LessThanOrEqualResult lessThanOrEqual(Result<V> that) {
        Type thatRuntimeType;
        Type thisRuntimeType = this.getValue().getType();
        if (thisRuntimeType.comparable(thatRuntimeType = that.getValue().getType())) {
            return ResultFactory.makeResult(thisRuntimeType, this.getValue(), this.ctx).lessThanOrEqual(ResultFactory.makeResult(thatRuntimeType, that.getValue(), this.ctx));
        }
        if (thisRuntimeType.lub(thatRuntimeType).isNumber()) {
            Type numberType = TypeFactory.getInstance().numberType();
            return ResultFactory.makeResult(numberType, this.getValue(), this.ctx).lessThanOrEqual(ResultFactory.makeResult(numberType, that.getValue(), this.ctx));
        }
        return new LessThanOrEqualResult(false, false, this.ctx);
    }

    @Override
    protected Result<IBool> equalToInteger(IntegerResult that) {
        return this.equalityBoolean(that);
    }

    @Override
    protected Result<IBool> equalToReal(RealResult that) {
        return this.equalityBoolean(that);
    }

    @Override
    protected Result<IBool> equalToRational(RationalResult that) {
        return this.equalityBoolean(that);
    }

    @Override
    protected Result<IBool> equalToNumber(NumberResult that) {
        return this.equalityBoolean(that);
    }

    @Override
    protected Result<IBool> equalToString(StringResult that) {
        return this.equalityBoolean(that);
    }

    @Override
    protected Result<IBool> equalToList(ListResult that) {
        return this.equalityBoolean(that);
    }

    @Override
    protected Result<IBool> equalToSet(SetResult that) {
        return this.equalityBoolean(that);
    }

    @Override
    protected Result<IBool> equalToMap(MapResult that) {
        return this.equalityBoolean(that);
    }

    @Override
    protected Result<IBool> equalToNode(NodeResult that) {
        return this.equalityBoolean(that);
    }

    @Override
    protected Result<IBool> equalToSourceLocation(SourceLocationResult that) {
        return this.equalityBoolean(that);
    }

    @Override
    protected Result<IBool> equalToRelation(RelationResult that) {
        return this.equalityBoolean(that);
    }

    @Override
    protected Result<IBool> equalToTuple(TupleResult that) {
        return this.equalityBoolean(that);
    }

    @Override
    protected Result<IBool> equalToBool(BoolResult that) {
        return this.equalityBoolean(that);
    }

    @Override
    protected Result<IBool> equalToValue(ValueResult that) {
        Object leftValue = that.getValue();
        Object rightValue = this.getValue();
        return ResultFactory.makeResult(rightValue.getType(), rightValue, this.ctx).equals(ResultFactory.makeResult(leftValue.getType(), leftValue, this.ctx));
    }

    @Override
    protected Result<IBool> equalToDateTime(DateTimeResult that) {
        return this.equalityBoolean(that);
    }

    @Override
    protected Result<IBool> nonEqualToInteger(IntegerResult that) {
        return this.nonEqualityBoolean(that);
    }

    @Override
    protected Result<IBool> nonEqualToReal(RealResult that) {
        return this.nonEqualityBoolean(that);
    }

    @Override
    protected Result<IBool> nonEqualToString(StringResult that) {
        return this.nonEqualityBoolean(that);
    }

    @Override
    protected Result<IBool> nonEqualToList(ListResult that) {
        return this.nonEqualityBoolean(that);
    }

    @Override
    protected Result<IBool> nonEqualToSet(SetResult that) {
        return this.nonEqualityBoolean(that);
    }

    @Override
    protected Result<IBool> nonEqualToMap(MapResult that) {
        return this.nonEqualityBoolean(that);
    }

    @Override
    protected Result<IBool> nonEqualToNode(NodeResult that) {
        return this.nonEqualityBoolean(that);
    }

    @Override
    protected Result<IBool> nonEqualToSourceLocation(SourceLocationResult that) {
        return this.nonEqualityBoolean(that);
    }

    @Override
    protected Result<IBool> nonEqualToRelation(RelationResult that) {
        return this.nonEqualityBoolean(that);
    }

    @Override
    protected Result<IBool> nonEqualToTuple(TupleResult that) {
        return this.nonEqualityBoolean(that);
    }

    @Override
    protected Result<IBool> nonEqualToBool(BoolResult that) {
        return this.nonEqualityBoolean(that);
    }

    @Override
    protected Result<IBool> nonEqualToValue(ValueResult that) {
        return this.nonEqualityBoolean(this);
    }

    @Override
    protected Result<IBool> nonEqualToDateTime(DateTimeResult that) {
        return this.nonEqualityBoolean(that);
    }
}

