/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWriter;
import io.usethesource.vallang.type.Type;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.rascalmpl.interpreter.asserts.Ambiguous;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class ParseErrorRecovery {
    private final IRascalValueFactory rascalValues;

    public ParseErrorRecovery(IRascalValueFactory rascalValues) {
        this.rascalValues = rascalValues;
    }

    public IConstructor disambiguateParseErrors(IConstructor arg, IBool allowAmbiguity) {
        return this.disambiguate((IConstructor)arg, (boolean)allowAmbiguity.getValue(), (boolean)true, new HashMap<IConstructor, ScoredTree>()).tree;
    }

    private ScoredTree disambiguate(IConstructor tree, boolean allowAmbiguity, boolean buildTree, Map<IConstructor, ScoredTree> processedTrees) {
        Type type = tree.getConstructorType();
        ScoredTree result = type == RascalValueFactory.Tree_Appl ? this.disambiguateAppl((ITree)tree, allowAmbiguity, buildTree, processedTrees) : (type == RascalValueFactory.Tree_Amb ? this.disambiguateAmb((ITree)tree, allowAmbiguity, buildTree, processedTrees) : new ScoredTree(tree, 0, false));
        return result;
    }

    private ScoredTree disambiguateAppl(ITree appl, boolean allowAmbiguity, boolean buildTree, Map<IConstructor, ScoredTree> processedTrees) {
        ScoredTree result = processedTrees.get(appl);
        if (result != null) {
            return result;
        }
        if (ProductionAdapter.isSkipped(appl.getProduction())) {
            result = new ScoredTree(appl, ((IList)appl.get(1)).length(), true);
        } else {
            IList args = TreeAdapter.getArgs(appl);
            int totalScore = 0;
            boolean hasErrors = false;
            IWriter disambiguatedArgs = null;
            for (int i = 0; i < args.size(); ++i) {
                IValue arg = args.get(i);
                ScoredTree disambiguatedArg = this.disambiguate((IConstructor)arg, allowAmbiguity, buildTree, processedTrees);
                totalScore += disambiguatedArg.score;
                hasErrors |= disambiguatedArg.hasErrors;
                if (buildTree && disambiguatedArg.tree != arg && disambiguatedArgs == null) {
                    disambiguatedArgs = this.rascalValues.listWriter();
                    for (int j = 0; j < i; ++j) {
                        disambiguatedArgs.append(args.get(j));
                    }
                }
                if (disambiguatedArgs == null) continue;
                disambiguatedArgs.append(disambiguatedArg.tree);
            }
            ITree resultTree = null;
            if (disambiguatedArgs != null) {
                resultTree = TreeAdapter.setArgs(appl, (IList)disambiguatedArgs.done());
            } else if (buildTree) {
                resultTree = appl;
            }
            result = new ScoredTree(resultTree, totalScore, hasErrors);
        }
        processedTrees.put(appl, result);
        return result;
    }

    private ScoredTree disambiguateAmb(ITree amb, boolean allowAmbiguity, boolean buildTree, Map<IConstructor, ScoredTree> processedTrees) {
        ScoredTree result = processedTrees.get(amb);
        if (result != null) {
            return result;
        }
        ISet originalAlts = (ISet)amb.get(0);
        IWriter alternativesWithoutErrors = null;
        ScoredTree errorAltWithBestScore = null;
        for (IValue alt : originalAlts) {
            ScoredTree disambiguatedAlt = this.disambiguate((IConstructor)alt, allowAmbiguity, buildTree, processedTrees);
            if (disambiguatedAlt.hasErrors) {
                if (errorAltWithBestScore != null && errorAltWithBestScore.score <= disambiguatedAlt.score) continue;
                errorAltWithBestScore = disambiguatedAlt;
                continue;
            }
            if (alternativesWithoutErrors == null) {
                alternativesWithoutErrors = this.rascalValues.setWriter();
            }
            alternativesWithoutErrors.insert(disambiguatedAlt.tree);
        }
        if (alternativesWithoutErrors == null) {
            assert (errorAltWithBestScore != null) : "No trees with and no trees without errors?";
            processedTrees.put(amb, errorAltWithBestScore);
            return errorAltWithBestScore;
        }
        ISet remainingAlts = (ISet)alternativesWithoutErrors.done();
        ITree resultTree = null;
        if (remainingAlts.size() > 1 && !allowAmbiguity) {
            resultTree = this.rascalValues.amb(remainingAlts);
            throw new Ambiguous(resultTree);
        }
        if (buildTree) {
            resultTree = remainingAlts.size() == originalAlts.size() ? amb : (remainingAlts.size() == 1 ? (ITree)remainingAlts.iterator().next() : this.rascalValues.amb(remainingAlts));
        }
        result = new ScoredTree(resultTree, 0, false);
        processedTrees.put(amb, result);
        return result;
    }

    public IList findAllParseErrors(IConstructor tree) {
        IListWriter errors = this.rascalValues.listWriter();
        this.collectErrors((ITree)tree, errors, new HashSet<IConstructor>());
        return (IList)errors.done();
    }

    public boolean hasErrors(IConstructor tree) {
        return !this.findAllParseErrors(tree).isEmpty();
    }

    private void collectErrors(ITree tree, IListWriter errors, Set<IConstructor> processedTrees) {
        Type type = tree.getConstructorType();
        if (type == RascalValueFactory.Tree_Appl) {
            this.collectApplErrors(tree, errors, processedTrees);
        } else if (type == RascalValueFactory.Tree_Amb) {
            this.collectAmbErrors(tree, errors, processedTrees);
        }
    }

    private void collectApplErrors(ITree appl, IListWriter errors, Set<IConstructor> processedTrees) {
        if (!processedTrees.add(appl)) {
            return;
        }
        if (ProductionAdapter.isError(appl.getProduction())) {
            errors.append(appl);
        }
        IList args = TreeAdapter.getArgs(appl);
        for (int i = 0; i < args.size(); ++i) {
            IValue arg = args.get(i);
            this.collectErrors((ITree)arg, errors, processedTrees);
        }
    }

    private void collectAmbErrors(ITree amb, IListWriter errors, Set<IConstructor> processedTrees) {
        if (!processedTrees.add(amb)) {
            return;
        }
        for (IValue alt : TreeAdapter.getAlternatives(amb)) {
            this.collectErrors((ITree)alt, errors, processedTrees);
        }
    }

    public IBool treeEquality(IConstructor tree1, IConstructor tree2) {
        return this.rascalValues.bool(this.checkTreeEquality((ITree)tree1, (ITree)tree2, new HashSet<TreePair>()));
    }

    private boolean checkTreeEquality(ITree tree1, ITree tree2, Set<TreePair> equalTrees) {
        boolean result;
        if (tree1 == tree2) {
            return true;
        }
        Type type = tree1.getConstructorType();
        if (!type.equals(tree2.getConstructorType())) {
            return false;
        }
        if (!this.checkLocationEquality(tree1, tree2)) {
            return false;
        }
        if (type == RascalValueFactory.Tree_Char) {
            return this.checkCharEquality(tree1, tree2);
        }
        if (type == RascalValueFactory.Tree_Cycle) {
            return this.checkCycleEquality(tree1, tree2);
        }
        TreePair pair = new TreePair(tree1, tree2);
        if (equalTrees.contains(pair)) {
            return true;
        }
        if (type == RascalValueFactory.Tree_Appl) {
            result = this.checkApplEquality(tree1, tree2, equalTrees);
        } else if (type == RascalValueFactory.Tree_Amb) {
            result = this.checkAmbEquality(tree1, tree2, equalTrees);
        } else {
            throw new IllegalArgumentException("unknown tree type: " + type);
        }
        if (result) {
            equalTrees.add(pair);
        }
        return result;
    }

    private boolean checkApplEquality(ITree tree1, ITree tree2, Set<TreePair> equalTrees) {
        IConstructor type2;
        IConstructor type1 = ProductionAdapter.getType(tree1);
        if (!type1.equals(type2 = ProductionAdapter.getType(tree2))) {
            return false;
        }
        IList args1 = TreeAdapter.getArgs(tree1);
        IList args2 = TreeAdapter.getArgs(tree2);
        int size = args1.size();
        if (size != args2.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            ITree arg2;
            ITree arg1 = (ITree)args1.get(i);
            if (this.checkTreeEquality(arg1, arg2 = (ITree)args2.get(i), equalTrees)) continue;
            return false;
        }
        return true;
    }

    private boolean checkAmbEquality(ITree tree1, ITree tree2, Set<TreePair> equalTrees) {
        ISet alts1 = tree1.getAlternatives();
        ISet alts2 = tree2.getAlternatives();
        if (alts1.size() != alts2.size()) {
            return false;
        }
        BitSet alts2Checked = new BitSet(alts2.size());
        boolean ok = true;
        for (IValue alt1 : alts1) {
            int index2 = 0;
            for (IValue alt2 : alts2) {
                if (!alts2Checked.get(index2) && this.checkTreeEquality((ITree)alt1, (ITree)alt2, equalTrees)) {
                    alts2Checked.set(index2);
                    break;
                }
                ++index2;
            }
            if (index2 != alts2.size()) continue;
            ok = false;
        }
        return ok;
    }

    private boolean checkCharEquality(ITree tree1, ITree tree2) {
        return ((IInteger)tree1.get(0)).intValue() == ((IInteger)tree2.get(0)).intValue();
    }

    private boolean checkCycleEquality(ITree tree1, ITree tree2) {
        return tree1.get(0).equals(tree2.get(0)) && ((IInteger)tree1.get(1)).intValue() == ((IInteger)tree2.get(1)).intValue();
    }

    private boolean checkLocationEquality(ITree tree1, ITree tree2) {
        ISourceLocation loc1 = TreeAdapter.getLocation(tree1);
        ISourceLocation loc2 = TreeAdapter.getLocation(tree2);
        if (loc1 == null && loc2 == null) {
            return true;
        }
        if (loc1 == null || loc2 == null) {
            return false;
        }
        return loc1.getOffset() == loc2.getOffset() && loc1.getLength() == loc2.getLength();
    }

    public IInteger countUniqueTreeNodes(IConstructor tree) {
        BigInteger count = this.countNodes((ITree)tree, true, new IdentityHashMap<IConstructor, BigInteger>());
        return this.rascalValues.integer(count.toByteArray());
    }

    public IInteger countTreeNodes(IConstructor tree) {
        BigInteger count = this.countNodes((ITree)tree, false, new IdentityHashMap<IConstructor, BigInteger>());
        return this.rascalValues.integer(count.toByteArray());
    }

    private BigInteger countNodes(ITree tree, boolean unique, Map<IConstructor, BigInteger> processedNodes) {
        Type type = tree.getConstructorType();
        if (type == RascalValueFactory.Tree_Appl || type == RascalValueFactory.Tree_Amb) {
            BigInteger result = processedNodes.get(tree);
            if (result != null) {
                return unique ? BigInteger.ZERO : result;
            }
            result = type == RascalValueFactory.Tree_Appl ? this.countApplNodes(tree, unique, processedNodes) : this.countAmbNodes(tree, unique, processedNodes);
            processedNodes.put(tree, result);
            return result;
        }
        return BigInteger.ONE;
    }

    private BigInteger countApplNodes(ITree appl, boolean unique, Map<IConstructor, BigInteger> processedNodes) {
        BigInteger count = BigInteger.ONE;
        IList args = TreeAdapter.getArgs(appl);
        for (int i = args.size() - 1; i >= 0; --i) {
            count = count.add(this.countNodes((ITree)args.get(i), unique, processedNodes));
        }
        return count;
    }

    private BigInteger countAmbNodes(ITree amb, boolean unique, Map<IConstructor, BigInteger> processedNodes) {
        BigInteger count = BigInteger.ONE;
        ISet originalAlts = (ISet)amb.get(0);
        for (IValue alt : originalAlts) {
            count = count.add(this.countNodes((ITree)alt, unique, processedNodes));
        }
        return count;
    }

    public IConstructor maximallyShareTree(IConstructor tree) {
        return this.maximallyShareTree((ITree)tree, new HashMap<ITree, ITree>());
    }

    private ITree maximallyShareTree(ITree tree, Map<ITree, ITree> processedNodes) {
        ITree result = processedNodes.get(tree);
        if (result != null) {
            return result;
        }
        Type type = tree.getConstructorType();
        result = type == RascalValueFactory.Tree_Appl ? this.maximallyShareAppl(tree, processedNodes) : (type == RascalValueFactory.Tree_Amb ? this.maximallyShareAmb(tree, processedNodes) : tree);
        processedNodes.put(tree, result);
        return result;
    }

    private ITree maximallyShareAppl(ITree appl, Map<ITree, ITree> processedNodes) {
        IList args = TreeAdapter.getArgs(appl);
        IWriter newArgs = null;
        int argCount = args.size();
        for (int i = 0; i < argCount; ++i) {
            ITree newArg;
            ITree arg = (ITree)args.get(i);
            if (arg != (newArg = this.maximallyShareTree(arg, processedNodes)) && newArgs == null) {
                newArgs = this.rascalValues.listWriter();
                for (int j = 0; j < i; ++j) {
                    newArgs.append(args.get(j));
                }
            }
            if (newArgs == null) continue;
            newArgs.append(newArg);
        }
        if (newArgs == null) {
            return appl;
        }
        return TreeAdapter.setArgs(appl, (IList)newArgs.done());
    }

    private ITree maximallyShareAmb(ITree amb, Map<ITree, ITree> processedNodes) {
        ISet alts = TreeAdapter.getAlternatives(amb);
        ISetWriter newAlts = this.rascalValues.setWriter();
        boolean anyChanges = false;
        for (IValue alt : alts) {
            ITree newAlt = this.maximallyShareTree((ITree)alt, processedNodes);
            if (newAlt != alt) {
                anyChanges = true;
            }
            newAlts.append(newAlt);
        }
        if (anyChanges) {
            ITree newAmb = this.rascalValues.amb((ISet)newAlts.done());
            if (amb.asWithKeywordParameters().hasParameter("src")) {
                IValue loc = amb.asWithKeywordParameters().getParameter("src");
                newAmb = (ITree)newAmb.asWithKeywordParameters().setParameter("src", loc);
            }
            return newAmb;
        }
        return amb;
    }

    public void checkForRegularAmbiguities(IConstructor parseForest) {
        this.disambiguate(parseForest, false, false, new HashMap<IConstructor, ScoredTree>());
    }

    private static class TreePair {
        private ITree tree1;
        private ITree tree2;
        private int hashCode;

        public TreePair(ITree tree1, ITree tree2) {
            this.tree1 = tree1;
            this.tree2 = tree2;
            this.hashCode = Objects.hash(System.identityHashCode(tree1), System.identityHashCode(tree2));
        }

        public boolean equals(Object peer) {
            TreePair pair = (TreePair)peer;
            return this.tree1 == pair.tree1 && this.tree2 == pair.tree2;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class ScoredTree {
        public final IConstructor tree;
        public final int score;
        public final boolean hasErrors;

        public ScoredTree(IConstructor tree, int score, boolean hasErrors) {
            this.tree = tree;
            this.score = score;
            this.hasErrors = hasErrors;
        }
    }
}

