/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.util.Map;

public class SystemAPI {
    private final IValueFactory values;

    public SystemAPI(IValueFactory values) {
        this.values = values;
    }

    public IValue getSystemProperty(IString v) {
        return this.values.string(System.getProperty(v.getValue()));
    }

    public IMap getSystemProperties() {
        IMapWriter w = this.values.mapWriter();
        for (Map.Entry<Object, Object> p : System.getProperties().entrySet()) {
            w.put(this.values.string(p.getKey().toString()), this.values.string(p.getValue().toString()));
        }
        return (IMap)w.done();
    }

    public IMap getSystemEnvironment() {
        IMapWriter w = this.values.mapWriter();
        for (Map.Entry<String, String> p : System.getenv().entrySet()) {
            w.put(this.values.string(p.getKey()), this.values.string(p.getValue()));
        }
        return (IMap)w.done();
    }
}

