/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util.tasks;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.library.util.tasks.IValueWrapper;
import org.rascalmpl.tasks.IIValueTask;
import org.rascalmpl.tasks.ITaskRegistry;
import org.rascalmpl.tasks.ITransaction;
import org.rascalmpl.tasks.PDBValueTaskRegistry;
import org.rascalmpl.tasks.Transaction;
import org.rascalmpl.types.TypeReifier;
import org.rascalmpl.values.functions.IFunction;

public class Manager {
    private Transaction base = null;
    private final ITaskRegistry<Type, IValue, IValue> registry;
    private final IValueFactory vf;
    private final TypeReifier typeReifier;
    private final Map<IValueWrapper, ProducerWrapper> producers = new HashMap<IValueWrapper, ProducerWrapper>();
    private final PrintWriter err;
    private final IRascalMonitor monitor;

    public Manager(IValueFactory vf, PrintWriter out, PrintWriter err, IRascalMonitor monitor) {
        this.vf = vf;
        this.err = err;
        this.monitor = monitor;
        this.typeReifier = new TypeReifier(vf);
        this.registry = PDBValueTaskRegistry.getRegistry();
    }

    public void lockProducerRegistry() {
        this.registry.lock();
    }

    public void unlockProducerRegistry() {
        this.registry.unlock();
    }

    public IValue startTransaction() {
        if (this.base == null) {
            this.base = new Transaction(this.err);
        }
        return new Transaction(this.base, this.err);
    }

    public IValue startTransaction(IValue tr) {
        return new Transaction(Manager.transaction(tr), this.err);
    }

    public void endTransaction(IValue tr) {
        Manager.transaction(tr).commit();
    }

    public void abandonTransaction(IValue tr) {
        Manager.transaction(tr).abandon();
    }

    public IValue getFact(IValue tr, IValue key, IValue name) {
        if (!(key instanceof IConstructor)) {
            throw RuntimeExceptionFactory.illegalArgument(key, "key is not a reified type");
        }
        IValue fact = Manager.transaction(tr).getFact(this.monitor, this.typeReifier.valueToType((IConstructor)key), name);
        if (fact == null) {
            fact = null;
        }
        return this.check(fact, (IConstructor)key, name);
    }

    private IValue check(IValue fact, IValue key, IValue name) {
        if (!(key instanceof IConstructor)) {
            throw RuntimeExceptionFactory.illegalArgument(key, "key is not a reified type");
        }
        if (fact == null) {
            throw RuntimeExceptionFactory.noSuchKey(this.vf.string(this.typeReifier.valueToType((IConstructor)key).toString() + ":" + name.toString()));
        }
        if (!fact.getType().isSubtypeOf(this.typeReifier.valueToType((IConstructor)key))) {
            throw RuntimeExceptionFactory.illegalArgument(fact, "fact is not a subtype of " + this.typeReifier.valueToType((IConstructor)key));
        }
        return fact;
    }

    public IValue queryFact(IValue tr, IValue key, IValue name) {
        if (!(key instanceof IConstructor)) {
            throw RuntimeExceptionFactory.illegalArgument(key, "key is not a reified type");
        }
        return this.check(Manager.transaction(tr).queryFact(this.typeReifier.valueToType((IConstructor)key), name), key, name);
    }

    public void removeFact(IValue tr, IValue key, IValue name) {
        if (!(key instanceof IConstructor)) {
            throw RuntimeExceptionFactory.illegalArgument(key, "key is not a reified type");
        }
        Manager.transaction(tr).removeFact(this.typeReifier.valueToType((IConstructor)key), name);
    }

    public void setFact(IValue tr, IValue key, IValue name, IValue value) {
        if (!(key instanceof IConstructor)) {
            throw RuntimeExceptionFactory.illegalArgument(key, "key is not a reified type");
        }
        Type keyType = this.typeReifier.valueToType((IConstructor)key);
        if (!value.getType().isSubtypeOf(keyType)) {
            throw RuntimeExceptionFactory.illegalArgument(value, "value is not a subtype of " + keyType);
        }
        Manager.transaction(tr).setFact(keyType, name, value);
    }

    public void registerProducer(IFunction producer, ISet keys) {
        ProducerWrapper wrapper = new ProducerWrapper(producer, keys);
        this.producers.put(new IValueWrapper(producer), wrapper);
        this.registry.registerProducer(wrapper);
    }

    public void unregisterProducer(IValue producer) {
        IValueWrapper prod = new IValueWrapper(producer);
        if (this.producers.containsKey(prod)) {
            ProducerWrapper wrapper = this.producers.get(prod);
            this.registry.unregisterProducer(wrapper);
            this.producers.remove(prod);
        }
    }

    public ITuple getDependencyGraph(IValue tr) {
        return Manager.transaction(tr).getGraph();
    }

    protected IConstructor reify(Type type) {
        return this.typeReifier.typeToValue(type, new TypeStore(new TypeStore[0]), (IMap)this.vf.mapWriter().done());
    }

    protected static Transaction transaction(IValue tr) {
        if (tr instanceof Transaction) {
            return (Transaction)tr;
        }
        throw new ImplementationError("Not a transaction: " + tr);
    }

    class ProducerWrapper
    implements IIValueTask {
        private IFunction fun;
        private Collection<Type> keys = new ArrayList<Type>();

        ProducerWrapper(IFunction fun, ISet keys) {
            this.fun = fun;
            for (IValue v : keys) {
                if (v instanceof ITuple) {
                    IValue keyType = ((ITuple)v).get(0);
                    IValue nameType = ((ITuple)v).get(1);
                    this.keys.add(TypeFactory.getInstance().tupleType(Manager.this.typeReifier.valueToType((IConstructor)keyType), Manager.this.typeReifier.valueToType((IConstructor)nameType)));
                    continue;
                }
                this.keys.add(TypeFactory.getInstance().tupleType(Manager.this.typeReifier.valueToType((IConstructor)v), TypeFactory.getInstance().valueType()));
            }
        }

        @Override
        public boolean produce(IRascalMonitor monitor, ITransaction<Type, IValue, IValue> tr, Type key, IValue name) {
            Transaction t2 = (Transaction)tr;
            IConstructor reifiedKey = Manager.this.reify(key);
            Object result = this.fun.call(t2, reifiedKey, name);
            if (result instanceof IBool) {
                return ((IBool)result).getValue();
            }
            throw RuntimeExceptionFactory.illegalArgument(result, "result is not a bool");
        }

        @Override
        public Collection<Type> getKeys() {
            return this.keys;
        }
    }
}

