/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.preprocessing;

import java.util.Iterator;
import org.rascalmpl.parser.gtd.stack.AbstractStackNode;
import org.rascalmpl.parser.gtd.util.DoubleArrayList;
import org.rascalmpl.parser.gtd.util.IntegerKeyedHashMap;
import org.rascalmpl.parser.gtd.util.IntegerList;
import org.rascalmpl.parser.gtd.util.IntegerMap;
import org.rascalmpl.parser.gtd.util.ObjectIntegerKeyedHashMap;
import org.rascalmpl.parser.gtd.util.SortedIntegerObjectList;

public class ExpectBuilder<P> {
    private final IntegerKeyedHashMap<IntegerList> dontNest;
    private final IntegerMap resultStoreMappings;
    private final SortedIntegerObjectList<DoubleArrayList<P, AbstractStackNode<P>[]>> alternatives;

    public ExpectBuilder(IntegerKeyedHashMap<IntegerList> dontNest, IntegerMap resultStoreMappings) {
        this.dontNest = dontNest;
        this.resultStoreMappings = resultStoreMappings;
        this.alternatives = new SortedIntegerObjectList();
    }

    public void addAlternative(P production, AbstractStackNode<P> ... alternative) {
        int alternativeLength = alternative.length;
        DoubleArrayList<Object, Object> alternativesList = this.alternatives.findValue(alternativeLength);
        if (alternativesList == null) {
            alternativesList = new DoubleArrayList();
            this.alternatives.add(alternativeLength, alternativesList);
        }
        AbstractStackNode[] clonedAlternative = new AbstractStackNode[alternativeLength];
        for (int i = alternativeLength - 1; i >= 0; --i) {
            clonedAlternative[i] = alternative[i].getCleanCopy(-1);
        }
        alternativesList.add(production, clonedAlternative);
    }

    protected boolean isSharable(P production) {
        return true;
    }

    public AbstractStackNode<P>[] buildExpectArray() {
        ObjectIntegerKeyedHashMap<AbstractStackNode<P>, AbstractStackNode<P>[]> constructedExpects = new ObjectIntegerKeyedHashMap<AbstractStackNode<P>, AbstractStackNode<P>[]>();
        for (int i = this.alternatives.size() - 1; i >= 0; --i) {
            DoubleArrayList<P, AbstractStackNode<P>[]> alternativesList = this.alternatives.getValue(i);
            for (int j = alternativesList.size() - 1; j >= 0; --j) {
                AbstractStackNode<P> alternativeItem;
                int k;
                AbstractStackNode[] sharedExpect = null;
                P production = alternativesList.getFirst(j);
                AbstractStackNode<P>[] alternative = alternativesList.getSecond(j);
                AbstractStackNode<P> first = alternative[0];
                int firstItemResultStoreId = this.resultStoreMappings.get(first.getId());
                if (this.isSharable(production) && this.dontNest.get(first.getId()) == null) {
                    sharedExpect = (AbstractStackNode[])constructedExpects.get(first, firstItemResultStoreId);
                }
                if (sharedExpect == null) {
                    alternative[alternative.length - 1].setProduction(alternative);
                    alternative[alternative.length - 1].setAlternativeProduction(production);
                    for (k = alternative.length - 2; k >= 0; --k) {
                        alternative[k].setProduction(alternative);
                    }
                    constructedExpects.putUnsafe(first, firstItemResultStoreId, alternative);
                    continue;
                }
                block3: for (k = 1; k < alternative.length && this.dontNest.get((alternativeItem = alternative[k]).getId()) == null; ++k) {
                    int alternativeItemResultStoreId = this.resultStoreMappings.get(alternativeItem.getId());
                    AbstractStackNode sharedExpectItem = sharedExpect[k];
                    if (!alternativeItem.isEqual(sharedExpectItem) || alternativeItemResultStoreId != this.resultStoreMappings.get(sharedExpectItem.getId())) {
                        AbstractStackNode<P>[][] otherSharedExpects = sharedExpectItem.getAlternateProductions();
                        if (otherSharedExpects == null) break;
                        for (int l = otherSharedExpects.length - 1; l >= 0; --l) {
                            AbstractStackNode<P>[] otherSharedExpect = otherSharedExpects[l];
                            AbstractStackNode<P> otherSharedExpectItem = otherSharedExpect[k];
                            if (!otherSharedExpectItem.isEqual(alternativeItem) || alternativeItemResultStoreId != this.resultStoreMappings.get(otherSharedExpectItem.getId())) continue;
                            sharedExpect = otherSharedExpect;
                            continue block3;
                        }
                        break;
                    }
                    alternative[k] = sharedExpect[k];
                }
                if (k < alternative.length) {
                    sharedExpect[k - 1].addProduction(alternative);
                    while (k < alternative.length) {
                        alternative[k].setProduction(alternative);
                        ++k;
                    }
                    alternative[alternative.length - 1].setAlternativeProduction(production);
                    continue;
                }
                sharedExpect[alternative.length - 1].setAlternativeProduction(production);
            }
        }
        int nrOfConstructedExpects = constructedExpects.size();
        AbstractStackNode[] expectArray = new AbstractStackNode[nrOfConstructedExpects];
        Iterator constructedExpectsIterator = constructedExpects.valueIterator();
        int i = nrOfConstructedExpects;
        while (constructedExpectsIterator.hasNext()) {
            expectArray[--i] = ((AbstractStackNode[])constructedExpectsIterator.next())[0];
        }
        return expectArray;
    }
}

