/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.result.out;

import java.util.HashMap;
import java.util.Map;
import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.result.AbstractNode;
import org.rascalmpl.parser.gtd.result.CharNode;
import org.rascalmpl.parser.gtd.result.ExpandableContainerNode;
import org.rascalmpl.parser.gtd.result.LiteralNode;
import org.rascalmpl.parser.gtd.result.SkippedNode;
import org.rascalmpl.parser.gtd.result.SortContainerNode;
import org.rascalmpl.parser.gtd.result.action.IActionExecutor;
import org.rascalmpl.parser.gtd.result.out.CharNodeFlattener;
import org.rascalmpl.parser.gtd.result.out.FilteringTracker;
import org.rascalmpl.parser.gtd.result.out.INodeConstructorFactory;
import org.rascalmpl.parser.gtd.result.out.INodeFlattener;
import org.rascalmpl.parser.gtd.result.out.ListContainerNodeFlattener;
import org.rascalmpl.parser.gtd.result.out.LiteralNodeFlattener;
import org.rascalmpl.parser.gtd.result.out.SkippedNodeFlattener;
import org.rascalmpl.parser.gtd.result.out.SortContainerNodeFlattener;
import org.rascalmpl.parser.gtd.util.IndexedStack;

public class DefaultNodeFlattener<P, T, S>
implements INodeFlattener<T, S> {
    private final CharNodeFlattener<T, S> charNodeConverter = new CharNodeFlattener();
    private final LiteralNodeFlattener<T, S> literalNodeConverter = new LiteralNodeFlattener();
    private final SortContainerNodeFlattener<P, T, S> sortContainerNodeConverter = new SortContainerNodeFlattener();
    private final ListContainerNodeFlattener<P, T, S> listContainerNodeConverter = new ListContainerNodeFlattener();
    private final SkippedNodeFlattener<T, S> skippedNodeConverter = new SkippedNodeFlattener();
    private final Map<T, T> treeCache = new HashMap<T, T>();

    @Override
    public T convert(INodeConstructorFactory<T, S> nodeConstructorFactory, AbstractNode node, IndexedStack<AbstractNode> stack, int depth, PositionStore positionStore, FilteringTracker filteringTracker, IActionExecutor<T> actionExecutor, Object environment, INodeFlattener.CacheMode cacheMode) {
        Object result = node.getTree();
        if (result != null) {
            return result;
        }
        switch (node.getTypeIdentifier()) {
            case 2: {
                result = this.charNodeConverter.convertToUPTR(nodeConstructorFactory, (CharNode)node);
                break;
            }
            case 3: {
                result = this.literalNodeConverter.convertToUPTR(nodeConstructorFactory, (LiteralNode)node);
                break;
            }
            case 4: {
                result = this.sortContainerNodeConverter.convertToUPTR(this, nodeConstructorFactory, (SortContainerNode)node, stack, depth, positionStore, filteringTracker, actionExecutor, environment);
                break;
            }
            case 5: {
                result = this.listContainerNodeConverter.convertToUPTR(this, nodeConstructorFactory, (ExpandableContainerNode)node, stack, depth, positionStore, filteringTracker, actionExecutor, environment);
                break;
            }
            case 10: {
                result = this.convert(nodeConstructorFactory, ((SortContainerNode)node).getFirstAlternative().getNode(), stack, depth, positionStore, filteringTracker, actionExecutor, environment, cacheMode);
                break;
            }
            case 9: {
                result = this.skippedNodeConverter.convertToUPTR(nodeConstructorFactory, (SkippedNode)node, positionStore);
                break;
            }
            default: {
                throw new IllegalArgumentException("Incorrect result node id: " + node.getTypeIdentifier());
            }
        }
        if (cacheMode == INodeFlattener.CacheMode.CACHE_MODE_FULL) {
            node.setTree(result);
        } else if (cacheMode == INodeFlattener.CacheMode.CACHE_MODE_SHARING_ONLY) {
            T existing = this.treeCache.get(result);
            if (existing == null) {
                this.treeCache.put(result, result);
            } else {
                result = existing;
            }
        }
        return result;
    }

    @Override
    public T convert(INodeConstructorFactory<T, S> nodeConstructorFactory, AbstractNode parseTree, PositionStore positionStore, FilteringTracker filteringTracker, IActionExecutor<T> actionExecutor, Object rootEnvironment) {
        return this.convert(nodeConstructorFactory, parseTree, new IndexedStack<AbstractNode>(), 0, positionStore, filteringTracker, actionExecutor, rootEnvironment, INodeFlattener.CacheMode.CACHE_MODE_NONE);
    }
}

