/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack;

import org.rascalmpl.parser.gtd.stack.AbstractExpandableStackNode;
import org.rascalmpl.parser.gtd.stack.AbstractStackNode;
import org.rascalmpl.parser.gtd.stack.StackNodeVisitor;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;
import org.rascalmpl.parser.gtd.stack.filter.IEnterFilter;

public final class EmptyStackNode<P>
extends AbstractExpandableStackNode<P> {
    private final P production;
    private final String name;
    private final AbstractStackNode<P> emptyChild;
    private static final AbstractStackNode<?>[] children = new AbstractStackNode[0];

    public EmptyStackNode(int id, int dot, P production) {
        super(id, dot);
        this.production = production;
        this.name = "empty" + id;
        this.emptyChild = this.generateEmptyChild();
    }

    public EmptyStackNode(int id, int dot, P production, IEnterFilter[] enterFilters, ICompletionFilter[] completionFilters) {
        super(id, dot, enterFilters, completionFilters);
        this.production = production;
        this.name = "empty" + id;
        this.emptyChild = this.generateEmptyChild();
    }

    private EmptyStackNode(EmptyStackNode<P> original, int startLocation) {
        super(original, startLocation);
        this.production = original.production;
        this.name = original.name;
        this.emptyChild = original.emptyChild;
    }

    private AbstractStackNode<P> generateEmptyChild() {
        AbstractStackNode<P> empty = EMPTY.getCleanCopy(-1);
        empty.setAlternativeProduction(this.production);
        return empty;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AbstractStackNode<P> getCleanCopy(int startLocation) {
        return new EmptyStackNode<P>(this, startLocation);
    }

    @Override
    public AbstractStackNode<P>[] getChildren() {
        return children;
    }

    @Override
    public boolean canBeEmpty() {
        return true;
    }

    @Override
    public AbstractStackNode<P> getEmptyChild() {
        return this.emptyChild;
    }

    @Override
    public String toShortString() {
        return this.name;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append('(');
        sb.append(this.startLocation);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public boolean equals(Object peer) {
        return super.equals(peer);
    }

    @Override
    public boolean isEqual(AbstractStackNode<P> stackNode) {
        if (!(stackNode instanceof EmptyStackNode)) {
            return false;
        }
        return this.hasEqualFilters(stackNode);
    }

    @Override
    public <R> R accept(StackNodeVisitor<P, R> visitor) {
        return visitor.visit(this);
    }
}

