/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack;

import org.rascalmpl.parser.gtd.stack.AbstractExpandableStackNode;
import org.rascalmpl.parser.gtd.stack.AbstractStackNode;
import org.rascalmpl.parser.gtd.stack.StackNodeVisitor;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;
import org.rascalmpl.parser.gtd.stack.filter.IEnterFilter;

public class SequenceStackNode<P>
extends AbstractExpandableStackNode<P> {
    private final P production;
    private final String name;
    private final AbstractStackNode<P>[] children;

    public SequenceStackNode(int id, int dot, P production, AbstractStackNode<P>[] children) {
        super(id, dot);
        this.production = production;
        this.name = String.valueOf(id);
        this.children = this.generateChildren(children);
    }

    public SequenceStackNode(int id, int dot, P production, AbstractStackNode<P>[] children, IEnterFilter[] enterFilters, ICompletionFilter[] completionFilters) {
        super(id, dot, enterFilters, completionFilters);
        this.production = production;
        this.name = String.valueOf(id);
        this.children = this.generateChildren(children);
    }

    private SequenceStackNode(SequenceStackNode<P> original, int startLocation) {
        super(original, startLocation);
        this.production = original.production;
        this.name = original.name;
        this.children = original.children;
    }

    private AbstractStackNode<P>[] generateChildren(AbstractStackNode<P>[] children) {
        AbstractStackNode[] prod = new AbstractStackNode[children.length];
        for (int i = children.length - 1; i >= 0; --i) {
            AbstractStackNode<P> child = children[i].getCleanCopy(-1);
            child.setProduction(prod);
            prod[i] = child;
        }
        prod[prod.length - 1].setAlternativeProduction(this.production);
        return new AbstractStackNode[]{prod[0]};
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AbstractStackNode<P> getCleanCopy(int startLocation) {
        return new SequenceStackNode<P>(this, startLocation);
    }

    @Override
    public AbstractStackNode<P>[] getChildren() {
        return this.children;
    }

    @Override
    public boolean canBeEmpty() {
        return false;
    }

    @Override
    public AbstractStackNode<P> getEmptyChild() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toShortString() {
        return this.name;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("seq");
        sb.append(this.name);
        sb.append('(');
        sb.append(this.startLocation);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return this.production.hashCode();
    }

    @Override
    public boolean equals(Object peer) {
        return super.equals(peer);
    }

    @Override
    public boolean isEqual(AbstractStackNode<P> stackNode) {
        if (!(stackNode instanceof SequenceStackNode)) {
            return false;
        }
        SequenceStackNode otherNode = (SequenceStackNode)stackNode;
        if (!this.production.equals(otherNode.production)) {
            return false;
        }
        return this.hasEqualFilters(stackNode);
    }

    @Override
    public <R> R accept(StackNodeVisitor<P, R> visitor) {
        return visitor.visit(this);
    }
}

