/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.util;

public class IndexedIntegerList {
    private static final int DEFAULT_SIZE = 8;
    private int[] elements;
    private int size;

    public IndexedIntegerList() {
        this.elements = new int[8];
    }

    public IndexedIntegerList(IndexedIntegerList original) {
        int[] oldElements = original.elements;
        int length = oldElements.length;
        this.size = original.size;
        this.elements = new int[length];
        System.arraycopy(oldElements, 0, this.elements, 0, this.size);
    }

    public void enlarge() {
        int[] oldElements = this.elements;
        this.elements = new int[this.size << 1];
        System.arraycopy(oldElements, 0, this.elements, 0, this.size);
    }

    public void add(int element) {
        while (this.size >= this.elements.length) {
            this.enlarge();
        }
        this.elements[this.size++] = element;
    }

    public int getElement(int index) {
        return this.elements[index];
    }

    public boolean contains(int element) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.elements[i] != element) continue;
            return true;
        }
        return false;
    }

    public int find(int element) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.elements[i] != element) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.elements.length;
    }

    public void clear() {
        int length = this.elements.length;
        this.elements = new int[length];
        this.size = 0;
    }

    public void dirtyClear() {
        this.size = 0;
    }
}

