/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.uptr.recovery;

import io.usethesource.vallang.IConstructor;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Triple;
import org.rascalmpl.parser.gtd.ExpectsProvider;
import org.rascalmpl.parser.gtd.recovery.IRecoverer;
import org.rascalmpl.parser.gtd.result.AbstractNode;
import org.rascalmpl.parser.gtd.result.SkippedNode;
import org.rascalmpl.parser.gtd.stack.AbstractExpandableStackNode;
import org.rascalmpl.parser.gtd.stack.AbstractStackNode;
import org.rascalmpl.parser.gtd.stack.CaseInsensitiveLiteralStackNode;
import org.rascalmpl.parser.gtd.stack.EmptyStackNode;
import org.rascalmpl.parser.gtd.stack.EpsilonStackNode;
import org.rascalmpl.parser.gtd.stack.LiteralStackNode;
import org.rascalmpl.parser.gtd.stack.NonTerminalStackNode;
import org.rascalmpl.parser.gtd.stack.RecoveryPointStackNode;
import org.rascalmpl.parser.gtd.stack.SkippingStackNode;
import org.rascalmpl.parser.gtd.stack.StackNodeVisitorAdapter;
import org.rascalmpl.parser.gtd.stack.edge.EdgesSet;
import org.rascalmpl.parser.gtd.util.ArrayList;
import org.rascalmpl.parser.gtd.util.DoubleArrayList;
import org.rascalmpl.parser.gtd.util.DoubleStack;
import org.rascalmpl.parser.gtd.util.IdDispenser;
import org.rascalmpl.parser.gtd.util.IntegerObjectList;
import org.rascalmpl.parser.gtd.util.ObjectKeyedIntegerMap;
import org.rascalmpl.parser.gtd.util.Stack;
import org.rascalmpl.parser.uptr.recovery.CaseInsensitiveLiteralMatcher;
import org.rascalmpl.parser.uptr.recovery.InputMatcher;
import org.rascalmpl.parser.uptr.recovery.LiteralMatcher;
import org.rascalmpl.values.parsetrees.ProductionAdapter;

public class ToTokenRecoverer
implements IRecoverer<IConstructor> {
    private URI uri;
    private IdDispenser stackNodeIdDispenser;
    private ExpectsProvider<IConstructor> expectsProvider;
    private Set<Long> processedNodes = new HashSet<Long>();

    public ToTokenRecoverer(URI uri, ExpectsProvider<IConstructor> expectsProvider, IdDispenser stackNodeIdDispenser) {
        this.uri = uri;
        this.expectsProvider = expectsProvider;
        this.stackNodeIdDispenser = stackNodeIdDispenser;
    }

    @Override
    public DoubleArrayList<AbstractStackNode<IConstructor>, AbstractNode> reviveStacks(int[] input, int location, Stack<AbstractStackNode<IConstructor>> unexpandableNodes, Stack<AbstractStackNode<IConstructor>> unmatchableLeafNodes, DoubleStack<DoubleArrayList<AbstractStackNode<IConstructor>, AbstractNode>, AbstractStackNode<IConstructor>> unmatchableMidProductionNodes, DoubleStack<AbstractStackNode<IConstructor>, AbstractNode> filteredNodes) {
        ArrayList<AbstractStackNode<IConstructor>> failedNodes = new ArrayList<AbstractStackNode<IConstructor>>();
        ToTokenRecoverer.collectUnexpandableNodes(unexpandableNodes, failedNodes);
        ToTokenRecoverer.collectUnmatchableMidProductionNodes(location, unmatchableMidProductionNodes, failedNodes);
        return this.reviveFailedNodes(input, location, failedNodes);
    }

    /*
     * WARNING - void declaration
     */
    private DoubleArrayList<AbstractStackNode<IConstructor>, AbstractNode> reviveNodes(int[] input, int location, DoubleArrayList<AbstractStackNode<IConstructor>, ArrayList<IConstructor>> recoveryNodes) {
        DoubleArrayList<AbstractStackNode<IConstructor>, AbstractNode> recoveredNodes = new DoubleArrayList<AbstractStackNode<IConstructor>, AbstractNode>();
        recoveryNodes.sort((e1, e2) -> Integer.compare(((AbstractStackNode)e2.getLeft()).getStartLocation(), ((AbstractStackNode)e1.getLeft()).getStartLocation()));
        HashMap<Triple<IConstructor, Integer, Integer>, SkippingStackNode<IConstructor>> addedNodes = new HashMap<Triple<IConstructor, Integer, Integer>, SkippingStackNode<IConstructor>>();
        for (int i = 0; i < recoveryNodes.size(); ++i) {
            AbstractStackNode<IConstructor> recoveryNode = recoveryNodes.getFirst(i);
            ArrayList<IConstructor> prods = recoveryNodes.getSecond(i);
            int startLocation = recoveryNode.getStartLocation();
            for (int j = prods.size() - 1; j >= 0; --j) {
                IConstructor prod = prods.get(j);
                IConstructor sort = ProductionAdapter.getType(prod);
                List<SkippingStackNode<IConstructor>> skippingNodes = this.findSkippingNodes(input, location, recoveryNode, prod, startLocation);
                for (SkippingStackNode<IConstructor> skippingStackNode : skippingNodes) {
                    void var15_15;
                    int skipLength = skippingStackNode.getLength();
                    Triple<IConstructor, Integer, Integer> key = Triple.of(sort, startLocation, skipLength);
                    SkippingStackNode previouslyAddedNode = (SkippingStackNode)addedNodes.get(key);
                    if (previouslyAddedNode == null) {
                        addedNodes.put(key, skippingStackNode);
                        skippingStackNode.initEdges();
                        recoveredNodes.add(skippingStackNode, skippingStackNode.getResult());
                    } else {
                        SkippingStackNode skippingStackNode2 = previouslyAddedNode;
                    }
                    RecoveryPointStackNode<IConstructor> continuer = new RecoveryPointStackNode<IConstructor>(this.stackNodeIdDispenser.dispenseId(), prod, recoveryNode);
                    EdgesSet<IConstructor> edges = new EdgesSet<IConstructor>(1);
                    edges.add(continuer);
                    continuer.setIncomingEdges(edges);
                    var15_15.addEdges(edges, startLocation);
                }
            }
        }
        return recoveredNodes;
    }

    private void addSkippingStackNode(List<SkippingStackNode<IConstructor>> nodes, IConstructor prod, int startLocation, SkippedNode result) {
        for (SkippingStackNode<IConstructor> node : nodes) {
            if (((SkippedNode)node.getResult()).getLength() != result.getLength()) continue;
            return;
        }
        nodes.add(new SkippingStackNode<IConstructor>(this.stackNodeIdDispenser.dispenseId(), prod, result, startLocation));
    }

    private List<SkippingStackNode<IConstructor>> findSkippingNodes(int[] input, int location, AbstractStackNode<IConstructor> recoveryNode, IConstructor prod, int startLocation) {
        SkippedNode result;
        java.util.ArrayList<SkippingStackNode<IConstructor>> nodes = new java.util.ArrayList<SkippingStackNode<IConstructor>>();
        if (location >= input.length) {
            SkippedNode result2 = SkippingStackNode.createResultUntilEndOfInput(this.uri, input, startLocation);
            this.addSkippingStackNode(nodes, prod, startLocation, result2);
            return nodes;
        }
        List<InputMatcher> endMatchers = this.findEndMatchers(recoveryNode);
        for (InputMatcher endMatcher : endMatchers) {
            InputMatcher.MatchResult endMatch = endMatcher.findMatch(input, startLocation, 0x3FFFFFFF);
            if (endMatch == null) continue;
            result = SkippingStackNode.createResultUntilChar(this.uri, input, startLocation, endMatch.getEnd());
            this.addSkippingStackNode(nodes, prod, startLocation, result);
        }
        List<InputMatcher> nextMatchers = this.findNextMatchers(recoveryNode);
        for (InputMatcher nextMatcher : nextMatchers) {
            InputMatcher.MatchResult nextMatch = nextMatcher.findMatch(input, startLocation + 1, 0x3FFFFFFF);
            if (nextMatch == null) continue;
            result = SkippingStackNode.createResultUntilChar(this.uri, input, startLocation, nextMatch.getStart());
            this.addSkippingStackNode(nodes, prod, startLocation, result);
        }
        return nodes;
    }

    private List<InputMatcher> findEndMatchers(AbstractStackNode<IConstructor> stackNode) {
        java.util.ArrayList<InputMatcher> matchers = new java.util.ArrayList<InputMatcher>();
        AbstractStackNode<IConstructor>[] prod = stackNode.getProduction();
        this.addEndMatchers(prod, prod.length - 1, matchers, new HashSet<Integer>());
        IConstructor parentProduction = stackNode.getParentProduction();
        if (parentProduction != null && ProductionAdapter.isContextFree(parentProduction)) {
            matchers.add(new LiteralMatcher("\n"));
        }
        return matchers;
    }

    private void addEndMatchers(AbstractStackNode<IConstructor>[] prod, int dot, final List<InputMatcher> matchers, final Set<Integer> visitedNodes) {
        if (prod == null || dot < 0 || dot >= prod.length) {
            return;
        }
        AbstractStackNode<IConstructor> last = prod[dot];
        if (visitedNodes.contains(last.getId())) {
            return;
        }
        visitedNodes.add(last.getId());
        if (this.isNullable(last)) {
            this.addEndMatchers(prod, dot - 1, matchers, visitedNodes);
        }
        last.accept(new StackNodeVisitorAdapter<IConstructor, Void>(){

            @Override
            public Void visit(LiteralStackNode<IConstructor> literal) {
                matchers.add(new LiteralMatcher(literal.getLiteral()));
                return null;
            }

            @Override
            public Void visit(CaseInsensitiveLiteralStackNode<IConstructor> literal) {
                matchers.add(new CaseInsensitiveLiteralMatcher(literal.getLiteral()));
                return null;
            }

            @Override
            public Void visit(NonTerminalStackNode<IConstructor> nonTerminal) {
                AbstractStackNode<IConstructor>[] alternatives;
                String name = nonTerminal.getName();
                for (AbstractStackNode<IConstructor> alternative : alternatives = ToTokenRecoverer.this.expectsProvider.getExpects(name)) {
                    ToTokenRecoverer.this.addEndMatchers(alternative.getProduction(), 0, matchers, visitedNodes);
                }
                return null;
            }
        });
    }

    private AbstractStackNode<IConstructor> getSingleParentStack(AbstractStackNode<IConstructor> stackNode) {
        EdgesSet<IConstructor> edgesList;
        if (stackNode == null) {
            return null;
        }
        IntegerObjectList<EdgesSet<IConstructor>> edges = stackNode.getEdges();
        if (edges != null && (edgesList = edges.getValue(0)) != null) {
            return edgesList.get(0);
        }
        return null;
    }

    private List<InputMatcher> findNextMatchers(AbstractStackNode<IConstructor> stackNode) {
        java.util.ArrayList<InputMatcher> matchers = new java.util.ArrayList<InputMatcher>();
        AbstractStackNode<IConstructor> parent = this.getSingleParentStack(stackNode);
        if (parent == null) {
            return matchers;
        }
        this.addNextMatchers(parent.getProduction(), parent.getDot() + 1, matchers, new HashSet<Integer>());
        return matchers;
    }

    private void addNextMatchers(AbstractStackNode<IConstructor>[] prod, int dot, final List<InputMatcher> matchers, final Set<Integer> visitedNodes) {
        if (prod == null || dot < 0 || dot >= prod.length) {
            return;
        }
        AbstractStackNode<IConstructor> next = prod[dot];
        if (visitedNodes.contains(next.getId())) {
            return;
        }
        visitedNodes.add(next.getId());
        if (this.isNullable(next)) {
            this.addNextMatchers(prod, dot + 1, matchers, visitedNodes);
        }
        next.accept(new StackNodeVisitorAdapter<IConstructor, Void>(){

            @Override
            public Void visit(LiteralStackNode<IConstructor> literal) {
                matchers.add(new LiteralMatcher(literal.getLiteral()));
                return null;
            }

            @Override
            public Void visit(CaseInsensitiveLiteralStackNode<IConstructor> literal) {
                matchers.add(new CaseInsensitiveLiteralMatcher(literal.getLiteral()));
                return null;
            }

            @Override
            public Void visit(NonTerminalStackNode<IConstructor> nonTerminal) {
                AbstractStackNode<IConstructor>[] alternatives;
                String name = nonTerminal.getName();
                for (AbstractStackNode<IConstructor> alternative : alternatives = ToTokenRecoverer.this.expectsProvider.getExpects(name)) {
                    ToTokenRecoverer.this.addNextMatchers(alternative.getProduction(), 0, matchers, visitedNodes);
                }
                return null;
            }
        });
    }

    private boolean isNullable(AbstractStackNode<IConstructor> stackNode) {
        if (stackNode instanceof NonTerminalStackNode && stackNode.getName().startsWith("layouts_")) {
            return true;
        }
        if (stackNode instanceof EpsilonStackNode || stackNode instanceof EmptyStackNode) {
            return true;
        }
        if (stackNode instanceof AbstractExpandableStackNode) {
            return stackNode.canBeEmpty();
        }
        return false;
    }

    private DoubleArrayList<AbstractStackNode<IConstructor>, AbstractNode> reviveFailedNodes(int[] input, int location, ArrayList<AbstractStackNode<IConstructor>> failedNodes) {
        DoubleArrayList<AbstractStackNode<IConstructor>, ArrayList<IConstructor>> recoveryNodes = new DoubleArrayList<AbstractStackNode<IConstructor>, ArrayList<IConstructor>>();
        for (int i = failedNodes.size() - 1; i >= 0; --i) {
            AbstractStackNode<IConstructor> failedNode = failedNodes.get(i);
            long id = (long)failedNode.getId() << 32 | (long)failedNode.getStartLocation();
            if (!this.processedNodes.add(id)) continue;
            this.findRecoveryNodes(failedNodes.get(i), recoveryNodes);
        }
        return this.reviveNodes(input, location, recoveryNodes);
    }

    private static void collectUnexpandableNodes(Stack<AbstractStackNode<IConstructor>> unexpandableNodes, ArrayList<AbstractStackNode<IConstructor>> failedNodes) {
        for (int i = unexpandableNodes.getSize() - 1; i >= 0; --i) {
            failedNodes.add(unexpandableNodes.get(i));
        }
    }

    private static void collectUnmatchableMidProductionNodes(int location, DoubleStack<DoubleArrayList<AbstractStackNode<IConstructor>, AbstractNode>, AbstractStackNode<IConstructor>> unmatchableMidProductionNodes, ArrayList<AbstractStackNode<IConstructor>> failedNodes) {
        for (int i = unmatchableMidProductionNodes.getSize() - 1; i >= 0; --i) {
            DoubleArrayList<AbstractStackNode<IConstructor>, AbstractNode> failedNodePredecessors = unmatchableMidProductionNodes.getFirst(i);
            AbstractStackNode<IConstructor> failedNode = unmatchableMidProductionNodes.getSecond(i).getCleanCopy(location);
            for (int j = failedNodePredecessors.size() - 1; j >= 0; --j) {
                AbstractStackNode<IConstructor> predecessor = failedNodePredecessors.getFirst(j);
                AbstractNode predecessorResult = failedNodePredecessors.getSecond(j);
                failedNode.updateNode(predecessor, predecessorResult);
            }
            failedNodes.add(failedNode);
        }
    }

    private void findRecoveryNodes(AbstractStackNode<IConstructor> failer, DoubleArrayList<AbstractStackNode<IConstructor>, ArrayList<IConstructor>> recoveryNodes) {
        ObjectKeyedIntegerMap<AbstractStackNode> visited = new ObjectKeyedIntegerMap<AbstractStackNode>();
        Stack todo = new Stack();
        todo.push(failer);
        while (!todo.isEmpty()) {
            AbstractStackNode node = (AbstractStackNode)todo.pop();
            if (visited.contains(node)) continue;
            visited.put(node, 0);
            ArrayList<IConstructor> recoveryProductions = new ArrayList<IConstructor>();
            this.collectProductions(node, recoveryProductions);
            if (recoveryProductions.size() > 0) {
                this.addRecoveryNode(node, recoveryProductions, recoveryNodes);
            }
            IntegerObjectList edges = node.getEdges();
            for (int i = edges.size() - 1; i >= 0; --i) {
                EdgesSet edgesList = edges.getValue(i);
                if (edgesList == null) continue;
                for (int j = edgesList.size() - 1; j >= 0; --j) {
                    AbstractStackNode parent = edgesList.get(j);
                    todo.push(parent);
                }
            }
        }
    }

    private void addRecoveryNode(AbstractStackNode<IConstructor> node, ArrayList<IConstructor> productions, DoubleArrayList<AbstractStackNode<IConstructor>, ArrayList<IConstructor>> recoveryNodes) {
        for (int i = 0; i < recoveryNodes.size(); ++i) {
            if (recoveryNodes.getFirst(i) != node || !this.equalProductions(productions, recoveryNodes.getSecond(i))) continue;
            return;
        }
        recoveryNodes.add(node, productions);
    }

    private boolean equalProductions(ArrayList<IConstructor> prods1, ArrayList<IConstructor> prods2) {
        if (prods1.size() != prods2.size()) {
            return false;
        }
        for (int j = 0; j < prods1.size(); ++j) {
            if (prods1.get(j) == prods2.get(j)) continue;
            return false;
        }
        return true;
    }

    private void collectProductions(AbstractStackNode<IConstructor> node, ArrayList<IConstructor> productions) {
        IConstructor parentProduction;
        AbstractStackNode<IConstructor>[] production = node.getProduction();
        if (production == null) {
            return;
        }
        if (node.isEndNode() && ProductionAdapter.isContextFree(parentProduction = node.getParentProduction())) {
            productions.add(parentProduction);
            if (ProductionAdapter.isList(parentProduction)) {
                return;
            }
        }
        int dot = node.getDot();
        for (int i = dot + 1; i < production.length; ++i) {
            AbstractStackNode<IConstructor>[][] alternateProductions;
            IConstructor parentProduction2;
            AbstractStackNode<IConstructor> currentNode = production[i];
            if (currentNode.isEndNode() && ProductionAdapter.isContextFree(parentProduction2 = currentNode.getParentProduction())) {
                productions.add(parentProduction2);
            }
            if ((alternateProductions = currentNode.getAlternateProductions()) == null) continue;
            for (int j = alternateProductions.length - 1; j >= 0; --j) {
                this.collectProductions(alternateProductions[j][i], productions);
            }
        }
    }
}

