/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.runtime;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IDateTime;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.IWriter;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.exceptions.InvalidDateTimeException;
import io.usethesource.vallang.io.StandardTextReader;
import io.usethesource.vallang.io.binary.stream.IValueInputStream;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.JavaMethodLink;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.utils.IResourceLocationProvider;
import org.rascalmpl.library.util.ToplevelType;
import org.rascalmpl.runtime.FailReturnFromVoidException;
import org.rascalmpl.runtime.GuardedIValue;
import org.rascalmpl.runtime.InternalCompilerError;
import org.rascalmpl.runtime.RascalExecutionContext;
import org.rascalmpl.runtime.RascalRuntimeValueFactory;
import org.rascalmpl.runtime.SliceDescriptor;
import org.rascalmpl.runtime.SliceOperator;
import org.rascalmpl.runtime.traverse.Traverse;
import org.rascalmpl.types.DefaultRascalTypeVisitor;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.types.RascalTypeFactory;
import org.rascalmpl.uri.SourceLocationURICompare;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public abstract class $RascalModule {
    protected final IRascalValueFactory $RVF;
    final PrintWriter $OUTWRITER;
    final PrintWriter $ERRWRITER;
    final Reader $IN;
    final IRascalMonitor $MONITOR;
    protected final RascalExecutionContext rex;
    protected final IValueFactory $VF;
    public final TypeFactory $TF;
    protected final RascalTypeFactory $RTF;
    public final TypeStore $TS;
    protected final Traverse $TRAVERSE;
    public final IBool Rascal_TRUE;
    public final IBool Rascal_FALSE;
    protected final FailReturnFromVoidException $failReturnFromVoidException;
    private final GuardedIValue UNDEFINED = new GuardedIValue();

    public $RascalModule(RascalExecutionContext rex) {
        this.rex = rex;
        this.$IN = rex.getInReader();
        this.$OUTWRITER = rex.getOutWriter();
        this.$ERRWRITER = rex.getErrWriter();
        this.$MONITOR = rex;
        this.$VF = rex.getIValueFactory();
        this.$RVF = rex.getRascalRuntimeValueFactory();
        this.$TF = rex.getTypeFactory();
        this.$TS = rex.getTypeStore();
        this.$RTF = rex.getRascalTypeFactory();
        rex.setModule(this);
        this.$TRAVERSE = rex.getTraverse();
        this.Rascal_TRUE = this.$VF.bool(true);
        this.Rascal_FALSE = this.$VF.bool(false);
        this.$failReturnFromVoidException = new FailReturnFromVoidException();
    }

    public final IConstructor $reifiedAType(IConstructor t2, IMap definitions) {
        return this.$RVF.reifiedType(t2, definitions);
    }

    protected <T> T $initLibrary(String className) {
        PrintWriter[] outputs = new PrintWriter[]{this.$OUTWRITER, this.$ERRWRITER};
        int writers = 0;
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
            if (clazz.getConstructors().length > 1) {
                throw new IllegalArgumentException("Rascal JavaBridge can only deal with one constructor. This class has multiple: " + clazz);
            }
            Constructor<?>[] constructors = clazz.getConstructors();
            if (constructors.length < 1) {
                throw new JavaMethodLink(className, "no public constructors found", new IllegalArgumentException(className));
            }
            if (constructors.length != 1) {
                throw new JavaMethodLink(className, "more than one public constructor found", new IllegalArgumentException(className));
            }
            Constructor<?> constructor = constructors[0];
            Object[] args = new Object[constructor.getParameterCount()];
            Class<?>[] formals = constructor.getParameterTypes();
            for (int i = 0; i < constructor.getParameterCount(); ++i) {
                if (formals[i].isAssignableFrom(IValueFactory.class)) {
                    args[i] = this.$VF;
                    continue;
                }
                if (formals[i].isAssignableFrom(TypeStore.class)) {
                    args[i] = this.$TS;
                    continue;
                }
                if (formals[i].isAssignableFrom(TypeFactory.class)) {
                    args[i] = TypeFactory.getInstance();
                    continue;
                }
                if (formals[i].isAssignableFrom(PrintWriter.class)) {
                    args[i] = outputs[writers++ % 2];
                    continue;
                }
                if (formals[i].isAssignableFrom(Reader.class)) {
                    args[i] = this.$IN;
                    continue;
                }
                if (formals[i].isAssignableFrom(IRascalMonitor.class)) {
                    args[i] = this.$MONITOR;
                    continue;
                }
                if (formals[i].isAssignableFrom(ClassLoader.class)) {
                    args[i] = this.getClass().getClassLoader();
                    continue;
                }
                if (formals[i].isAssignableFrom(IRascalValueFactory.class)) {
                    args[i] = new RascalRuntimeValueFactory(this.rex);
                    continue;
                }
                if (formals[i].isAssignableFrom($RascalModule.class)) {
                    args[i] = this;
                    continue;
                }
                if (formals[i].isAssignableFrom(IDEServices.class)) {
                    if (this.$MONITOR instanceof IDEServices) {
                        args[i] = (IDEServices)this.$MONITOR;
                        continue;
                    }
                    throw new IllegalArgumentException("No IDE services are available in this environment");
                }
                if (formals[i].isAssignableFrom(IResourceLocationProvider.class)) {
                    args[i] = new IResourceLocationProvider(){

                        @Override
                        public Set<ISourceLocation> findResources(String fileName) {
                            HashSet<ISourceLocation> result = new HashSet<ISourceLocation>();
                            try {
                                for (URL found : Collections.list(this.getClass().getClassLoader().getResources(fileName))) {
                                    try {
                                        result.add($RascalModule.this.$VF.sourceLocation(found.toURI()));
                                    }
                                    catch (URISyntaxException e) {
                                        $RascalModule.this.$MONITOR.warning("WARNING: skipping " + found + " due to URI syntax exception", URIUtil.rootLocation("module-init"));
                                    }
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return result;
                        }
                    };
                    continue;
                }
                throw new IllegalArgumentException(constructor + " has unknown arguments. Only IValueFactory, TypeStore, ClassLoader, PrintWriter, OutputStream, InputStream, &T extends $RascalModule, IRascalValueFactory, TypeFactory and IResourceLocationProvider are supported");
            }
            return (T)constructor.newInstance(args);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoClassDefFoundError | SecurityException | InvocationTargetException e) {
            throw new JavaMethodLink(className, e.getMessage(), e);
        }
    }

    private static void $usage(String module, String error, Type kwargs) {
        PrintWriter $ERR = new PrintWriter(System.err);
        if (!error.isEmpty() && !error.equals("help")) {
            $ERR.println(error);
        }
        $ERR.println("Usage: ");
        $ERR.println("java -cp ... " + module + " <options>");
        if (kwargs.getArity() > 0) {
            $ERR.println(" [options]\n\nOptions:\n");
            for (String param : kwargs.getFieldNames()) {
                $ERR.print("\t-");
                $ERR.print(param);
                if (kwargs.getFieldType(param).isSubtypeOf(TypeFactory.getInstance().boolType())) {
                    $ERR.println("\t[arg]: one of nothing (true), '1', '0', 'true' or 'false';");
                    continue;
                }
                $ERR.println("\t[arg]: " + kwargs.getFieldType(param) + " argument;");
            }
        } else {
            $ERR.println('\n');
        }
        $ERR.flush();
        if (!error.equals("help")) {
            throw new IllegalArgumentException();
        }
    }

    protected static Map<String, IValue> $parseCommandlineParameters(String module, String[] commandline, Type kwTypes) {
        IValueFactory $VF = ValueFactoryFactory.getValueFactory();
        TypeFactory $TF = TypeFactory.getInstance();
        HashMap<String, Type> expectedTypes = new HashMap<String, Type>();
        for (String kwp : kwTypes.getFieldNames()) {
            expectedTypes.put(kwp, kwTypes.getFieldType(kwp));
        }
        HashMap<String, IValue> params = new HashMap<String, IValue>();
        for (int i = 0; i < commandline.length; ++i) {
            IWriter<IList> writer;
            if (commandline[i].equals("-help")) {
                $RascalModule.$usage(module, "help", kwTypes);
                continue;
            }
            if (!commandline[i].startsWith("-")) continue;
            String label = commandline[i].replaceFirst("^-+", "");
            Type expected = (Type)expectedTypes.get(label);
            if (expected == null) {
                $RascalModule.$usage(module, "unknown argument: " + label, kwTypes);
            }
            if (expected.isSubtypeOf(TypeFactory.getInstance().boolType())) {
                String arg;
                if (i == commandline.length - 1 || commandline[i + 1].startsWith("-")) {
                    params.put(label, $VF.bool(true));
                    continue;
                }
                if (i >= commandline.length - 1) continue;
                if ((arg = commandline[++i].trim()).equals("1") || arg.equals("true")) {
                    params.put(label, $VF.bool(true));
                    continue;
                }
                params.put(label, $VF.bool(false));
                continue;
            }
            if (i == commandline.length - 1 || commandline[i + 1].startsWith("-")) {
                $RascalModule.$usage(module, "expected option for " + label, kwTypes);
                continue;
            }
            if (expected.isSubtypeOf($TF.listType($TF.valueType()))) {
                writer = $VF.listWriter();
                while (i + 1 < commandline.length && !commandline[i + 1].startsWith("-")) {
                    writer.append($RascalModule.$parseCommandlineOption(module, kwTypes, expected.getElementType(), commandline[++i]));
                }
                params.put(label, writer.done());
                continue;
            }
            if (expected.isSubtypeOf($TF.setType($TF.valueType()))) {
                writer = $VF.setWriter();
                while (i + 1 < commandline.length && !commandline[i + 1].startsWith("-")) {
                    writer.insert($RascalModule.$parseCommandlineOption(module, kwTypes, expected.getElementType(), commandline[++i]));
                }
                params.put(label, writer.done());
                continue;
            }
            params.put(label, $RascalModule.$parseCommandlineOption(module, kwTypes, expected, commandline[++i]));
        }
        return params;
    }

    private static IValue $parseCommandlineOption(String module, Type kwTypes, Type expected, String option) {
        TypeFactory $TF = TypeFactory.getInstance();
        IValueFactory $VF = ValueFactoryFactory.getValueFactory();
        if (expected.isSubtypeOf($TF.stringType())) {
            return $VF.string(option);
        }
        StringReader reader = new StringReader(option);
        try {
            return new StandardTextReader().read($VF, expected, reader);
        }
        catch (FactTypeUseException e) {
            $RascalModule.$usage(module, "expected " + expected + " but got " + option + " (" + e.getMessage() + ")", kwTypes);
        }
        catch (IOException e) {
            $RascalModule.$usage(module, "unexpected problem while parsing commandline:" + e.getMessage(), kwTypes);
        }
        throw new IllegalArgumentException();
    }

    public final IMap $buildMap(IValue ... values) {
        IMapWriter w = this.$VF.mapWriter();
        if (values.length % 2 != 0) {
            throw new InternalCompilerError("$RascalModule: buildMap should have even number of arguments");
        }
        for (int i = 0; i < values.length; i += 2) {
            w.put(values[i], values[i + 1]);
        }
        return (IMap)w.done();
    }

    public final boolean $intersectsType(Type t1, Type t2) {
        return t1.intersects(t2);
    }

    public final boolean $isComparable(Type t1, Type t2) {
        return this.$isSubtypeOf(t1, t2) || this.$isSubtypeOf(t2, t1);
    }

    public final boolean $isSubtypeOf(Type left, Type right) {
        return left.isSubtypeOf(right);
    }

    public boolean $isTreeProductionEqual(IValue tree, IConstructor production) {
        return tree instanceof ITree && ((ITree)tree).isAppl() && production.equals(((ITree)tree).getProduction());
    }

    public boolean $isNonTerminal(Type treeType, IConstructor expected) {
        return treeType instanceof NonTerminalType && ((NonTerminalType)treeType).getSymbol().equals(expected);
    }

    public boolean $isNonTerminal(Type treeType, Type expected) {
        if (treeType == expected) {
            return true;
        }
        if (treeType instanceof NonTerminalType) {
            NonTerminalType givenNT = (NonTerminalType)treeType;
            NonTerminalType expectedNT = (NonTerminalType)expected;
            return givenNT.getSymbol().equals(expectedNT.getSymbol());
        }
        return false;
    }

    public Type $adt(String adtName) {
        Type adtType = this.$TF.abstractDataType(this.$TS, adtName, new Type[0]);
        return adtType;
    }

    public Type $sort(String adtName) {
        Type adtType = this.$TF.abstractDataType(this.$TS, adtName, new Type[0]);
        this.$TS.declareAbstractDataType(adtType);
        return new NonTerminalType(this.$RVF.constructor(RascalValueFactory.Symbol_Sort, this.$VF.string(adtName)));
    }

    public Type $lex(String adtName) {
        Type adtType = this.$TF.abstractDataType(this.$TS, adtName, new Type[0]);
        this.$TS.declareAbstractDataType(adtType);
        return new NonTerminalType(this.$RVF.constructor(RascalValueFactory.Symbol_Lex, this.$VF.string(adtName)));
    }

    public Type $layouts(String adtName) {
        Type adtType = this.$TF.abstractDataType(this.$TS, adtName, new Type[0]);
        this.$TS.declareAbstractDataType(adtType);
        return new NonTerminalType(this.$RVF.constructor(RascalValueFactory.Symbol_Layouts, this.$VF.string(adtName)));
    }

    public Type $keywords(String adtName) {
        Type adtType = this.$TF.abstractDataType(this.$TS, adtName, new Type[0]);
        this.$TS.declareAbstractDataType(adtType);
        return new NonTerminalType(this.$RVF.constructor(RascalValueFactory.Symbol_Keywords, this.$VF.string(adtName)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IList readBinaryConstantsFile(Class<?> c, String path, int expected_length, String expected_md5Hash) {
        Type constantsFileType = this.$TF.tupleType(this.$TF.integerType(), this.$TF.stringType(), this.$TF.listType(this.$TF.valueType()));
        ISourceLocation loc = null;
        try {
            URL url = c.getClassLoader().getResource(path);
            if (url == null) {
                throw RuntimeExceptionFactory.io(this.$VF.string("Cannot find resource " + path));
            }
            loc = this.$VF.sourceLocation(url.toURI());
        }
        catch (URISyntaxException e) {
            System.err.println("readBinaryConstantsFile: " + path + " throws " + e.getMessage());
        }
        try (IValueInputStream in = this.constructValueReader(loc);){
            IValue constantsFile = in.read();
            if (!constantsFile.getType().isSubtypeOf(constantsFileType)) throw RuntimeExceptionFactory.io(this.$VF.string("Requested type " + constantsFileType + ", but found " + constantsFile.getType()));
            ITuple tup = (ITuple)constantsFile;
            int found_length = ((IInteger)tup.get(0)).intValue();
            if (found_length != expected_length) {
                throw RuntimeExceptionFactory.io(this.$VF.string("Expected " + expected_length + " constants, but only " + found_length + " found in " + path));
            }
            String found_hash = ((IString)tup.get(1)).getValue();
            if (!found_hash.equals(expected_md5Hash)) {
                throw RuntimeExceptionFactory.io(this.$VF.string("Expected md5Hash " + expected_md5Hash + ", but got " + found_hash + " for " + path));
            }
            IList iList = (IList)tup.get(2);
            return iList;
        }
        catch (IOException e) {
            System.err.println("readBinaryConstantsFile: " + loc + " throws " + e.getMessage());
            throw RuntimeExceptionFactory.io(this.$VF.string(e.getMessage()));
        }
        catch (Exception e) {
            System.err.println("readBinaryConstantsFile: " + loc + " throws " + e.getMessage());
            throw RuntimeExceptionFactory.io(this.$VF.string(e.getMessage()));
        }
    }

    private IValueInputStream constructValueReader(ISourceLocation loc) throws IOException {
        FileChannel channel;
        URIResolverRegistry registry = URIResolverRegistry.getInstance();
        if (registry.supportsReadableFileChannel(loc) && (channel = registry.getReadableFileChannel(loc)) != null) {
            return new IValueInputStream(channel, this.$VF, RascalValueFactory.TYPE_STORE_SUPPLIER);
        }
        return new IValueInputStream(registry.getInputStream(loc), this.$VF, RascalValueFactory.TYPE_STORE_SUPPLIER);
    }

    public final IInteger $aint_add_aint(IInteger lhs, IInteger rhs) {
        return lhs.add(rhs);
    }

    public final IReal $aint_add_areal(IInteger lhs, IReal rhs) {
        return lhs.add(rhs);
    }

    public final INumber $aint_add_arat(IInteger lhs, IRational rhs) {
        return lhs.add(rhs);
    }

    public final INumber $aint_add_anum(IInteger lhs, INumber rhs) {
        return lhs.add(rhs);
    }

    public final INumber $areal_add_aint(IReal lhs, IInteger rhs) {
        return lhs.add(rhs);
    }

    public final IReal $areal_add_areal(IReal lhs, IReal rhs) {
        return lhs.add(rhs);
    }

    public final INumber $areal_add_arat(IReal lhs, IRational rhs) {
        return lhs.add(rhs);
    }

    public final INumber $areal_add_anum(IReal lhs, INumber rhs) {
        return lhs.add(rhs);
    }

    public final INumber $arat_add_aint(IRational lhs, IInteger rhs) {
        return lhs.add(rhs);
    }

    public final INumber $arat_add_areal(IRational lhs, IReal rhs) {
        return lhs.add(rhs);
    }

    public final IRational $arat_add_arat(IRational lhs, IRational rhs) {
        return lhs.add(rhs);
    }

    public final INumber $arat_add_anum(IRational lhs, INumber rhs) {
        return lhs.add(rhs);
    }

    public final INumber $anum_add_aint(INumber lhs, IInteger rhs) {
        return lhs.add(rhs);
    }

    public final INumber $anum_add_areal(INumber lhs, IReal rhs) {
        return lhs.add(rhs);
    }

    public final INumber $anum_add_arat(INumber lhs, IRational rhs) {
        return lhs.add(rhs);
    }

    public final INumber $anum_add_anum(INumber lhs, INumber rhs) {
        return lhs.add(rhs);
    }

    public final IString $astr_add_astr(IString lhs, IString rhs) {
        return lhs.concat(rhs);
    }

    public final ISourceLocation $aloc_add_astr(ISourceLocation sloc, IString s2) {
        Object path;
        Object object = path = sloc.hasPath() ? sloc.getPath() : "";
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        path = ((String)path).concat(s2.getValue());
        return this.$aloc_field_update("path", this.$VF.string((String)path), sloc);
    }

    public final ITuple $atuple_add_atuple(ITuple t1, ITuple t2) {
        int i;
        int len1 = t1.arity();
        int len2 = t2.arity();
        IValue[] elems = new IValue[len1 + len2];
        for (i = 0; i < len1; ++i) {
            elems[i] = t1.get(i);
        }
        for (i = 0; i < len2; ++i) {
            elems[len1 + i] = t2.get(i);
        }
        return this.$VF.tuple(elems);
    }

    public final IList $alist_add_alist(IList lhs, IList rhs) {
        return lhs.concat(rhs);
    }

    public final IList $alist_add_elm(IList lhs, IValue rhs) {
        return lhs.append(rhs);
    }

    public final IList $elm_add_alist(IValue lhs, IList rhs) {
        return rhs.insert(lhs);
    }

    public final ISet $aset_add_aset(ISet lhs, ISet rhs) {
        return lhs.union(rhs);
    }

    public final ISet $aset_add_elm(ISet lhs, IValue rhs) {
        return lhs.insert(rhs);
    }

    public final ISet $elm_add_aset(IValue lhs, ISet rhs) {
        return rhs.insert(lhs);
    }

    public final IMap $amap_add_amap(IMap lhs, IMap rhs) {
        return lhs.join(rhs);
    }

    public final IValue $annotation_get(IConstructor cons, String fieldName) {
        if (cons.asWithKeywordParameters().hasParameter(fieldName)) {
            return cons.asWithKeywordParameters().getParameter(fieldName);
        }
        throw RuntimeExceptionFactory.noSuchAnnotation(fieldName);
    }

    public final IValue $annotation_get(INode cons, String fieldName) {
        if (cons.asWithKeywordParameters().hasParameter(fieldName)) {
            return cons.asWithKeywordParameters().getParameter(fieldName);
        }
        throw RuntimeExceptionFactory.noSuchAnnotation(fieldName);
    }

    public final GuardedIValue $guarded_annotation_get(IConstructor cons, String fieldName) {
        if (cons.asWithKeywordParameters().hasParameter(fieldName)) {
            return new GuardedIValue(cons.asWithKeywordParameters().getParameter(fieldName));
        }
        if (TreeAdapter.isTree(cons) && TreeAdapter.isAppl((ITree)cons)) {
            IConstructor prod = ((ITree)cons).getProduction();
            for (IValue elem : ProductionAdapter.getSymbols(prod)) {
                IConstructor arg = (IConstructor)elem;
                if (!SymbolAdapter.isLabel(arg) || !SymbolAdapter.getLabel(arg).equals(fieldName)) continue;
                return new GuardedIValue(arg);
            }
        }
        return this.UNDEFINED;
    }

    public final GuardedIValue $guarded_annotation_get(INode cons, String fieldName) {
        if (cons.asWithKeywordParameters().hasParameter(fieldName)) {
            return new GuardedIValue(cons.asWithKeywordParameters().getParameter(fieldName));
        }
        return this.UNDEFINED;
    }

    public final IBool $assert_fails(IString message) {
        throw RuntimeExceptionFactory.assertionFailed(message);
    }

    public final ISourceLocation $create_aloc(IString uri) {
        try {
            return URIUtil.createFromURI(uri.getValue());
        }
        catch (URISyntaxException e) {
            throw RuntimeExceptionFactory.malformedURI(uri.getValue());
        }
        catch (UnsupportedOperationException e) {
            throw RuntimeExceptionFactory.malformedURI(uri.getValue() + ":" + e.getMessage());
        }
    }

    public final ISourceLocation $create_aloc_with_offset(ISourceLocation loc, IInteger offset, IInteger length) {
        return this.$VF.sourceLocation(loc, offset.intValue(), length.intValue());
    }

    public final ISourceLocation $create_aloc_with_offset_and_begin_end(ISourceLocation loc, IInteger offset, IInteger length, ITuple begin, ITuple end) {
        int beginLine = ((IInteger)begin.get(0)).intValue();
        int beginCol = ((IInteger)begin.get(1)).intValue();
        int endLine = ((IInteger)end.get(0)).intValue();
        int endCol = ((IInteger)end.get(1)).intValue();
        return this.$VF.sourceLocation(loc, offset.intValue(), length.intValue(), beginLine, endLine, beginCol, endCol);
    }

    public final IInteger $aint_divide_aint(IInteger a, IInteger b) {
        try {
            return a.divide(b);
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException("divide by zero");
        }
    }

    public final INumber $aint_divide_areal(IInteger a, IReal b) {
        try {
            return a.multiply(this.$VF.real(1.0)).divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException("divide by zero");
        }
    }

    public final IRational $aint_divide_arat(IInteger a, IRational b) {
        try {
            return a.toRational().divide(b);
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException("divide by zero");
        }
    }

    public final INumber $aint_divide_anum(IInteger a, INumber b) {
        try {
            return a.multiply(this.$VF.real(1.0)).divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException("divide by zero");
        }
    }

    public final IReal $areal_divide_aint(IReal a, IInteger b) {
        try {
            return (IReal)a.divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException("divide by zero");
        }
    }

    public final IReal $areal_divide_areal(IReal a, IReal b) {
        try {
            return a.divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException("divide by zero");
        }
    }

    public final IReal $areal_divide_arat(IReal a, IRational b) {
        try {
            return (IReal)a.divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException("divide by zero");
        }
    }

    public final INumber $areal_divide_anum(IReal a, INumber b) {
        try {
            return a.divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException("divide by zero");
        }
    }

    public final IRational $arat_divide_aint(IRational a, IInteger b) {
        try {
            return a.divide(b);
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException("divide by zero");
        }
    }

    public final IReal $arat_divide_areal(IRational a, IReal b) {
        try {
            return a.multiply(this.$VF.real(1.0)).divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException("divide by zero");
        }
    }

    public final IRational $arat_divide_arat(IRational a, IRational b) {
        try {
            return a.toRational().divide(b);
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException("divide by zero");
        }
    }

    public final INumber $arat_divide_anum(IRational a, INumber b) {
        try {
            return a.multiply(this.$VF.real(1.0)).divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException("divide by zero");
        }
    }

    public final INumber $anum_divide_aint(INumber a, IInteger b) {
        try {
            return a.divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException("divide by zero");
        }
    }

    public final INumber $anum_divide_areal(INumber a, IReal b) {
        try {
            return a.divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException("divide by zero");
        }
    }

    public final INumber $anum_divide_arat(INumber a, IRational b) {
        try {
            return a.divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException("divide by zero");
        }
    }

    public final INumber $anum_divide_anum(INumber a, INumber b) {
        try {
            return a.divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException("divide by zero");
        }
    }

    public final IBool $equal(IValue left, IValue right) {
        Type leftType = left.getType();
        Type rightType = right.getType();
        if (leftType.isSubtypeOf(this.$TF.numberType()) && rightType.isSubtypeOf(this.$TF.numberType())) {
            return ((INumber)left).equal((INumber)right);
        }
        if (leftType.isNode() && rightType.isNode()) {
            return ((INode)left).equals((INode)right) ? this.Rascal_TRUE : this.Rascal_FALSE;
        }
        if (left instanceof ITree && right instanceof ITree) {
            return this.$VF.bool(left.equals(right));
        }
        return this.$VF.bool(left.equals(right));
    }

    public final IString $anode_get_name(INode nd) {
        return this.$VF.string(nd.getName());
    }

    public final IValue $anode_get_field(INode nd, String fieldName) {
        IValue res = nd.asWithKeywordParameters().getParameter(fieldName);
        if (res != null) {
            return res;
        }
        if (nd instanceof IConstructor) {
            IConstructor c = (IConstructor)nd;
            if (c.has(fieldName)) {
                return c.get(fieldName);
            }
            IValue res1 = c.asWithKeywordParameters().getParameter(fieldName);
            if (res1 != null) {
                return res1;
            }
        }
        throw RuntimeExceptionFactory.noSuchField(fieldName);
    }

    public final GuardedIValue $guarded_anode_get_field(INode nd, String fieldName) {
        try {
            IValue result = this.$anode_get_field(nd, fieldName);
            return new GuardedIValue(result);
        }
        catch (RuntimeException e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $aadt_get_field(IConstructor cons, String fieldName) {
        ITree res;
        TreeAdapter.FieldResult fldres;
        Type consType = cons.getConstructorType();
        if (TreeAdapter.isTree(cons) && TreeAdapter.isAppl((ITree)cons) && (fldres = TreeAdapter.getLabeledField((ITree)cons, fieldName)) != null && (res = TreeAdapter.getLabeledField((ITree)((ITree)cons), (String)fieldName).tree) != null) {
            return res;
        }
        if (consType.hasField(fieldName)) {
            IValue res2 = cons.get(fieldName);
            return res2;
        }
        IValue result = cons.asWithKeywordParameters().getParameter(fieldName);
        if (result != null) {
            return result;
        }
        throw RuntimeExceptionFactory.noSuchField(fieldName);
    }

    public final GuardedIValue $guarded_aadt_get_field(IConstructor cons, String fieldName) {
        try {
            IValue result = this.$aadt_get_field(cons, fieldName);
            return new GuardedIValue(result);
        }
        catch (RuntimeException e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $aloc_get_field(ISourceLocation sloc, String field) {
        IValue v;
        switch (field) {
            case "scheme": {
                String s2 = sloc.getScheme();
                v = this.$VF.string(s2 == null ? "" : s2);
                break;
            }
            case "authority": {
                v = this.$VF.string(sloc.hasAuthority() ? sloc.getAuthority() : "");
                break;
            }
            case "host": {
                if (!URIResolverRegistry.getInstance().supportsHost(sloc)) {
                    throw RuntimeExceptionFactory.noSuchField("The scheme " + sloc.getScheme() + " does not support the host field, use authority instead.");
                }
                String s3 = sloc.getURI().getHost();
                v = this.$VF.string(s3 == null ? "" : s3);
                break;
            }
            case "path": {
                v = this.$VF.string(sloc.hasPath() ? sloc.getPath() : "/");
                break;
            }
            case "parent": {
                Object path = sloc.getPath();
                if (((String)path).equals("") || ((String)path).equals("/")) {
                    throw RuntimeExceptionFactory.noParent(sloc);
                }
                while (((String)path).endsWith("/")) {
                    path = ((String)path).substring(0, ((String)path).length() - "/".length());
                }
                int i = ((String)path).lastIndexOf("/");
                if (i != -1) {
                    path = ((String)path).substring(0, i);
                    if (sloc.getScheme().equalsIgnoreCase("file") && ((String)path).lastIndexOf("/") == 0 && ((String)path).endsWith(":")) {
                        path = (String)path + "/";
                    }
                    v = this.$aloc_field_update("path", this.$VF.string((String)path), sloc);
                    break;
                }
                throw RuntimeExceptionFactory.noParent(sloc);
            }
            case "file": {
                String path;
                String string = path = sloc.hasPath() ? sloc.getPath() : "";
                while (path.endsWith("/")) {
                    path = path.substring(0, path.length() - "/".length());
                }
                int i = path.lastIndexOf("/");
                if (i != -1) {
                    path = path.substring(i + "/".length());
                }
                v = this.$VF.string(path);
                break;
            }
            case "ls": {
                ISourceLocation resolved = sloc;
                if (URIResolverRegistry.getInstance().exists(resolved) && URIResolverRegistry.getInstance().isDirectory(resolved)) {
                    IListWriter w = this.$VF.listWriter();
                    try {
                        for (ISourceLocation elem : URIResolverRegistry.getInstance().list(resolved)) {
                            w.append(elem);
                        }
                    }
                    catch (FactTypeUseException | IOException e) {
                        throw RuntimeExceptionFactory.io(this.$VF.string(e.getMessage()));
                    }
                    v = w.done();
                    break;
                }
                throw RuntimeExceptionFactory.io(this.$VF.string("You can only access ls on a directory, or a container."));
            }
            case "extension": {
                String path;
                String string = path = sloc.hasPath() ? sloc.getPath() : "";
                while (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                int slashIndex = path.lastIndexOf("/");
                if (slashIndex == -1) {
                    v = this.$VF.string("");
                    break;
                }
                int j = path.substring(slashIndex).lastIndexOf(46);
                if (j != -1) {
                    v = this.$VF.string(path.substring(slashIndex + j + 1));
                    break;
                }
                v = this.$VF.string("");
                break;
            }
            case "fragment": {
                v = this.$VF.string(sloc.hasFragment() ? sloc.getFragment() : "");
                break;
            }
            case "query": {
                v = this.$VF.string(sloc.hasQuery() ? sloc.getQuery() : "");
                break;
            }
            case "params": {
                String query = sloc.hasQuery() ? sloc.getQuery() : "";
                IMapWriter res = this.$VF.mapWriter();
                if (query.length() > 0) {
                    String[] params;
                    for (String param : params = query.split("&")) {
                        String[] keyValue = param.split("=");
                        res.put(this.$VF.string(keyValue[0]), this.$VF.string(keyValue[1]));
                    }
                }
                v = res.done();
                break;
            }
            case "user": {
                if (!URIResolverRegistry.getInstance().supportsHost(sloc)) {
                    throw RuntimeExceptionFactory.noSuchField("The scheme " + sloc.getScheme() + " does not support the user field, use authority instead.");
                }
                String s4 = sloc.getURI().getUserInfo();
                v = this.$VF.string(s4 == null ? "" : s4);
                break;
            }
            case "port": {
                if (!URIResolverRegistry.getInstance().supportsHost(sloc)) {
                    throw RuntimeExceptionFactory.noSuchField("The scheme " + sloc.getScheme() + " does not support the port field, use authority instead.");
                }
                int n = sloc.getURI().getPort();
                v = this.$VF.integer(n);
                break;
            }
            case "length": {
                if (sloc.hasOffsetLength()) {
                    v = this.$VF.integer(sloc.getLength());
                    break;
                }
                throw RuntimeExceptionFactory.unavailableInformation(null, null);
            }
            case "offset": {
                if (sloc.hasOffsetLength()) {
                    v = this.$VF.integer(sloc.getOffset());
                    break;
                }
                throw RuntimeExceptionFactory.unavailableInformation(null, null);
            }
            case "begin": {
                if (sloc.hasLineColumn()) {
                    v = this.$VF.tuple(this.$VF.integer(sloc.getBeginLine()), this.$VF.integer(sloc.getBeginColumn()));
                    break;
                }
                throw RuntimeExceptionFactory.unavailableInformation(null, null);
            }
            case "end": {
                if (sloc.hasLineColumn()) {
                    v = this.$VF.tuple(this.$VF.integer(sloc.getEndLine()), this.$VF.integer(sloc.getEndColumn()));
                    break;
                }
                throw RuntimeExceptionFactory.unavailableInformation(null, null);
            }
            case "uri": {
                v = this.$VF.string(sloc.getURI().toString());
                break;
            }
            case "top": {
                v = sloc.top();
                break;
            }
            default: {
                throw RuntimeExceptionFactory.noSuchField(field);
            }
        }
        return v;
    }

    public final GuardedIValue $guarded_aloc_get_field(ISourceLocation sloc, String field) {
        try {
            IValue result = this.$aloc_get_field(sloc, field);
            return new GuardedIValue(result);
        }
        catch (RuntimeException e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $adatetime_get_field(IDateTime dt, String field) {
        try {
            IValue v;
            switch (field) {
                case "isDate": {
                    v = this.$VF.bool(dt.isDate());
                    break;
                }
                case "isTime": {
                    v = this.$VF.bool(dt.isTime());
                    break;
                }
                case "isDateTime": {
                    v = this.$VF.bool(dt.isDateTime());
                    break;
                }
                case "century": {
                    if (!dt.isTime()) {
                        v = this.$VF.integer(dt.getCentury());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "year": {
                    if (!dt.isTime()) {
                        v = this.$VF.integer(dt.getYear());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "month": {
                    if (!dt.isTime()) {
                        v = this.$VF.integer(dt.getMonthOfYear());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "day": {
                    if (!dt.isTime()) {
                        v = this.$VF.integer(dt.getDayOfMonth());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "hour": {
                    if (!dt.isDate()) {
                        v = this.$VF.integer(dt.getHourOfDay());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "minute": {
                    if (!dt.isDate()) {
                        v = this.$VF.integer(dt.getMinuteOfHour());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "second": {
                    if (!dt.isDate()) {
                        v = this.$VF.integer(dt.getSecondOfMinute());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "millisecond": {
                    if (!dt.isDate()) {
                        v = this.$VF.integer(dt.getMillisecondsOfSecond());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "timezoneOffsetHours": {
                    if (!dt.isDate()) {
                        v = this.$VF.integer(dt.getTimezoneOffsetHours());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "timezoneOffsetMinutes": {
                    if (!dt.isDate()) {
                        v = this.$VF.integer(dt.getTimezoneOffsetMinutes());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "justDate": {
                    if (!dt.isTime()) {
                        v = this.$VF.date(dt.getYear(), dt.getMonthOfYear(), dt.getDayOfMonth());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "justTime": {
                    if (!dt.isDate()) {
                        v = this.$VF.time(dt.getHourOfDay(), dt.getMinuteOfHour(), dt.getSecondOfMinute(), dt.getMillisecondsOfSecond(), dt.getTimezoneOffsetHours(), dt.getTimezoneOffsetMinutes());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                default: {
                    throw RuntimeExceptionFactory.noSuchField(field);
                }
            }
            return v;
        }
        catch (InvalidDateTimeException e) {
            throw RuntimeExceptionFactory.illegalArgument(dt);
        }
    }

    public final GuardedIValue $guarded_datetime_get_field(IDateTime dt, String field) {
        try {
            IValue result = this.$adatetime_get_field(dt, field);
            return new GuardedIValue(result);
        }
        catch (RuntimeException e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $atuple_get_field(ITuple tup, String fieldName) {
        IValue result = tup.get(fieldName);
        if (result == null) {
            throw RuntimeExceptionFactory.noSuchField(fieldName);
        }
        return result;
    }

    public final IValue $atuple_get_field_by_index(ITuple tup, int index) {
        IValue result = tup.get(index);
        return result;
    }

    public final GuardedIValue $guarded_atuple_get_field(ITuple tup, String fieldName) {
        try {
            IValue result = this.$atuple_get_field(tup, fieldName);
            return new GuardedIValue(result);
        }
        catch (RuntimeException e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $areified_get_field(IConstructor rt, String field) {
        return rt.get(field);
    }

    public final IValue $atuple_field_project(ITuple tup, IValue ... fields) {
        int n = fields.length;
        IValue[] newFields = new IValue[n];
        for (int i = 0; i < n; ++i) {
            IValue field = fields[i];
            newFields[i] = field.getType().isInteger() ? tup.get(((IInteger)field).intValue()) : tup.get(((IString)field).getValue());
        }
        return n - 1 > 1 ? this.$VF.tuple(newFields) : newFields[0];
    }

    public final GuardedIValue $guarded_atuple_field_project(ITuple tup, IValue ... fields) {
        try {
            return new GuardedIValue(this.$atuple_field_project(tup, fields));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final ISet $amap_field_project(IMap map, IValue ... fields) {
        ISetWriter w = this.$VF.setWriter();
        int indexArity = fields.length;
        int[] intFields = new int[indexArity];
        for (int i = 0; i < indexArity; ++i) {
            intFields[i] = ((IInteger)fields[i]).intValue();
        }
        IValue[] elems = new IValue[indexArity];
        Iterator<Map.Entry<IValue, IValue>> iter = map.entryIterator();
        while (iter.hasNext()) {
            Map.Entry<IValue, IValue> entry = iter.next();
            for (int j = 0; j < fields.length; ++j) {
                elems[j] = intFields[j] == 0 ? entry.getKey() : entry.getValue();
            }
            w.insert(indexArity > 1 ? this.$VF.tuple(elems) : elems[0]);
        }
        return (ISet)w.done();
    }

    public final GuardedIValue $guarded_amap_field_project(IMap map, IValue ... fields) {
        try {
            return new GuardedIValue(this.$amap_field_project(map, fields));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final ISet $arel_field_project(ISet set, IValue ... fields) {
        int indexArity = fields.length;
        int[] intFields = new int[indexArity];
        for (int i = 0; i < indexArity; ++i) {
            intFields[i] = ((IInteger)fields[i]).intValue();
        }
        return set.asRelation().project(intFields);
    }

    public final GuardedIValue $guarded_arel_field_project(ISet set, IValue ... fields) {
        try {
            return new GuardedIValue(this.$arel_field_project(set, fields));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final IList $alrel_field_project(IList lrel, IValue ... fields) {
        int indexArity = fields.length;
        int[] intFields = new int[indexArity];
        for (int i = 0; i < indexArity; ++i) {
            intFields[i] = ((IInteger)fields[i]).intValue();
        }
        IListWriter w = this.$VF.listWriter();
        IValue[] elems = new IValue[indexArity];
        for (IValue vtup : lrel) {
            ITuple tup = (ITuple)vtup;
            for (int j = 0; j < fields.length; ++j) {
                elems[j] = tup.get(intFields[j]);
            }
            w.append(indexArity > 1 ? this.$VF.tuple(elems) : elems[0]);
        }
        return (IList)w.done();
    }

    public final GuardedIValue $guarded_alrel_field_project(IList lrel, IValue ... fields) {
        try {
            return new GuardedIValue(this.$alrel_field_project(lrel, fields));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final ISourceLocation $aloc_field_update(String field, IValue repl, ISourceLocation sloc) {
        Type replType = repl.getType();
        int iLength = sloc.hasOffsetLength() ? sloc.getLength() : -1;
        int iOffset = sloc.hasOffsetLength() ? sloc.getOffset() : -1;
        int iBeginLine = sloc.hasLineColumn() ? sloc.getBeginLine() : -1;
        int iBeginColumn = sloc.hasLineColumn() ? sloc.getBeginColumn() : -1;
        int iEndLine = sloc.hasLineColumn() ? sloc.getEndLine() : -1;
        int iEndColumn = sloc.hasLineColumn() ? sloc.getEndColumn() : -1;
        boolean uriPartChanged = false;
        String scheme = sloc.getScheme();
        String authority = sloc.hasAuthority() ? sloc.getAuthority() : "";
        Object path = sloc.hasPath() ? sloc.getPath() : null;
        String query = sloc.hasQuery() ? sloc.getQuery() : null;
        String fragment = sloc.hasFragment() ? sloc.getFragment() : null;
        try {
            String newStringValue = null;
            if (replType.isString()) {
                newStringValue = ((IString)repl).getValue();
            }
            switch (field) {
                case "uri": {
                    URI uri = URIUtil.createFromEncoded(newStringValue);
                    scheme = uri.getScheme();
                    authority = uri.getAuthority();
                    path = uri.getPath();
                    query = uri.getQuery();
                    fragment = uri.getFragment();
                    uriPartChanged = true;
                    break;
                }
                case "scheme": {
                    scheme = newStringValue;
                    uriPartChanged = true;
                    break;
                }
                case "authority": {
                    authority = newStringValue;
                    uriPartChanged = true;
                    break;
                }
                case "host": {
                    if (!URIResolverRegistry.getInstance().supportsHost(sloc)) {
                        throw RuntimeExceptionFactory.noSuchField("The scheme " + sloc.getScheme() + " does not support the host field, use authority instead.");
                    }
                    URI uri = URIUtil.changeHost(sloc.getURI(), newStringValue);
                    authority = uri.getAuthority();
                    uriPartChanged = true;
                    break;
                }
                case "path": {
                    path = newStringValue;
                    uriPartChanged = true;
                    break;
                }
                case "file": {
                    boolean endsWithSlash = ((String)path).endsWith("/");
                    path = endsWithSlash ? ((String)path).substring(0, ((String)path).length() - "/".length()) : path;
                    int i = ((String)path).lastIndexOf("/");
                    path = i != -1 ? ((String)path).substring(0, i) + "/" + newStringValue : (String)path + "/" + newStringValue;
                    if (endsWithSlash) {
                        path = (String)path + "/";
                    }
                    uriPartChanged = true;
                    break;
                }
                case "parent": {
                    int i = ((String)path).lastIndexOf("/");
                    Object parent = newStringValue;
                    if (!((String)parent).startsWith("/")) {
                        parent = "/" + (String)parent;
                    }
                    path = i != -1 ? (String)parent + ((String)path).substring(i) : parent;
                    uriPartChanged = true;
                    break;
                }
                case "ls": {
                    throw RuntimeExceptionFactory.noSuchField("Cannot update the children of a location");
                }
                case "extension": {
                    String ext = newStringValue;
                    boolean endsWithSlash = ((String)path).endsWith("/");
                    if (endsWithSlash) {
                        path = ((String)path).substring(0, ((String)path).length() - 1);
                    }
                    if (((String)path).length() > 1) {
                        int slashIndex = ((String)path).lastIndexOf("/");
                        int index = ((String)path).substring(slashIndex).lastIndexOf(46);
                        if (index == -1 && !ext.isEmpty()) {
                            path = (String)path + (!ext.startsWith(".") ? "." : "") + ext;
                        } else if (!ext.isEmpty()) {
                            path = ((String)path).substring(0, slashIndex + index) + (!ext.startsWith(".") ? "." : "") + ext;
                        } else if (index != -1) {
                            path = ((String)path).substring(0, slashIndex + index);
                        }
                        if (endsWithSlash) {
                            path = (String)path + "/";
                        }
                    }
                    uriPartChanged = true;
                    break;
                }
                case "top": {
                    if (replType.isString()) {
                        URI uri = URIUtil.assumeCorrect(newStringValue);
                        scheme = uri.getScheme();
                        authority = uri.getAuthority();
                        path = uri.getPath();
                        query = uri.getQuery();
                        fragment = uri.getFragment();
                    } else if (replType.isSourceLocation()) {
                        ISourceLocation rep = (ISourceLocation)repl;
                        scheme = rep.getScheme();
                        authority = rep.hasAuthority() ? rep.getAuthority() : null;
                        path = rep.hasPath() ? rep.getPath() : null;
                        query = rep.hasQuery() ? rep.getQuery() : null;
                        fragment = rep.hasFragment() ? rep.getFragment() : null;
                    }
                    uriPartChanged = true;
                    break;
                }
                case "fragment": {
                    fragment = newStringValue;
                    uriPartChanged = true;
                    break;
                }
                case "query": {
                    query = newStringValue;
                    uriPartChanged = true;
                    break;
                }
                case "user": {
                    if (!URIResolverRegistry.getInstance().supportsHost(sloc)) {
                        throw RuntimeExceptionFactory.noSuchField("The scheme " + sloc.getScheme() + " does not support the user field, use authority instead.");
                    }
                    URI uri = sloc.getURI();
                    if (uri.getHost() != null) {
                        uri = URIUtil.changeUserInformation(uri, newStringValue);
                    }
                    authority = uri.getAuthority();
                    uriPartChanged = true;
                    break;
                }
                case "port": {
                    if (!URIResolverRegistry.getInstance().supportsHost(sloc)) {
                        throw RuntimeExceptionFactory.noSuchField("The scheme " + sloc.getScheme() + " does not support the port field, use authority instead.");
                    }
                    if (sloc.getURI().getHost() != null) {
                        int port = Integer.parseInt(((IInteger)repl).getStringRepresentation());
                        URI uRI = URIUtil.changePort(sloc.getURI(), port);
                    }
                    authority = sloc.getURI().getAuthority();
                    uriPartChanged = true;
                    break;
                }
                case "length": {
                    iLength = ((IInteger)repl).intValue();
                    if (iLength >= 0) break;
                    throw RuntimeExceptionFactory.illegalArgument(repl);
                }
                case "offset": {
                    iOffset = ((IInteger)repl).intValue();
                    if (iOffset >= 0) break;
                    throw RuntimeExceptionFactory.illegalArgument(repl);
                }
                case "begin": {
                    iBeginLine = ((IInteger)((ITuple)repl).get(0)).intValue();
                    iBeginColumn = ((IInteger)((ITuple)repl).get(1)).intValue();
                    if (iBeginColumn >= 0 && iBeginLine >= 0) break;
                    throw RuntimeExceptionFactory.illegalArgument(repl);
                }
                case "end": {
                    iEndLine = ((IInteger)((ITuple)repl).get(0)).intValue();
                    iEndColumn = ((IInteger)((ITuple)repl).get(1)).intValue();
                    if (iEndColumn >= 0 && iEndLine >= 0) break;
                    throw RuntimeExceptionFactory.illegalArgument(repl);
                }
                default: {
                    throw RuntimeExceptionFactory.noSuchField("Modification of field " + field + " in location not allowed");
                }
            }
            ISourceLocation newLoc = sloc;
            if (uriPartChanged) {
                newLoc = this.$VF.sourceLocation(scheme, authority, (String)path, query, fragment);
            }
            if (sloc.hasLineColumn()) {
                return this.$VF.sourceLocation(newLoc, iOffset, iLength, iBeginLine, iEndLine, iBeginColumn, iEndColumn);
            }
            if (sloc.hasOffsetLength()) {
                if (iBeginLine != -1 || iBeginColumn != -1) {
                    iEndLine = iBeginLine;
                    iEndColumn = iBeginColumn;
                    return this.$VF.sourceLocation(newLoc, iOffset, iLength, iBeginLine, iEndLine, iBeginColumn, iEndColumn);
                }
                if (iEndLine != -1 || iEndColumn != -1) {
                    iBeginLine = iEndLine;
                    iBeginColumn = iEndColumn;
                    return this.$VF.sourceLocation(newLoc, iOffset, iLength, iBeginLine, iEndLine, iBeginColumn, iEndColumn);
                }
                return this.$VF.sourceLocation(newLoc, iOffset, iLength);
            }
            if (iBeginColumn != -1 || iEndColumn != -1 || iBeginLine != -1 || iBeginColumn != -1) {
                throw RuntimeExceptionFactory.invalidUseOfLocation("Can not add line/column information without offset/length");
            }
            if (iOffset != -1 && iLength == -1) {
                iLength = 0;
            }
            if (iLength != -1 && iOffset == -1) {
                iOffset = 0;
            }
            if (iOffset != -1 || iLength != -1) {
                return this.$VF.sourceLocation(newLoc, iOffset, iLength);
            }
            return newLoc;
        }
        catch (IllegalArgumentException e) {
            throw RuntimeExceptionFactory.illegalArgument(sloc);
        }
        catch (URISyntaxException e) {
            throw RuntimeExceptionFactory.malformedURI(e.getMessage());
        }
    }

    public final IDateTime $adatetime_field_update(String field, IValue repl, IDateTime dt) {
        int year = dt.getYear();
        int month = dt.getMonthOfYear();
        int day = dt.getDayOfMonth();
        int hour = dt.getHourOfDay();
        int minute = dt.getMinuteOfHour();
        int second = dt.getSecondOfMinute();
        int milli = dt.getMillisecondsOfSecond();
        int tzOffsetHour = dt.getTimezoneOffsetHours();
        int tzOffsetMin = dt.getTimezoneOffsetMinutes();
        try {
            switch (field) {
                case "year": {
                    if (dt.isTime()) {
                        throw RuntimeExceptionFactory.invalidUseOfTimeException("Can not update the year on a time value");
                    }
                    year = ((IInteger)repl).intValue();
                    break;
                }
                case "month": {
                    if (dt.isTime()) {
                        throw RuntimeExceptionFactory.invalidUseOfTimeException("Can not update the month on a time value");
                    }
                    month = ((IInteger)repl).intValue();
                    break;
                }
                case "day": {
                    if (dt.isTime()) {
                        throw RuntimeExceptionFactory.invalidUseOfTimeException("Can not update the day on a time value");
                    }
                    day = ((IInteger)repl).intValue();
                    break;
                }
                case "hour": {
                    if (dt.isDate()) {
                        throw RuntimeExceptionFactory.invalidUseOfDateException("Can not update the hour on a date value");
                    }
                    hour = ((IInteger)repl).intValue();
                    break;
                }
                case "minute": {
                    if (dt.isDate()) {
                        throw RuntimeExceptionFactory.invalidUseOfDateException("Can not update the minute on a date value");
                    }
                    minute = ((IInteger)repl).intValue();
                    break;
                }
                case "second": {
                    if (dt.isDate()) {
                        throw RuntimeExceptionFactory.invalidUseOfDateException("Can not update the second on a date value");
                    }
                    second = ((IInteger)repl).intValue();
                    break;
                }
                case "millisecond": {
                    if (dt.isDate()) {
                        throw RuntimeExceptionFactory.invalidUseOfDateException("Can not update the millisecond on a date value");
                    }
                    milli = ((IInteger)repl).intValue();
                    break;
                }
                case "timezoneOffsetHours": {
                    if (dt.isDate()) {
                        throw RuntimeExceptionFactory.invalidUseOfDateException("Can not update the timezone offset hours on a date value");
                    }
                    tzOffsetHour = ((IInteger)repl).intValue();
                    break;
                }
                case "timezoneOffsetMinutes": {
                    if (dt.isDate()) {
                        throw RuntimeExceptionFactory.invalidUseOfDateException("Can not update the timezone offset minutes on a date value");
                    }
                    tzOffsetMin = ((IInteger)repl).intValue();
                    break;
                }
                default: {
                    throw RuntimeExceptionFactory.noSuchField(field);
                }
            }
            IDateTime newdt = null;
            newdt = dt.isDate() ? this.$VF.date(year, month, day) : (dt.isTime() ? this.$VF.time(hour, minute, second, milli, tzOffsetHour, tzOffsetMin) : this.$VF.datetime(year, month, day, hour, minute, second, milli, tzOffsetHour, tzOffsetMin));
            return newdt;
        }
        catch (IllegalArgumentException e) {
            throw RuntimeExceptionFactory.illegalArgument(repl, null, null);
        }
        catch (InvalidDateTimeException e) {
            throw RuntimeExceptionFactory.illegalArgument(dt, null, null);
        }
    }

    public final INode $anode_field_update(String fieldName, IValue repl, INode nd) {
        if (nd.getType().isAbstractData()) {
            return this.$aadt_field_update(fieldName, repl, (IConstructor)nd);
        }
        if (nd.mayHaveKeywordParameters() && nd.asWithKeywordParameters().getParameter(fieldName) != null) {
            return nd.asWithKeywordParameters().setParameter(fieldName, repl);
        }
        throw RuntimeExceptionFactory.illegalArgument(nd, null, null);
    }

    public final IConstructor $aadt_field_update(String fieldName, IValue repl, IConstructor cons) {
        Type consType = cons.getConstructorType();
        if (TreeAdapter.isTree(cons)) {
            if (TreeAdapter.isAppl((ITree)cons) && TreeAdapter.getLabeledField((ITree)cons, fieldName) != null) {
                return TreeAdapter.setArg((ITree)cons, fieldName, (IConstructor)repl);
            }
            return cons.asWithKeywordParameters().setParameter(fieldName, repl);
        }
        if (consType.hasField(fieldName)) {
            return cons.set(fieldName, repl);
        }
        return cons.asWithKeywordParameters().setParameter(fieldName, repl);
    }

    public final boolean $anode_has_field(INode nd, String fieldName) {
        if (nd.getType().isAbstractData() && this.$aadt_has_field((IConstructor)nd, fieldName, new Type[0])) {
            return true;
        }
        return nd.mayHaveKeywordParameters() && nd.asWithKeywordParameters().getParameter(fieldName) != null;
    }

    public final boolean $aadt_has_field(IConstructor cons, String fieldName, Type ... consesWithField) {
        if (TreeAdapter.isTree(cons) && TreeAdapter.isAppl((ITree)cons)) {
            TreeAdapter.FieldResult fldres = TreeAdapter.getLabeledField((ITree)cons, fieldName);
            if (fldres != null) {
                return true;
            }
            if (cons.asWithKeywordParameters().getParameter(fieldName) != null) {
                return true;
            }
        }
        Type consType = cons.getConstructorType();
        for (Type ct : consesWithField) {
            if (!consType.equals(ct)) continue;
            return true;
        }
        if (consType.hasField(fieldName)) {
            return true;
        }
        return cons.asWithKeywordParameters().getParameter(fieldName) != null;
    }

    public final boolean $nonterminal_has_name_and_arity(IValue v, String name, int arity) {
        if (v instanceof IConstructor && TreeAdapter.isTree((IConstructor)v)) {
            ITree tree = (ITree)v;
            IList args = TreeAdapter.getArgs(tree);
            int prod_arity = 0;
            for (IValue varg : args) {
                if (!TreeAdapter.isLexical((ITree)varg) && !TreeAdapter.isSort((ITree)varg) && !TreeAdapter.isList((ITree)varg)) continue;
                ++prod_arity;
            }
            if (prod_arity != arity) {
                return false;
            }
            IConstructor prod = TreeAdapter.getProduction(tree);
            IValue def = prod.get("def");
            if (def == null) {
                return false;
            }
            if (((IConstructor)def).has("name")) {
                return ((IString)((IConstructor)def).get("name")).getValue().equals(name);
            }
        }
        return false;
    }

    public final boolean $has_type_and_arity(IValue v, Type type, int arity) {
        HashMap<Type, Type> m4;
        Type consType;
        if (v instanceof IConstructor && (consType = ((IConstructor)v).getConstructorType()).match(type, m4 = new HashMap<Type, Type>())) {
            if (TreeAdapter.isTree((IConstructor)v)) {
                ITree tree = (ITree)v;
                if (TreeAdapter.isChar(tree)) {
                    return arity == 1;
                }
                if (TreeAdapter.isAmb(tree)) {
                    return arity == 1;
                }
                IList args = TreeAdapter.getArgs(tree);
                if (args == null && arity != 0) {
                    return false;
                }
                if (TreeAdapter.isLiteral(tree)) {
                    IConstructor p = TreeAdapter.getProduction(tree);
                    IList symbols = ProductionAdapter.getSymbols(p);
                    return args.size() == symbols.size();
                }
                if (!TreeAdapter.isAppl(tree)) {
                    return false;
                }
                return arity == 2;
            }
            return true;
        }
        return false;
    }

    public final IValue $nonterminal_get_arg(ITree tree, int idx) {
        IList args = TreeAdapter.getArgs(tree);
        int i = 0;
        for (IValue varg : args) {
            if (TreeAdapter.isLayout((ITree)varg) || !TreeAdapter.isLexical((ITree)varg) && !TreeAdapter.isSort((ITree)varg) && !TreeAdapter.isList((ITree)varg)) continue;
            if (i == idx) {
                return varg;
            }
            ++i;
        }
        throw new InternalCompilerError("nonterminal does not have argument #" + idx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean $is(IValue val, IString sname) {
        Type tp = val.getType();
        String name = sname.getValue();
        if (tp.isAbstractData()) {
            if (tp.getName().equals("Tree")) {
                IConstructor prod;
                IConstructor def;
                IConstructor cons = (IConstructor)val;
                if (!cons.getName().equals("appl") || !(def = (IConstructor)(prod = (IConstructor)cons.get(0)).get(0)).getName().equals("label")) return false;
                return ((IString)def.get(0)).getValue().equals(name);
            }
            String consName = ((IConstructor)val).getConstructorType().getName();
            if (!consName.startsWith("\\")) return consName.equals(name);
            consName = consName.substring(1);
            return consName.equals(name);
        }
        if (!tp.isNode()) return false;
        String nodeName = ((INode)val).getName();
        if (!nodeName.startsWith("\\")) return nodeName.equals(name);
        nodeName = nodeName.substring(1);
        return nodeName.equals(name);
    }

    public final boolean $is_defined_value(GuardedIValue val) {
        return val.defined;
    }

    public final IValue $get_defined_value(GuardedIValue val) {
        return val.value;
    }

    public final IList $alist_join_alrel(IList left, IList right) {
        if (left.length() == 0) {
            return left;
        }
        if (right.length() == 0) {
            return right;
        }
        Type rightType = right.get(0).getType();
        assert (rightType.isTuple());
        int rarity = rightType.getArity();
        IValue[] fieldValues = new IValue[1 + rarity];
        IListWriter w = this.$VF.listWriter();
        Iterator iterator = left.iterator();
        while (iterator.hasNext()) {
            IValue lval;
            fieldValues[0] = lval = (IValue)iterator.next();
            for (IValue rtuple : right) {
                for (int i = 0; i < rarity; ++i) {
                    fieldValues[i + 1] = ((ITuple)rtuple).get(i);
                }
                w.append(this.$VF.tuple(fieldValues));
            }
        }
        return (IList)w.done();
    }

    public final IList $alrel_join_alrel(IList left, IList right) {
        if (left.length() == 0) {
            return left;
        }
        if (right.length() == 0) {
            return right;
        }
        Type leftType = left.get(0).getType();
        Type rightType = right.get(0).getType();
        assert (leftType.isTuple());
        assert (rightType.isTuple());
        int larity = leftType.getArity();
        int rarity = rightType.getArity();
        IValue[] fieldValues = new IValue[larity + rarity];
        IListWriter w = this.$VF.listWriter();
        for (IValue ltuple : left) {
            for (IValue rtuple : right) {
                int i;
                for (i = 0; i < larity; ++i) {
                    fieldValues[i] = ((ITuple)ltuple).get(i);
                }
                for (i = larity; i < larity + rarity; ++i) {
                    fieldValues[i] = ((ITuple)rtuple).get(i - larity);
                }
                w.append(this.$VF.tuple(fieldValues));
            }
        }
        return (IList)w.done();
    }

    public final IList $alrel_join_alist(IList left, IList right) {
        if (left.length() == 0) {
            return left;
        }
        if (right.length() == 0) {
            return right;
        }
        Type leftType = left.get(0).getType();
        assert (leftType.isTuple());
        int larity = leftType.getArity();
        IValue[] fieldValues = new IValue[larity + 1];
        IListWriter w = this.$VF.listWriter();
        for (IValue ltuple : left) {
            for (IValue rval : right) {
                for (int i = 0; i < larity; ++i) {
                    fieldValues[i] = ((ITuple)ltuple).get(i);
                }
                fieldValues[larity] = rval;
                w.append(this.$VF.tuple(fieldValues));
            }
        }
        return (IList)w.done();
    }

    public final ISet $aset_join_arel(ISet left, ISet right) {
        if (left.size() == 0) {
            return left;
        }
        if (right.size() == 0) {
            return right;
        }
        Type rightType = right.getElementType();
        assert (rightType.isTuple());
        int rarity = rightType.getArity();
        IValue[] fieldValues = new IValue[1 + rarity];
        ISetWriter w = this.$VF.setWriter();
        for (IValue lval : left) {
            for (IValue rtuple : right) {
                fieldValues[0] = lval;
                for (int i = 0; i < rarity; ++i) {
                    fieldValues[i + 1] = ((ITuple)rtuple).get(i);
                }
                w.insert(this.$VF.tuple(fieldValues));
            }
        }
        return (ISet)w.done();
    }

    public final ISet $arel_join_arel(ISet left, ISet right) {
        if (left.size() == 0) {
            return left;
        }
        if (right.size() == 0) {
            return right;
        }
        Type leftType = left.getElementType();
        Type rightType = right.getElementType();
        assert (leftType.isTuple());
        assert (rightType.isTuple());
        int larity = leftType.getArity();
        int rarity = rightType.getArity();
        IValue[] fieldValues = new IValue[larity + rarity];
        ISetWriter w = this.$VF.setWriter();
        for (IValue ltuple : left) {
            for (IValue rtuple : right) {
                int i;
                for (i = 0; i < larity; ++i) {
                    fieldValues[i] = ((ITuple)ltuple).get(i);
                }
                for (i = larity; i < larity + rarity; ++i) {
                    fieldValues[i] = ((ITuple)rtuple).get(i - larity);
                }
                w.insert(this.$VF.tuple(fieldValues));
            }
        }
        return (ISet)w.done();
    }

    public final ISet $arel_join_aset(ISet left, ISet right) {
        if (left.size() == 0) {
            return left;
        }
        if (right.size() == 0) {
            return right;
        }
        Type leftType = left.getElementType();
        assert (leftType.isTuple());
        int larity = leftType.getArity();
        IValue[] fieldValues = new IValue[larity + 1];
        ISetWriter w = this.$VF.setWriter();
        for (IValue ltuple : left) {
            for (IValue rval : right) {
                for (int i = 0; i < larity; ++i) {
                    fieldValues[i] = ((ITuple)ltuple).get(i);
                }
                fieldValues[larity] = rval;
                w.insert(this.$VF.tuple(fieldValues));
            }
        }
        return (ISet)w.done();
    }

    public final IBool $less(final IValue left, final IValue right) {
        final Type leftType = left.getType();
        final Type rightType = right.getType();
        if (leftType.isSubtypeOf(this.$TF.numberType()) && rightType.isSubtypeOf(this.$TF.numberType())) {
            return ((INumber)left).less((INumber)right);
        }
        if (!leftType.comparable(rightType)) {
            return this.Rascal_FALSE;
        }
        return leftType.accept(new DefaultRascalTypeVisitor<IBool, RuntimeException>(this.Rascal_FALSE){

            @Override
            public IBool visitList(Type type) throws RuntimeException {
                if (rightType.isList()) {
                    return $RascalModule.this.$alist_less_alist((IList)left, (IList)right);
                }
                throw new InternalCompilerError("less: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            @Override
            public IBool visitMap(Type type) throws RuntimeException {
                if (rightType.isMap()) {
                    return $RascalModule.this.$amap_less_amap((IMap)left, (IMap)right);
                }
                throw new InternalCompilerError("less: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            @Override
            public IBool visitSet(Type type) throws RuntimeException {
                if (rightType.isSet()) {
                    return $RascalModule.this.$aset_less_aset((ISet)left, (ISet)right);
                }
                throw new InternalCompilerError("less: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            @Override
            public IBool visitSourceLocation(Type type) throws RuntimeException {
                if (rightType.isSourceLocation()) {
                    return $RascalModule.this.$aloc_less_aloc((ISourceLocation)left, (ISourceLocation)right);
                }
                throw new InternalCompilerError("less: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            @Override
            public IBool visitString(Type type) throws RuntimeException {
                if (rightType.isString()) {
                    return $RascalModule.this.$astr_less_astr((IString)left, (IString)right);
                }
                throw new InternalCompilerError("less: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            @Override
            public IBool visitNode(Type type) throws RuntimeException {
                if (rightType.isNode()) {
                    return $RascalModule.this.$anode_less_anode((INode)left, (INode)right);
                }
                throw new InternalCompilerError("less: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            @Override
            public IBool visitConstructor(Type type) throws RuntimeException {
                return this.visitNode(type);
            }

            @Override
            public IBool visitAbstractData(Type type) throws RuntimeException {
                return this.visitNode(type);
            }

            @Override
            public IBool visitTuple(Type type) throws RuntimeException {
                if (rightType.isTuple()) {
                    return $RascalModule.this.$atuple_less_atuple((ITuple)left, (ITuple)right);
                }
                throw new InternalCompilerError("less: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            @Override
            public IBool visitBool(Type type) throws RuntimeException {
                if (rightType.isBool()) {
                    return $RascalModule.this.$abool_less_abool((IBool)left, (IBool)right);
                }
                throw new InternalCompilerError("less: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            @Override
            public IBool visitDateTime(Type type) throws RuntimeException {
                if (rightType.isDateTime()) {
                    return $RascalModule.this.$adatetime_less_adatetime((IDateTime)left, (IDateTime)right);
                }
                throw new InternalCompilerError("less: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }
        });
    }

    public final IBool $aint_less_aint(IInteger a, IInteger b) {
        return a.less(b);
    }

    public final IBool $aint_less_areal(IInteger a, IReal b) {
        return a.less(b);
    }

    public final IBool $aint_less_arat(IInteger a, IRational b) {
        return a.toRational().less(b);
    }

    public final IBool $aint_less_anum(IInteger a, INumber b) {
        return a.less(b);
    }

    public final IBool $areal_less_aint(IReal a, IInteger b) {
        return a.less(b);
    }

    public final IBool $areal_less_areal(IReal a, IReal b) {
        return a.less(b);
    }

    public final IBool $areal_less_arat(IReal a, IRational b) {
        return a.less(b);
    }

    public final IBool $areal_less_anum(IReal a, INumber b) {
        return a.less(b);
    }

    public final IBool $arat_less_aint(IRational a, IInteger b) {
        return a.less(b);
    }

    public final IBool $arat_less_areal(IRational a, IReal b) {
        return a.less(b);
    }

    public final IBool $arat_less_arat(IRational a, IRational b) {
        return a.toRational().less(b);
    }

    public final IBool $arat_less_anum(IRational a, INumber b) {
        return a.less(b);
    }

    public final IBool $anum_less_aint(INumber a, IInteger b) {
        return a.less(b);
    }

    public final IBool $anum_less_areal(INumber a, IReal b) {
        return a.less(b);
    }

    public final IBool $anum_less_arat(INumber a, IRational b) {
        return a.less(b);
    }

    public final IBool $anum_less_anum(INumber a, INumber b) {
        return a.less(b);
    }

    public final IBool $abool_less_abool(IBool left, IBool right) {
        return this.$VF.bool(!left.getValue() && right.getValue());
    }

    public final IBool $astr_less_astr(IString left, IString right) {
        return this.$VF.bool(left.compare(right) == -1);
    }

    public final IBool $adatetime_less_adatetime(IDateTime left, IDateTime right) {
        return this.$VF.bool(left.compareTo(right) == -1);
    }

    public final IBool $aloc_less_aloc(ISourceLocation left, ISourceLocation right) {
        int compare = SourceLocationURICompare.compare(left, right);
        if (compare < 0) {
            return this.Rascal_TRUE;
        }
        if (compare > 0) {
            return this.Rascal_FALSE;
        }
        if (left.hasOffsetLength()) {
            if (!right.hasOffsetLength()) {
                return this.Rascal_FALSE;
            }
            int roffset = right.getOffset();
            int rlen = right.getLength();
            int loffset = left.getOffset();
            int llen = left.getLength();
            if (loffset == roffset) {
                return this.$VF.bool(llen < rlen);
            }
            return this.$VF.bool(roffset < loffset && roffset + rlen >= loffset + llen);
        }
        if (compare == 0) {
            return this.Rascal_FALSE;
        }
        if (!right.hasOffsetLength()) {
            throw new InternalCompilerError("offset length missing");
        }
        return this.Rascal_FALSE;
    }

    public final IBool $atuple_less_atuple(ITuple left, ITuple right) {
        int leftArity = left.arity();
        int rightArity = right.arity();
        for (int i = 0; i < Math.min(leftArity, rightArity); ++i) {
            IBool result = leftArity < rightArity || i < leftArity - 1 ? this.$equal(left.get(i), right.get(i)) : this.$less(left.get(i), right.get(i));
            if (result.getValue()) continue;
            return this.Rascal_FALSE;
        }
        return this.$VF.bool(leftArity <= rightArity);
    }

    public final IBool $anode_less_anode(INode left, INode right) {
        int compare = left.getName().compareTo(right.getName());
        if (compare <= -1) {
            return this.Rascal_TRUE;
        }
        if (compare >= 1) {
            return this.Rascal_FALSE;
        }
        int leftArity = left.arity();
        int rightArity = right.arity();
        IBool result = this.Rascal_FALSE;
        for (int i = 0; i < Math.min(leftArity, rightArity); ++i) {
            result = leftArity < rightArity || i < leftArity - 1 ? this.$lessequal(left.get(i), right.get(i)) : this.$less(left.get(i), right.get(i));
            if (result.getValue()) continue;
            return this.Rascal_FALSE;
        }
        if (left.mayHaveKeywordParameters() || !right.mayHaveKeywordParameters()) {
            // empty if block
        }
        if (!left.asWithKeywordParameters().hasParameters() && right.asWithKeywordParameters().hasParameters()) {
            return this.Rascal_TRUE;
        }
        if (left.asWithKeywordParameters().hasParameters() && !right.asWithKeywordParameters().hasParameters()) {
            return this.Rascal_FALSE;
        }
        if (left.asWithKeywordParameters().hasParameters() && right.asWithKeywordParameters().hasParameters()) {
            Map<String, IValue> paramsLeft = left.asWithKeywordParameters().getParameters();
            Map<String, IValue> paramsRight = right.asWithKeywordParameters().getParameters();
            if (paramsLeft.size() < paramsRight.size()) {
                return this.Rascal_TRUE;
            }
            if (paramsLeft.size() > paramsRight.size()) {
                return this.Rascal_FALSE;
            }
            if (paramsRight.keySet().containsAll(paramsLeft.keySet()) && !paramsRight.keySet().equals(paramsLeft.keySet())) {
                return this.Rascal_TRUE;
            }
            if (paramsLeft.keySet().containsAll(paramsLeft.keySet()) && !paramsRight.keySet().equals(paramsLeft.keySet())) {
                return this.Rascal_FALSE;
            }
            for (String k : paramsLeft.keySet()) {
                result = this.$less(paramsLeft.get(k), paramsRight.get(k));
                if (result.getValue()) continue;
                return this.Rascal_FALSE;
            }
        }
        return this.$VF.bool(leftArity < rightArity || result.getValue());
    }

    public final IBool $alist_less_alist(IList left, IList right) {
        if (left.length() > right.length()) {
            return this.Rascal_FALSE;
        }
        int r = 0;
        block0: for (int l = 0; l < left.length(); ++l) {
            for (r = Math.max(l, r); r < right.length(); ++r) {
                if (!left.get(l).equals(right.get(r))) continue;
                ++r;
                continue block0;
            }
            return this.Rascal_FALSE;
        }
        return this.$VF.bool(left.length() != right.length());
    }

    public final IBool $aset_less_aset(ISet left, ISet right) {
        return this.$VF.bool(!left.equals(right) && left.isSubsetOf(right));
    }

    public final IBool $amap_less_amap(IMap left, IMap right) {
        return this.$VF.bool(left.isSubMap(right) && !right.isSubMap(left));
    }

    public final IBool $lessequal(final IValue left, final IValue right) {
        final Type leftType = left.getType();
        final Type rightType = right.getType();
        if (leftType.isSubtypeOf(this.$TF.numberType()) && rightType.isSubtypeOf(this.$TF.numberType())) {
            return ((INumber)left).lessEqual((INumber)right);
        }
        if (!leftType.comparable(rightType)) {
            return this.Rascal_FALSE;
        }
        return leftType.accept(new DefaultRascalTypeVisitor<IBool, RuntimeException>(this.Rascal_FALSE){

            @Override
            public IBool visitList(Type type) throws RuntimeException {
                if (rightType.isList()) {
                    return $RascalModule.this.$alist_lessequal_alist((IList)left, (IList)right);
                }
                throw new InternalCompilerError("lessequal: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            @Override
            public IBool visitMap(Type type) throws RuntimeException {
                if (rightType.isMap()) {
                    return $RascalModule.this.$amap_lessequal_amap((IMap)left, (IMap)right);
                }
                throw new InternalCompilerError("lessequal: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            @Override
            public IBool visitSet(Type type) throws RuntimeException {
                if (rightType.isSet()) {
                    return $RascalModule.this.$aset_lessequal_aset((ISet)left, (ISet)right);
                }
                throw new InternalCompilerError("lessequal: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            @Override
            public IBool visitSourceLocation(Type type) throws RuntimeException {
                if (rightType.isSourceLocation()) {
                    return $RascalModule.this.$aloc_lessequal_aloc((ISourceLocation)left, (ISourceLocation)right);
                }
                throw new InternalCompilerError("lessequal: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            @Override
            public IBool visitString(Type type) throws RuntimeException {
                if (rightType.isString()) {
                    return $RascalModule.this.$astr_lessequal_astr((IString)left, (IString)right);
                }
                throw new InternalCompilerError("lessequal: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            @Override
            public IBool visitNode(Type type) throws RuntimeException {
                if (rightType.isNode()) {
                    return $RascalModule.this.$anode_lessequal_anode((INode)left, (INode)right);
                }
                throw new InternalCompilerError("lessequal: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            @Override
            public IBool visitConstructor(Type type) throws RuntimeException {
                return this.visitNode(type);
            }

            @Override
            public IBool visitAbstractData(Type type) throws RuntimeException {
                return this.visitNode(type);
            }

            @Override
            public IBool visitTuple(Type type) throws RuntimeException {
                if (rightType.isTuple()) {
                    return $RascalModule.this.$atuple_lessequal_atuple((ITuple)left, (ITuple)right);
                }
                throw new InternalCompilerError("lessequal: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            @Override
            public IBool visitBool(Type type) throws RuntimeException {
                if (rightType.isBool()) {
                    return $RascalModule.this.$abool_lessequal_abool((IBool)left, (IBool)right);
                }
                throw new InternalCompilerError("lessequal: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            @Override
            public IBool visitDateTime(Type type) throws RuntimeException {
                if (rightType.isDateTime()) {
                    return $RascalModule.this.$adatetime_lessequal_adatetime((IDateTime)left, (IDateTime)right);
                }
                throw new InternalCompilerError("lessequal: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }
        });
    }

    public final IBool $aint_lessequal_aint(IInteger a, IInteger b) {
        return a.lessEqual(b);
    }

    public final IBool $aint_lessequal_areal(IInteger a, IReal b) {
        return a.lessEqual(b);
    }

    public final IBool $aint_lessequal_arat(IInteger a, IRational b) {
        return a.lessEqual(b);
    }

    public final IBool $aint_lessequal_anum(IInteger a, INumber b) {
        return a.lessEqual(b);
    }

    public final IBool $areal_lessequal_aint(IReal a, IInteger b) {
        return a.lessEqual(b);
    }

    public final IBool $areal_lessequal_areal(IReal a, IReal b) {
        return a.lessEqual(b);
    }

    public final IBool $areal_lessequal_arat(IReal a, IRational b) {
        return a.lessEqual(b);
    }

    public final IBool $areal_lessequal_anum(IReal a, INumber b) {
        return a.lessEqual(b);
    }

    public final IBool $arat_lessequal_aint(IRational a, IInteger b) {
        return a.lessEqual(b);
    }

    public final IBool $arat_lessequal_areal(IRational a, IReal b) {
        return a.lessEqual(b);
    }

    public final IBool $arat_lessequal_arat(IRational a, IRational b) {
        return a.lessEqual(b);
    }

    public final IBool $arat_lessequal_anum(IRational a, INumber b) {
        return a.lessEqual(b);
    }

    public final IBool $anum_lessequal_aint(INumber a, IInteger b) {
        return a.lessEqual(b);
    }

    public final IBool $anum_lessequal_areal(INumber a, IReal b) {
        return a.lessEqual(b);
    }

    public final IBool $anum_lessequal_arat(INumber a, IRational b) {
        return a.lessEqual(b);
    }

    public final IBool $anum_lessequal_anum(INumber a, INumber b) {
        return a.lessEqual(b);
    }

    public final IBool $abool_lessequal_abool(IBool left, IBool right) {
        boolean l = left.getValue();
        boolean r = right.getValue();
        return this.$VF.bool(!l && r || l == r);
    }

    public final IBool $astr_lessequal_astr(IString left, IString right) {
        int c = left.compare(right);
        return this.$VF.bool(c == -1 || c == 0);
    }

    public final IBool $adatetime_lessequal_adatetime(IDateTime left, IDateTime right) {
        int c = left.compareTo(right);
        return this.$VF.bool(c == -1 || c == 0);
    }

    public final IBool $aloc_lessequal_aloc(ISourceLocation left, ISourceLocation right) {
        int compare = SourceLocationURICompare.compare(left, right);
        if (compare < 0) {
            return this.Rascal_TRUE;
        }
        if (compare > 0) {
            return this.Rascal_FALSE;
        }
        if (left.hasOffsetLength()) {
            if (!right.hasOffsetLength()) {
                return this.Rascal_FALSE;
            }
            int roffset = right.getOffset();
            int rlen = right.getLength();
            int loffset = left.getOffset();
            int llen = left.getLength();
            if (loffset == roffset) {
                return this.$VF.bool(llen <= rlen);
            }
            return this.$VF.bool(roffset < loffset && roffset + rlen >= loffset + llen);
        }
        if (compare == 0) {
            return this.Rascal_TRUE;
        }
        if (!right.hasOffsetLength()) {
            throw new InternalCompilerError("missing offset length");
        }
        return this.Rascal_FALSE;
    }

    public final IBool $anode_lessequal_anode(INode left, INode right) {
        int compare = left.getName().compareTo(right.getName());
        if (compare <= -1) {
            return this.Rascal_TRUE;
        }
        if (compare >= 1) {
            return this.Rascal_FALSE;
        }
        int leftArity = left.arity();
        int rightArity = right.arity();
        for (int i = 0; i < Math.min(leftArity, rightArity); ++i) {
            if (this.$lessequal(left.get(i), right.get(i)).getValue()) continue;
            return this.Rascal_FALSE;
        }
        return this.$VF.bool(leftArity <= rightArity);
    }

    public final IBool $atuple_lessequal_atuple(ITuple left, ITuple right) {
        int leftArity = left.arity();
        int rightArity = right.arity();
        for (int i = 0; i < Math.min(leftArity, rightArity); ++i) {
            if (this.$lessequal(left.get(i), right.get(i)).getValue()) continue;
            return this.Rascal_FALSE;
        }
        return this.$VF.bool(leftArity <= rightArity);
    }

    public final IBool $alist_lessequal_alist(IList left, IList right) {
        if (left.length() == 0) {
            return this.Rascal_TRUE;
        }
        if (left.length() > right.length()) {
            return this.Rascal_FALSE;
        }
        int r = 0;
        block0: for (int l = 0; l < left.length(); ++l) {
            for (r = Math.max(l, r); r < right.length(); ++r) {
                if (left.get(l).equals(right.get(r))) continue block0;
            }
            return this.Rascal_FALSE;
        }
        return this.$VF.bool(left.length() <= right.length());
    }

    public final IBool $aset_lessequal_aset(ISet left, ISet right) {
        return this.$VF.bool(left.size() == 0 || left.equals(right) || left.isSubsetOf(right));
    }

    public final IBool $amap_lessequal_amap(IMap left, IMap right) {
        return this.$VF.bool(left.isSubMap(right));
    }

    public final IValue $parse(IValue reified, IString inputText, ISourceLocation inputLocation) {
        IFunction parser = this.$RVF.parser(reified, this.$VF.bool(true), this.$VF.bool(false), this.$VF.bool(false), this.$VF.bool(false), this.$VF.set(new IValue[0]));
        return parser.call(inputText, inputLocation);
    }

    public final IInteger $aint_product_aint(IInteger a, IInteger b) {
        return a.multiply(b);
    }

    public final IReal $aint_product_areal(IInteger a, IReal b) {
        return a.multiply(b);
    }

    public final IRational $aint_product_arat(IInteger a, IRational b) {
        return a.toRational().multiply(b);
    }

    public final INumber $aint_product_anum(IInteger a, INumber b) {
        return a.multiply(b);
    }

    public final IReal $areal_product_aint(IReal a, IInteger b) {
        return (IReal)a.multiply(b);
    }

    public final IReal $areal_product_areal(IReal a, IReal b) {
        return a.multiply(b);
    }

    public final IReal $areal_product_arat(IReal a, IRational b) {
        return (IReal)a.multiply(b);
    }

    public final INumber $areal_product_anum(IReal a, INumber b) {
        return a.multiply(b);
    }

    public final INumber $arat_product_aint(IRational a, IInteger b) {
        return a.multiply(b);
    }

    public final IReal $arat_product_areal(IRational a, IReal b) {
        return a.multiply(b);
    }

    public final IRational $arat_product_arat(IRational a, IRational b) {
        return a.toRational().multiply(b);
    }

    public final INumber $arat_product_anum(IRational a, INumber b) {
        return a.multiply(b);
    }

    public final INumber $anum_product_aint(INumber a, IInteger b) {
        return a.multiply(b);
    }

    public final INumber $anum_product_areal(INumber a, IReal b) {
        return a.multiply(b);
    }

    public final INumber $anum_product_arat(INumber a, IRational b) {
        return a.multiply(b);
    }

    public final INumber $anum_product_anum(INumber a, INumber b) {
        return a.multiply(b);
    }

    public final IList $alist_product_alist(IList left, IList right) {
        IListWriter w = this.$VF.listWriter();
        for (IValue l : left) {
            for (IValue r : right) {
                w.append(this.$VF.tuple(l, r));
            }
        }
        return (IList)w.done();
    }

    public final ISet $aset_product_aset(ISet left, ISet right) {
        ISetWriter w = this.$VF.setWriter();
        for (IValue l : left) {
            for (IValue r : right) {
                w.insert(this.$VF.tuple(l, r));
            }
        }
        return (ISet)w.done();
    }

    public final Matcher $regExpCompile(String pat, String subject) {
        try {
            Pattern p = Pattern.compile(pat, 256);
            return p.matcher(subject);
        }
        catch (PatternSyntaxException e) {
            throw RuntimeExceptionFactory.regExpSyntaxError(e.getMessage());
        }
    }

    public final IString $str_escape_for_regexp(IString insert) {
        StringBuilder sw = new StringBuilder();
        PrimitiveIterator.OfInt ofInt = insert.iterator();
        block6: while (ofInt.hasNext()) {
            int i = (Integer)ofInt.next();
            char c = (char)i;
            switch (c) {
                case '.': {
                    sw.append("\\.");
                    continue block6;
                }
                case '(': {
                    sw.append("\\(");
                    continue block6;
                }
                case ')': {
                    sw.append("\\)");
                    continue block6;
                }
                case '*': {
                    sw.append("\\*");
                    continue block6;
                }
            }
            sw.append(c);
        }
        return this.$VF.string(sw.toString());
    }

    public final IString $str_escape_for_regexp(String insert) {
        return this.$str_escape_for_regexp(this.$VF.string(insert));
    }

    public final IString $astr_slice(IString str, Integer first, Integer second, Integer end) {
        StringBuilder buffer;
        block4: {
            SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, str.length());
            buffer = new StringBuilder();
            int increment = sd.second - sd.first;
            if (sd.first == sd.end || increment == 0) break block4;
            if (sd.first <= sd.end) {
                for (int i = sd.first; i >= 0 && i < sd.end; i += increment) {
                    buffer.appendCodePoint(str.charAt(i));
                }
            } else {
                for (int j = sd.first; j >= 0 && j > sd.end && j < str.length(); j += increment) {
                    buffer.appendCodePoint(str.charAt(j));
                }
            }
        }
        return this.$VF.string(buffer.toString());
    }

    public final IList $anode_slice(INode node, Integer first, Integer second, Integer end) {
        IListWriter w;
        block4: {
            SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, node.arity());
            w = this.$VF.listWriter();
            int increment = sd.second - sd.first;
            if (sd.first == sd.end || increment == 0) break block4;
            if (sd.first <= sd.end) {
                for (int i = sd.first; i >= 0 && i < sd.end; i += increment) {
                    w.append(node.get(i));
                }
            } else {
                for (int j = sd.first; j >= 0 && j > sd.end && j < node.arity(); j += increment) {
                    w.append(node.get(j));
                }
            }
        }
        return (IList)w.done();
    }

    public final IList $alist_slice(IList lst, Integer first, Integer second, Integer end) {
        IListWriter w;
        block4: {
            SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, lst.length());
            w = this.$VF.listWriter();
            int increment = sd.second - sd.first;
            if (sd.first == sd.end || increment == 0) break block4;
            if (sd.first <= sd.end) {
                for (int i = sd.first; i >= 0 && i < sd.end; i += increment) {
                    w.append(lst.get(i));
                }
            } else {
                for (int j = sd.first; j >= 0 && j > sd.end && j < lst.length(); j += increment) {
                    w.append(lst.get(j));
                }
            }
        }
        return (IList)w.done();
    }

    public final ITree $lexical_slice(ITree tree, Integer first, Integer second, Integer end) {
        return this.$syntactic_slice(tree, first, second, end, 1);
    }

    public final ITree $concrete_slice(ITree tree, Integer first, Integer second, Integer end) {
        return this.$syntactic_slice(tree, first, second, end, 2);
    }

    public final ITree $lexical_slice_seps(ITree tree, Integer first, Integer second, Integer end) {
        IConstructor nt = ProductionAdapter.getType(TreeAdapter.getProduction(tree));
        int delta = SymbolAdapter.getSeparators(nt).size() + 1;
        return this.$syntactic_slice(tree, first, second, end, delta);
    }

    public final ITree $concrete_slice_seps(ITree tree, Integer first, Integer second, Integer end) {
        IConstructor nt = ProductionAdapter.getType(TreeAdapter.getProduction(tree));
        int delta = SymbolAdapter.getSeparators(nt).size() + 1;
        return this.$syntactic_slice(tree, first, second, end, delta);
    }

    private final ITree $syntactic_slice(ITree tree, Integer first, Integer second, Integer end, int delta) {
        boolean isPlusIter;
        IList args = tree.getArgs();
        int nargs = args.size();
        SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, nargs);
        int sd_first = sd.first * delta;
        int sd_second = sd.second * delta;
        int sd_end = Math.min(sd.end * delta, nargs);
        IListWriter w = this.$VF.listWriter();
        int increment = sd_second - sd_first;
        if (sd_first != sd_end && increment != 0) {
            int j;
            int i;
            if (sd_first <= sd_end) {
                for (i = sd_first; i >= 0 && i < sd_end; i += increment) {
                    w.append(args.get(i));
                    if (i >= sd_end - increment) continue;
                    for (j = i + 1; j < i + delta; ++j) {
                        w.append(args.get(j));
                    }
                }
            } else {
                for (i = sd_first; i >= 0 && i > sd_end && i < nargs; i += increment) {
                    w.append(args.get(i));
                    if (i <= 0) continue;
                    for (j = i - 1; j > i - delta; --j) {
                        w.append(args.get(j));
                    }
                }
            }
        }
        IList newArgs = (IList)w.done();
        String opname = ((IConstructor)TreeAdapter.getProduction(tree).get(0)).getName();
        boolean bl = isPlusIter = opname == "iter" || opname == "iter-seps";
        if (isPlusIter && newArgs.size() == 0) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)newArgs, "Slice should not create empty list of elements for lexical or nonterminal with one or more repetitions");
        }
        return TreeAdapter.setArgs(tree, newArgs);
    }

    public final IList $makeSlice(INode node, Integer first, Integer second, Integer end) {
        IListWriter w;
        block4: {
            SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, node.arity());
            w = this.$VF.listWriter();
            int increment = sd.second - sd.first;
            if (sd.first == sd.end || increment == 0) break block4;
            if (sd.first <= sd.end) {
                for (int i = sd.first; i >= 0 && i < sd.end; i += increment) {
                    w.append(node.get(i));
                }
            } else {
                for (int j = sd.first; j >= 0 && j > sd.end && j < node.arity(); j += increment) {
                    w.append(node.get(j));
                }
            }
        }
        return (IList)w.done();
    }

    private SliceDescriptor makeSliceDescriptor(Integer first, Integer second, Integer end, int len) {
        int firstIndex = 0;
        int secondIndex = 1;
        int endIndex = len;
        if (first != null && (firstIndex = first.intValue()) < 0) {
            firstIndex += len;
        }
        if (end != null && (endIndex = end.intValue()) < 0) {
            endIndex += len;
        }
        if (second == null) {
            secondIndex = firstIndex + (firstIndex <= endIndex ? 1 : -1);
        } else {
            secondIndex = second;
            if (secondIndex < 0) {
                secondIndex += len;
            }
            if (first != null || end != null) {
                if (first == null && secondIndex > endIndex) {
                    firstIndex = len - 1;
                }
                if (end == null && secondIndex < firstIndex) {
                    endIndex = -1;
                }
            }
        }
        if (len == 0 || firstIndex >= len) {
            endIndex = 0;
            secondIndex = 0;
            firstIndex = 0;
        } else if (endIndex > len) {
            endIndex = len;
        }
        return new SliceDescriptor(firstIndex, secondIndex, endIndex);
    }

    public final IString $astr_slice_replace(IString str, Integer first, Integer second, Integer end, IString repl) {
        SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, str.length());
        return str.replace(sd.first, sd.second, sd.end, repl);
    }

    public final INode $anode_slice_replace(INode node, Integer first, Integer second, Integer end, IList repl) {
        SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, node.arity());
        return node.replace(sd.first, sd.second, sd.end, repl);
    }

    public final IList $alist_slice_replace(IList lst, Integer first, Integer second, Integer end, IList repl) {
        SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, lst.length());
        return this.$updateListSlice(lst, sd, SliceOperator.replace, repl);
    }

    public final IList $alist_slice_add(IList lst, Integer first, Integer second, Integer end, IList repl) {
        SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, lst.length());
        return this.$updateListSlice(lst, sd, SliceOperator.add, repl);
    }

    public final IList $alist_slice_subtract(IList lst, Integer first, Integer second, Integer end, IList repl) {
        SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, lst.length());
        return this.$updateListSlice(lst, sd, SliceOperator.subtract, repl);
    }

    public final IList $alist_slice_product(IList lst, Integer first, Integer second, Integer end, IList repl) {
        SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, lst.length());
        return this.$updateListSlice(lst, sd, SliceOperator.product, repl);
    }

    public final IList $alist_slice_divide(IList lst, Integer first, Integer second, Integer end, IList repl) {
        SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, lst.length());
        return this.$updateListSlice(lst, sd, SliceOperator.divide, repl);
    }

    public final IList $updateListSlice(IList lst, SliceDescriptor sd, SliceOperator op, IList repl) {
        IListWriter w;
        block18: {
            w = this.$VF.listWriter();
            int increment = sd.second - sd.first;
            int replIndex = 0;
            int rlen = repl.length();
            boolean wrapped = false;
            if (sd.first == sd.end || increment == 0) break block18;
            if (sd.first <= sd.end) {
                assert (increment > 0);
                int listIndex = 0;
                while (listIndex < sd.first) {
                    w.append(lst.get(listIndex++));
                }
                while (listIndex >= 0 && listIndex < sd.end) {
                    w.append(op.execute(lst.get(listIndex), repl.get(replIndex++), this));
                    if (replIndex == rlen) {
                        replIndex = 0;
                        wrapped = true;
                    }
                    for (int q = 1; q < increment && listIndex + q < sd.end; ++q) {
                        w.append(lst.get(listIndex + q));
                    }
                    listIndex += increment;
                }
                listIndex = sd.end;
                if (!wrapped) {
                    while (replIndex < rlen) {
                        w.append(repl.get(replIndex++));
                    }
                }
                while (listIndex < lst.length()) {
                    w.append(lst.get(listIndex++));
                }
            } else {
                assert (increment < 0);
                int j = lst.length() - 1;
                while (j > sd.first) {
                    w.insert(lst.get(j--));
                }
                while (j >= 0 && j > sd.end && j < lst.length()) {
                    w.insert(op.execute(lst.get(j), repl.get(replIndex++), this));
                    if (replIndex == rlen) {
                        replIndex = 0;
                        wrapped = true;
                    }
                    for (int q = -1; q > increment && j + q > sd.end; --q) {
                        w.insert(lst.get(j + q));
                    }
                    j += increment;
                }
                j = sd.end;
                if (!wrapped) {
                    while (replIndex < rlen) {
                        w.insert(repl.get(replIndex++));
                    }
                }
                while (j >= 0) {
                    w.insert(lst.get(j--));
                }
            }
        }
        return (IList)w.done();
    }

    public final IListWriter $listwriter_splice(IListWriter writer, IValue val) {
        if (val instanceof IList) {
            IList lst = (IList)val;
            for (IValue v : lst) {
                writer.append(v);
            }
        } else if (val instanceof ISet) {
            ISet set = (ISet)val;
            for (IValue v : set) {
                writer.append(v);
            }
        } else {
            writer.append(val);
        }
        return writer;
    }

    public final ISetWriter $setwriter_splice(ISetWriter writer, IValue val) {
        if (val instanceof IList) {
            IList lst = (IList)val;
            for (IValue v : lst) {
                writer.insert(v);
            }
        } else if (val instanceof ISet) {
            ISet set = (ISet)val;
            for (IValue v : set) {
                writer.insert(v);
            }
        } else {
            writer.insert(val);
        }
        return writer;
    }

    public final IString $astr_subscript_int(IString str, int idx) {
        try {
            return idx >= 0 ? str.substring(idx, idx + 1) : str.substring(str.length() + idx, str.length() + idx + 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds(this.$VF.integer(idx));
        }
    }

    public final GuardedIValue $guarded_astr_subscript_int(IString str, int idx) {
        try {
            IString res = idx >= 0 ? str.substring(idx, idx + 1) : str.substring(str.length() + idx, str.length() + idx + 1);
            return new GuardedIValue(res);
        }
        catch (IndexOutOfBoundsException e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $alist_subscript_int(IList lst, int idx) {
        try {
            return lst.get(idx >= 0 ? idx : lst.length() + idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds(this.$VF.integer(idx));
        }
    }

    public final GuardedIValue $guarded_list_subscript(IList lst, int idx) {
        try {
            return new GuardedIValue(lst.get(idx >= 0 ? idx : lst.length() + idx));
        }
        catch (IndexOutOfBoundsException e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $amap_subscript(String name, IMap map, IValue idx) {
        IValue v = map.get(idx);
        if (v == null) {
            throw RuntimeExceptionFactory.noSuchKey(idx);
        }
        return v;
    }

    public final IValue $amap_subscript(IMap map, IValue idx) {
        IValue v = map.get(idx);
        if (v == null) {
            throw RuntimeExceptionFactory.noSuchKey(idx);
        }
        return v;
    }

    public final GuardedIValue $guarded_map_subscript(IMap map, IValue idx) {
        IValue v = map.get(idx);
        return v == null ? this.UNDEFINED : new GuardedIValue(v);
    }

    public final IValue $atuple_subscript_int(ITuple tup, int idx) {
        try {
            return tup.get(idx >= 0 ? idx : tup.arity() + idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds(this.$VF.integer(idx));
        }
    }

    public final GuardedIValue $guarded_atuple_subscript_int(ITuple tup, int idx) {
        try {
            IValue res = tup.get(idx >= 0 ? idx : tup.arity() + idx);
            return new GuardedIValue(res);
        }
        catch (IndexOutOfBoundsException e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $anode_subscript_int(INode node, int idx) {
        try {
            if (idx < 0) {
                idx = node.arity() + idx;
            }
            return node.get(idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds(this.$VF.integer(idx));
        }
    }

    public final GuardedIValue $guarded_anode_subscript_int(INode node, int idx) {
        try {
            if (idx < 0) {
                idx = node.arity() + idx;
            }
            IValue res = node.get(idx);
            return new GuardedIValue(res);
        }
        catch (IndexOutOfBoundsException e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $aadt_subscript_int(IConstructor cons, int idx) {
        try {
            return cons.get(idx >= 0 ? idx : cons.arity() + idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds(this.$VF.integer(idx));
        }
    }

    public final GuardedIValue $guarded_aadt_subscript_int(IConstructor cons, int idx) {
        try {
            IValue res = cons.get(idx >= 0 ? idx : cons.arity() + idx);
            return new GuardedIValue(res);
        }
        catch (IndexOutOfBoundsException e) {
            return this.UNDEFINED;
        }
    }

    public final ISet $arel_subscript1_noset(ISet rel, IValue idx) {
        if (rel.isEmpty()) {
            return rel;
        }
        return rel.asRelation().index(idx);
    }

    public final GuardedIValue $guarded_arel_subscript1_noset(ISet rel, IValue idx) {
        try {
            return new GuardedIValue(this.$arel_subscript1_noset(rel, idx));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final ISet $arel2_subscript1_aset(ISet rel, ISet idx) {
        if (rel.isEmpty()) {
            return rel;
        }
        ISetWriter wset = this.$VF.setWriter();
        for (IValue v : rel) {
            ITuple tup = (ITuple)v;
            IValue tup0 = tup.get(0);
            if ((!tup0.getType().isSet() || !idx.equals(tup0)) && !idx.contains(tup0)) continue;
            wset.insert(tup.get(1));
        }
        return (ISet)wset.done();
    }

    public final GuardedIValue $guarded_arel2_subscript1_aset(ISet rel, ISet idx) {
        try {
            return new GuardedIValue(this.$arel2_subscript1_aset(rel, idx));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final ISet $arel_subscript1_aset(ISet rel, ISet idx) {
        if (rel.isEmpty()) {
            return rel;
        }
        int relArity = rel.getElementType().getArity();
        ISetWriter wset = this.$VF.setWriter();
        IValue[] args = new IValue[relArity - 1];
        for (IValue v : rel) {
            ITuple tup = (ITuple)v;
            IValue tup0 = tup.get(0);
            if ((!tup0.getType().isSet() || !idx.equals(tup0)) && !idx.contains(tup0)) continue;
            for (int i = 1; i < relArity; ++i) {
                args[i - 1] = tup.get(i);
            }
            wset.insert(this.$VF.tuple(args));
        }
        return (ISet)wset.done();
    }

    public final GuardedIValue $guarded_arel_subscript1_aset(ISet rel, ISet idx) {
        try {
            return new GuardedIValue(this.$arel_subscript1_aset(rel, idx));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final ISet $arel_subscript(ISet rel, IValue[] idx, int[] subsDesc) {
        if (rel.isEmpty()) {
            return rel;
        }
        int indexArity = idx.length;
        int relArity = rel.getElementType().getArity();
        ISetWriter wset = this.$VF.setWriter();
        if (relArity - indexArity == 1) {
            block8: for (IValue v : rel) {
                ITuple tup = (ITuple)v;
                block9: for (int k = 0; k < indexArity; ++k) {
                    switch (subsDesc[k]) {
                        case 0: {
                            if (tup.get(k).equals(idx[k])) continue block9;
                            continue block8;
                        }
                        case 1: {
                            IValue tup_k = tup.get(k);
                            if (tup_k.getType().isSet() && idx[k].equals(tup_k) || ((ISet)idx[k]).contains(tup_k)) continue block9;
                            continue block8;
                        }
                    }
                }
                wset.insert(tup.get(indexArity));
            }
        } else {
            IValue[] args = new IValue[relArity - indexArity];
            block10: for (IValue v : rel) {
                ITuple tup = (ITuple)v;
                block11: for (int k = 0; k < indexArity; ++k) {
                    switch (subsDesc[k]) {
                        case 0: {
                            if (tup.get(k).equals(idx[k])) continue block11;
                            continue block10;
                        }
                        case 1: {
                            IValue tup_k = tup.get(k);
                            if (tup_k.getType().isSet() && idx[k].equals(tup_k) || ((ISet)idx[k]).contains(tup_k)) continue block11;
                            continue block10;
                        }
                    }
                }
                for (int i = indexArity; i < relArity; ++i) {
                    args[i - indexArity] = tup.get(i);
                }
                wset.insert(this.$VF.tuple(args));
            }
        }
        return (ISet)wset.done();
    }

    public final GuardedIValue $guarded_arel_subscript(ISet rel, IValue[] idx, int[] subsDesc) {
        try {
            return new GuardedIValue(this.$arel_subscript(rel, idx, subsDesc));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $alrel_subscript1_noset(IList lrel, IValue idx) {
        if (lrel.isEmpty()) {
            return lrel;
        }
        if (idx instanceof IInteger) {
            return lrel.get(((IInteger)idx).intValue());
        }
        return lrel.asRelation().index(idx);
    }

    public final GuardedIValue $guarded_alrel_subscript1_noset(IList lrel, IValue idx) {
        try {
            return new GuardedIValue(this.$alrel_subscript1_noset(lrel, idx));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final IList $alrel2_subscript1_aset(IList lrel, ISet idx) {
        if (lrel.isEmpty()) {
            return lrel;
        }
        IListWriter wlist = this.$VF.listWriter();
        for (IValue v : lrel) {
            ITuple tup = (ITuple)v;
            if (!idx.contains(tup.get(0))) continue;
            wlist.append(tup.get(1));
        }
        return (IList)wlist.done();
    }

    public final GuardedIValue $guarded_alrel2_subscript1_aset(IList lrel, ISet idx) {
        try {
            return new GuardedIValue(this.$alrel2_subscript1_aset(lrel, idx));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final IList $alrel_subscript1_aset(IList lrel, ISet index) {
        if (lrel.isEmpty()) {
            return lrel;
        }
        int lrelArity = lrel.getElementType().getArity();
        IListWriter wlist = this.$VF.listWriter();
        IValue[] args = new IValue[lrelArity - 1];
        for (IValue v : lrel) {
            ITuple tup = (ITuple)v;
            if (!index.contains(tup.get(0))) continue;
            for (int i = 1; i < lrelArity; ++i) {
                args[i - 1] = tup.get(i);
            }
            wlist.append(this.$VF.tuple(args));
        }
        return (IList)wlist.done();
    }

    public final GuardedIValue $guarded_alrel_subscript1_aset(IList lrel, ISet index) {
        try {
            return new GuardedIValue(this.$alrel_subscript1_aset(lrel, index));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final IList $alrel_subscript(IList lrel, IValue[] idx, int[] subsDesc) {
        if (lrel.isEmpty()) {
            return lrel;
        }
        int indexArity = idx.length;
        int lrelArity = lrel.getElementType().getArity();
        IListWriter wlist = this.$VF.listWriter();
        if (lrelArity - indexArity == 1) {
            block8: for (IValue v : lrel) {
                ITuple tup = (ITuple)v;
                block9: for (int k = 0; k < indexArity; ++k) {
                    switch (subsDesc[k]) {
                        case 0: {
                            if (tup.get(k).equals(idx[k])) continue block9;
                            continue block8;
                        }
                        case 1: {
                            if (((ISet)idx[k]).contains(tup.get(k))) continue block9;
                            continue block8;
                        }
                    }
                }
                wlist.append(tup.get(indexArity));
            }
        } else {
            IValue[] args = new IValue[lrelArity - indexArity];
            block10: for (IValue v : lrel) {
                ITuple tup = (ITuple)v;
                block11: for (int k = 0; k < indexArity; ++k) {
                    switch (subsDesc[k]) {
                        case 0: {
                            if (tup.get(k).equals(idx[k])) continue block11;
                            continue block10;
                        }
                        case 1: {
                            if (((ISet)idx[k]).contains(tup.get(k))) continue block11;
                            continue block10;
                        }
                    }
                }
                for (int i = indexArity; i < lrelArity; ++i) {
                    args[i - indexArity] = tup.get(i);
                }
                wlist.append(this.$VF.tuple(args));
            }
        }
        return (IList)wlist.done();
    }

    public final GuardedIValue $guarded_alrel_subscript(IList lrel, IValue[] idx, int[] subsDesc) {
        try {
            return new GuardedIValue(this.$alrel_subscript(lrel, idx, subsDesc));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $iter_subscript(ITree subject, int idx) {
        IList lst = TreeAdapter.getArgs(subject);
        return lst.get(idx);
    }

    public final IValue $subscript_int(ITuple tup, int idx) {
        return tup.get(idx);
    }

    public final IValue $subscript_int(INode nd, int idx) {
        return nd.get(idx);
    }

    public final IString $subscript_int(IString str, int idx) {
        return str.substring(idx, 1);
    }

    public final IValue $subscript_int(IValue subject, int idx) {
        Type subjectType = subject.getType();
        if (subjectType.isList()) {
            return ((IList)subject).get(idx);
        }
        if (subjectType.isTuple()) {
            return ((ITuple)subject).get(idx);
        }
        if (subjectType.isString()) {
            return ((IString)subject).substring(idx, 1);
        }
        if (subjectType.isAbstractData()) {
            return ((IConstructor)subject).get(idx);
        }
        if (subjectType.isNode()) {
            return ((INode)subject).get(idx);
        }
        throw new RuntimeException("Unsupported subscript of type " + subject.getType());
    }

    public final IValue $lexical_subscript(ITree subject, int idx) {
        IList args = TreeAdapter.getArgs(subject);
        try {
            return args.get(idx >= 0 ? idx : args.length() + idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds(this.$VF.integer(idx));
        }
    }

    public final IValue $lexical_subscript_seps(ITree subject, int idx) {
        IList args = TreeAdapter.getArgs(subject);
        try {
            return args.get(idx >= 0 ? 2 * idx : args.length() + 1 + 2 * idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds(this.$VF.integer(idx));
        }
    }

    public final IValue $concrete_subscript(ITree subject, int idx) {
        IList args = TreeAdapter.getArgs(subject);
        try {
            return args.get(idx >= 0 ? 2 * idx : args.length() + 1 + 2 * idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds(this.$VF.integer(idx));
        }
    }

    public final IValue $concrete_physical_subscript(ITree subject, int idx) {
        IList args = TreeAdapter.getArgs(subject);
        try {
            return args.get(idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds(this.$VF.integer(idx));
        }
    }

    public final IValue $concrete_subscript_seps(ITree subject, int idx) {
        int n;
        IList args = TreeAdapter.getArgs(subject);
        IConstructor nt = ProductionAdapter.getType(TreeAdapter.getProduction(subject));
        int delta = SymbolAdapter.getSeparators(nt).size() + 1;
        int n2 = n = idx >= 0 ? delta * idx : args.length() - 1 + delta * (idx + 1);
        if (n >= 0 && n < args.length()) {
            return args.get(n);
        }
        throw RuntimeExceptionFactory.indexOutOfBounds(this.$VF.integer(idx));
    }

    public final ITree $concreteSubList(ITree tree, int from, int len, int delta) {
        if (TreeAdapter.isList(tree)) {
            int actual_len;
            int adjusted_len = len;
            if (len > 0) {
                adjusted_len = len - delta + 1;
            }
            if (from >= (actual_len = tree.getArgs().length())) {
                return TreeAdapter.setArgs(tree, this.$VF.list(new IValue[0]));
            }
            return TreeAdapter.setArgs(tree, TreeAdapter.getArgs(tree).sublist(from, adjusted_len));
        }
        throw RuntimeExceptionFactory.illegalArgument(tree);
    }

    public final IList $alist_update(int n, IValue v, IList lst) {
        if (n < 0) {
            n = lst.length() + n;
        }
        try {
            return lst.put(n, v);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds(this.$VF.integer(n));
        }
    }

    public final IMap $amap_update(IValue key, IValue v, IMap map) {
        IMap res = map.put(key, v);
        return res;
    }

    public final ITuple $atuple_update(int n, IValue v, ITuple tup) {
        try {
            return tup.set(n, v);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds(this.$VF.integer(n));
        }
    }

    public final IConstructor $aadt_update(IConstructor cons, IString field, IValue v) {
        return cons.set(field.getValue(), v);
    }

    public String $displayTestArgs(IValue[] args) {
        StringBuilder res = new StringBuilder("\n");
        for (int i = 0; i < args.length; ++i) {
            res.append("arg #").append(i).append(": ").append(args[i]).append("\n");
        }
        return res.toString();
    }

    final IValue $add(IValue lhs, IValue rhs) {
        ToplevelType lhsType = ToplevelType.getToplevelType(lhs.getType());
        ToplevelType rhsType = ToplevelType.getToplevelType(rhs.getType());
        switch (lhsType) {
            case INT: {
                switch (rhsType) {
                    case INT: {
                        return ((IInteger)lhs).add((IInteger)rhs);
                    }
                    case NUM: {
                        return ((IInteger)lhs).add((INumber)rhs);
                    }
                    case REAL: {
                        return ((IInteger)lhs).add((IReal)rhs);
                    }
                    case RAT: {
                        return ((IInteger)lhs).add((IRational)rhs);
                    }
                    case LIST: {
                        return ((IList)rhs).insert(lhs);
                    }
                    case SET: {
                        return ((ISet)rhs).insert(lhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case NUM: {
                switch (rhsType) {
                    case INT: {
                        return ((INumber)lhs).add((IInteger)rhs);
                    }
                    case NUM: {
                        return ((INumber)lhs).add((INumber)rhs);
                    }
                    case REAL: {
                        return ((INumber)lhs).add((IReal)rhs);
                    }
                    case RAT: {
                        return ((INumber)lhs).add((IRational)rhs);
                    }
                    case LIST: {
                        return ((IList)rhs).insert(lhs);
                    }
                    case SET: {
                        return ((ISet)rhs).insert(lhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case REAL: {
                switch (rhsType) {
                    case INT: {
                        return ((IReal)lhs).add((IInteger)rhs);
                    }
                    case NUM: {
                        return ((IReal)lhs).add((INumber)rhs);
                    }
                    case REAL: {
                        return ((IReal)lhs).add((IReal)rhs);
                    }
                    case RAT: {
                        return ((IReal)lhs).add((IRational)rhs);
                    }
                    case LIST: {
                        return ((IList)rhs).insert(lhs);
                    }
                    case SET: {
                        return ((ISet)rhs).insert(lhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case RAT: {
                switch (rhsType) {
                    case INT: {
                        return ((IRational)lhs).add((IInteger)rhs);
                    }
                    case NUM: {
                        return ((IRational)lhs).add((INumber)rhs);
                    }
                    case REAL: {
                        return ((IRational)lhs).add((IReal)rhs);
                    }
                    case RAT: {
                        return ((IRational)lhs).add((IRational)rhs);
                    }
                    case LIST: {
                        return ((IList)rhs).insert(lhs);
                    }
                    case SET: {
                        return ((ISet)rhs).insert(lhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case SET: {
                return ((ISet)lhs).insert(rhs);
            }
            case LIST: {
                return ((IList)lhs).append(rhs);
            }
            case LOC: {
                switch (rhsType) {
                    case STR: {
                        return this.$aloc_add_astr((ISourceLocation)lhs, (IString)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case LREL: {
                switch (rhsType) {
                    case LIST: 
                    case LREL: {
                        return ((IList)lhs).concat((IList)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case MAP: {
                switch (rhsType) {
                    case MAP: {
                        return ((IMap)lhs).compose((IMap)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case REL: {
                switch (rhsType) {
                    case SET: 
                    case REL: {
                        return ((ISet)lhs).union((ISet)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case STR: {
                switch (rhsType) {
                    case STR: {
                        return ((IString)lhs).concat((IString)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case TUPLE: {
                switch (rhsType) {
                    case TUPLE: {
                        return this.$atuple_add_atuple((ITuple)lhs, (ITuple)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
        }
        switch (rhsType) {
            case LIST: {
                return ((IList)rhs).insert(lhs);
            }
            case SET: {
                return ((ISet)rhs).insert(lhs);
            }
        }
        throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
    }

    final IValue $subtract(IValue lhs, IValue rhs) {
        ToplevelType lhsType = ToplevelType.getToplevelType(lhs.getType());
        ToplevelType rhsType = ToplevelType.getToplevelType(rhs.getType());
        switch (lhsType) {
            case INT: {
                switch (rhsType) {
                    case INT: {
                        return ((IInteger)lhs).subtract((IInteger)rhs);
                    }
                    case NUM: {
                        return ((IInteger)lhs).subtract((INumber)rhs);
                    }
                    case REAL: {
                        return ((IInteger)lhs).subtract((IReal)rhs);
                    }
                    case RAT: {
                        return ((IInteger)lhs).subtract((IRational)rhs);
                    }
                }
                throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case NUM: {
                switch (rhsType) {
                    case INT: {
                        return ((INumber)lhs).subtract((IInteger)rhs);
                    }
                    case NUM: {
                        return ((INumber)lhs).subtract((INumber)rhs);
                    }
                    case REAL: {
                        return ((INumber)lhs).subtract((IReal)rhs);
                    }
                    case RAT: {
                        return ((INumber)lhs).subtract((IRational)rhs);
                    }
                }
                throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case REAL: {
                switch (rhsType) {
                    case INT: {
                        return ((IReal)lhs).subtract((IInteger)rhs);
                    }
                    case NUM: {
                        return ((IReal)lhs).subtract((INumber)rhs);
                    }
                    case REAL: {
                        return ((IReal)lhs).subtract((IReal)rhs);
                    }
                    case RAT: {
                        return ((IReal)lhs).subtract((IRational)rhs);
                    }
                }
                throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case RAT: {
                switch (rhsType) {
                    case INT: {
                        return ((IRational)lhs).subtract((IInteger)rhs);
                    }
                    case NUM: {
                        return ((IRational)lhs).subtract((INumber)rhs);
                    }
                    case REAL: {
                        return ((IRational)lhs).subtract((IReal)rhs);
                    }
                    case RAT: {
                        return ((IRational)lhs).subtract((IRational)rhs);
                    }
                }
                throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
            }
        }
        throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
    }

    public final IValue $product(IValue lhs, IValue rhs) {
        ToplevelType lhsType = ToplevelType.getToplevelType(lhs.getType());
        ToplevelType rhsType = ToplevelType.getToplevelType(rhs.getType());
        switch (lhsType) {
            case INT: {
                switch (rhsType) {
                    case INT: {
                        return ((IInteger)lhs).multiply((IInteger)rhs);
                    }
                    case NUM: {
                        return ((IInteger)lhs).multiply((INumber)rhs);
                    }
                    case REAL: {
                        return ((IInteger)lhs).multiply((IReal)rhs);
                    }
                    case RAT: {
                        return ((IInteger)lhs).multiply((IRational)rhs);
                    }
                }
                throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case NUM: {
                switch (rhsType) {
                    case INT: {
                        return ((INumber)lhs).multiply((IInteger)rhs);
                    }
                    case NUM: {
                        return ((INumber)lhs).multiply((INumber)rhs);
                    }
                    case REAL: {
                        return ((INumber)lhs).multiply((IReal)rhs);
                    }
                    case RAT: {
                        return ((INumber)lhs).multiply((IRational)rhs);
                    }
                }
                throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case REAL: {
                switch (rhsType) {
                    case INT: {
                        return ((IReal)lhs).multiply((IInteger)rhs);
                    }
                    case NUM: {
                        return ((IReal)lhs).multiply((INumber)rhs);
                    }
                    case REAL: {
                        return ((IReal)lhs).multiply((IReal)rhs);
                    }
                    case RAT: {
                        return ((IReal)lhs).multiply((IRational)rhs);
                    }
                }
                throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case RAT: {
                switch (rhsType) {
                    case INT: {
                        return ((IRational)lhs).multiply((IInteger)rhs);
                    }
                    case NUM: {
                        return ((IRational)lhs).multiply((INumber)rhs);
                    }
                    case REAL: {
                        return ((IRational)lhs).multiply((IReal)rhs);
                    }
                    case RAT: {
                        return ((IRational)lhs).multiply((IRational)rhs);
                    }
                }
                throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
            }
        }
        throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
    }

    final IValue $divide(IValue lhs, IValue rhs) {
        ToplevelType lhsType = ToplevelType.getToplevelType(lhs.getType());
        ToplevelType rhsType = ToplevelType.getToplevelType(rhs.getType());
        switch (lhsType) {
            case INT: {
                switch (rhsType) {
                    case INT: {
                        return this.$aint_divide_aint((IInteger)lhs, (IInteger)rhs);
                    }
                    case NUM: {
                        return this.$aint_divide_anum((IInteger)lhs, (INumber)rhs);
                    }
                    case REAL: {
                        return this.$aint_divide_areal((IInteger)lhs, (IReal)rhs);
                    }
                    case RAT: {
                        return this.$aint_divide_arat((IInteger)lhs, (IRational)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule divide: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case NUM: {
                switch (rhsType) {
                    case INT: {
                        return this.$anum_divide_aint((INumber)lhs, (IInteger)rhs);
                    }
                    case NUM: {
                        return this.$anum_divide_anum((INumber)lhs, (INumber)rhs);
                    }
                    case REAL: {
                        return this.$anum_divide_areal((INumber)lhs, (IReal)rhs);
                    }
                    case RAT: {
                        return this.$anum_divide_arat((INumber)lhs, (IRational)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule divide: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case REAL: {
                switch (rhsType) {
                    case INT: {
                        return this.$areal_divide_aint((IReal)lhs, (IInteger)rhs);
                    }
                    case NUM: {
                        return this.$areal_divide_anum((IReal)lhs, (INumber)rhs);
                    }
                    case REAL: {
                        return this.$areal_divide_areal((IReal)lhs, (IReal)rhs);
                    }
                    case RAT: {
                        return this.$areal_divide_arat((IReal)lhs, (IRational)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule divide: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case RAT: {
                switch (rhsType) {
                    case INT: {
                        return this.$arat_divide_aint((IRational)lhs, (IInteger)rhs);
                    }
                    case NUM: {
                        return this.$arat_divide_anum((IRational)lhs, (INumber)rhs);
                    }
                    case REAL: {
                        return this.$arat_divide_areal((IRational)lhs, (IReal)rhs);
                    }
                    case RAT: {
                        return this.$arat_divide_arat((IRational)lhs, (IRational)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule divide: Illegal type combination: " + lhsType + " and " + rhsType);
            }
        }
        throw new InternalCompilerError("$RascalModule divide: Illegal type combination: " + lhsType + " and " + rhsType);
    }

    final IValue $intersect(IValue left, IValue right) {
        Type leftType = left.getType();
        Type rightType = right.getType();
        switch (ToplevelType.getToplevelType(leftType)) {
            case LIST: {
                switch (ToplevelType.getToplevelType(rightType)) {
                    case LIST: 
                    case LREL: {
                        return ((IList)left).intersect((IList)right);
                    }
                }
                throw new InternalCompilerError("intersect: illegal combination " + leftType + " and " + rightType);
            }
            case SET: {
                switch (ToplevelType.getToplevelType(rightType)) {
                    case SET: 
                    case REL: {
                        return ((ISet)left).intersect((ISet)right);
                    }
                }
                throw new InternalCompilerError("intersect: illegal combination " + leftType + " and " + rightType);
            }
            case MAP: {
                return ((IMap)left).common((IMap)right);
            }
        }
        throw new InternalCompilerError("intersect: illegal combination " + leftType + " and " + rightType);
    }

    protected IString $toIString(IValue v) {
        if (v instanceof IString) {
            return (IString)v;
        }
        if (v instanceof ITree) {
            return this.$VF.string(TreeAdapter.yield((ITree)v));
        }
        return this.$VF.string(v.toString());
    }
}

