/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.runtime;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.asserts.Ambiguous;
import org.rascalmpl.parser.ParserGenerator;
import org.rascalmpl.parser.gtd.IGTD;
import org.rascalmpl.parser.gtd.exception.ParseError;
import org.rascalmpl.parser.gtd.exception.UndeclaredNonTerminalException;
import org.rascalmpl.parser.gtd.io.InputConverter;
import org.rascalmpl.parser.gtd.result.action.IActionExecutor;
import org.rascalmpl.parser.gtd.result.out.DefaultNodeFlattener;
import org.rascalmpl.parser.gtd.result.out.INodeConstructorFactory;
import org.rascalmpl.parser.gtd.util.StackNodeIdDispenser;
import org.rascalmpl.parser.uptr.UPTRNodeFactory;
import org.rascalmpl.parser.uptr.action.NoActionExecutor;
import org.rascalmpl.parser.uptr.recovery.ToTokenRecoverer;
import org.rascalmpl.runtime.ParserGeneratorFactory;
import org.rascalmpl.runtime.RascalExecutionContext;
import org.rascalmpl.runtime.RascalFunctionActionExecutor;
import org.rascalmpl.runtime.function.TypedFunction0;
import org.rascalmpl.runtime.function.TypedFunction1;
import org.rascalmpl.runtime.function.TypedFunction2;
import org.rascalmpl.runtime.function.TypedFunction3;
import org.rascalmpl.runtime.function.TypedFunction4;
import org.rascalmpl.runtime.function.TypedFunction5;
import org.rascalmpl.runtime.function.TypedFunction6;
import org.rascalmpl.runtime.function.TypedFunction7;
import org.rascalmpl.runtime.function.TypedFunction8;
import org.rascalmpl.runtime.function.TypedFunction9;
import org.rascalmpl.runtime.function.TypedFunctionInstance0;
import org.rascalmpl.runtime.function.TypedFunctionInstance1;
import org.rascalmpl.runtime.function.TypedFunctionInstance2;
import org.rascalmpl.runtime.function.TypedFunctionInstance3;
import org.rascalmpl.runtime.function.TypedFunctionInstance4;
import org.rascalmpl.runtime.function.TypedFunctionInstance5;
import org.rascalmpl.runtime.function.TypedFunctionInstance6;
import org.rascalmpl.runtime.function.TypedFunctionInstance7;
import org.rascalmpl.runtime.function.TypedFunctionInstance8;
import org.rascalmpl.runtime.function.TypedFunctionInstance9;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.types.RascalTypeFactory;
import org.rascalmpl.types.ReifiedType;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class RascalRuntimeValueFactory
extends RascalValueFactory {
    private final RascalExecutionContext rex;
    private LoadingCache<IMap, Class<IGTD<IConstructor, ITree, ISourceLocation>>> parserCache = Caffeine.newBuilder().softValues().maximumSize(100L).expireAfterAccess(30L, TimeUnit.MINUTES).build(grammar -> this.generateParser((IMap)grammar));

    public RascalRuntimeValueFactory(RascalExecutionContext rex) {
        this.rex = rex;
    }

    private ParserGenerator getParserGenerator() {
        return ParserGeneratorFactory.getInstance(this.rex).getParserGenerator(this);
    }

    private Class<IGTD<IConstructor, ITree, ISourceLocation>> generateParser(IMap grammar) {
        try {
            System.err.println("generateParser: " + grammar.hashCode());
            return this.getParserGenerator().getNewParser((IRascalMonitor)this.rex, URIUtil.rootLocation("parser-generator"), "$GENERATED_PARSER$" + Math.abs(grammar.hashCode()), grammar);
        }
        catch (ExceptionInInitializerError e) {
            throw new ImplementationError(e.getMessage(), e);
        }
    }

    private IGTD<IConstructor, ITree, ISourceLocation> getObjectParser(IMap iMap) {
        Class<IGTD<IConstructor, ITree, ISourceLocation>> parser = this.parserCache.get(iMap);
        try {
            return parser.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ImplementationError("could not instantiate generated parser", e);
        }
    }

    @Override
    public IFunction function(Type functionType, final BiFunction<IValue[], Map<String, IValue>, IValue> func) {
        switch (functionType.getArity()) {
            case 0: {
                return new TypedFunctionInstance0<IValue>(new TypedFunction0<IValue>(){

                    @Override
                    public IValue typedCall() {
                        return (IValue)func.apply(new IValue[0], Collections.emptyMap());
                    }
                }, functionType);
            }
            case 1: {
                return new TypedFunctionInstance1<IValue, IValue>(new TypedFunction1<IValue, IValue>(){

                    @Override
                    public IValue typedCall(IValue arg) {
                        return (IValue)func.apply(new IValue[]{arg}, Collections.emptyMap());
                    }
                }, functionType);
            }
            case 2: {
                return new TypedFunctionInstance2<IValue, IValue, IValue>(new TypedFunction2<IValue, IValue, IValue>(){

                    @Override
                    public IValue typedCall(IValue arg, IValue arg2) {
                        return (IValue)func.apply(new IValue[]{arg, arg2}, Collections.emptyMap());
                    }
                }, functionType);
            }
            case 3: {
                return new TypedFunctionInstance3<IValue, IValue, IValue, IValue>(new TypedFunction3<IValue, IValue, IValue, IValue>(){

                    @Override
                    public IValue typedCall(IValue arg, IValue arg2, IValue arg3) {
                        return (IValue)func.apply(new IValue[]{arg, arg2, arg3}, Collections.emptyMap());
                    }
                }, functionType);
            }
            case 4: {
                return new TypedFunctionInstance4<IValue, IValue, IValue, IValue, IValue>(new TypedFunction4<IValue, IValue, IValue, IValue, IValue>(){

                    @Override
                    public IValue typedCall(IValue arg, IValue arg2, IValue arg3, IValue arg4) {
                        return (IValue)func.apply(new IValue[]{arg, arg2, arg3, arg4}, Collections.emptyMap());
                    }
                }, functionType);
            }
            case 5: {
                return new TypedFunctionInstance5<IValue, IValue, IValue, IValue, IValue, IValue>(new TypedFunction5<IValue, IValue, IValue, IValue, IValue, IValue>(){

                    @Override
                    public IValue typedCall(IValue arg, IValue arg2, IValue arg3, IValue arg4, IValue arg5) {
                        return (IValue)func.apply(new IValue[]{arg, arg2, arg3, arg4, arg5}, Collections.emptyMap());
                    }
                }, functionType);
            }
            case 6: {
                return new TypedFunctionInstance6<IValue, IValue, IValue, IValue, IValue, IValue, IValue>(new TypedFunction6<IValue, IValue, IValue, IValue, IValue, IValue, IValue>(){

                    @Override
                    public IValue typedCall(IValue arg, IValue arg2, IValue arg3, IValue arg4, IValue arg5, IValue arg6) {
                        return (IValue)func.apply(new IValue[]{arg, arg2, arg3, arg4, arg5, arg6}, Collections.emptyMap());
                    }
                }, functionType);
            }
            case 7: {
                return new TypedFunctionInstance7<IValue, IValue, IValue, IValue, IValue, IValue, IValue, IValue>(new TypedFunction7<IValue, IValue, IValue, IValue, IValue, IValue, IValue, IValue>(){

                    @Override
                    public IValue typedCall(IValue arg, IValue arg2, IValue arg3, IValue arg4, IValue arg5, IValue arg6, IValue arg7) {
                        return (IValue)func.apply(new IValue[]{arg, arg2, arg3, arg4, arg5, arg6, arg7}, Collections.emptyMap());
                    }
                }, functionType);
            }
            case 8: {
                return new TypedFunctionInstance8<IValue, IValue, IValue, IValue, IValue, IValue, IValue, IValue, IValue>(new TypedFunction8<IValue, IValue, IValue, IValue, IValue, IValue, IValue, IValue, IValue>(){

                    @Override
                    public IValue typedCall(IValue arg, IValue arg2, IValue arg3, IValue arg4, IValue arg5, IValue arg6, IValue arg7, IValue arg8) {
                        return (IValue)func.apply(new IValue[]{arg, arg2, arg3, arg4, arg5, arg6, arg7, arg8}, Collections.emptyMap());
                    }
                }, functionType);
            }
            case 9: {
                return new TypedFunctionInstance9<IValue, IValue, IValue, IValue, IValue, IValue, IValue, IValue, IValue, IValue>(new TypedFunction9<IValue, IValue, IValue, IValue, IValue, IValue, IValue, IValue, IValue, IValue>(){

                    @Override
                    public IValue typedCall(IValue arg, IValue arg2, IValue arg3, IValue arg4, IValue arg5, IValue arg6, IValue arg7, IValue arg8, IValue arg9) {
                        return (IValue)func.apply(new IValue[]{arg, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9}, Collections.emptyMap());
                    }
                }, functionType);
            }
        }
        throw new UnsupportedOperationException("do not support functions with arity higher than 6 yet?");
    }

    @Override
    public IFunction parser(IValue reifiedGrammar, IBool allowAmbiguity, IBool allowRecovery, IBool hasSideEffects, IBool firstAmbiguity, ISet filters) {
        TypeFactory tf = TypeFactory.getInstance();
        Type functionType = tf.functionType(reifiedGrammar.getType().getTypeParameters().getFieldType(0), tf.tupleType(tf.valueType(), tf.sourceLocationType()), tf.tupleEmpty());
        return this.function(functionType, new ParseFunction(this, reifiedGrammar, allowAmbiguity, allowRecovery, hasSideEffects, firstAmbiguity, filters));
    }

    @Override
    public IFunction parsers(IValue reifiedGrammar, IBool allowAmbiguity, IBool allowRecovery, IBool hasSideEffects, IBool firstAmbiguity, ISet filters) {
        RascalTypeFactory rtf = RascalTypeFactory.getInstance();
        TypeFactory tf = TypeFactory.getInstance();
        Type parameterType = tf.parameterType("U", RascalValueFactory.Tree);
        Type functionType = tf.functionType(parameterType, tf.tupleType(rtf.reifiedType(parameterType), tf.valueType(), tf.sourceLocationType()), tf.tupleEmpty());
        return this.function(functionType, new ParametrizedParseFunction(this, reifiedGrammar, allowAmbiguity, allowRecovery, hasSideEffects, firstAmbiguity, filters));
    }

    private class ParametrizedParseFunction
    extends ParseFunction {
        public ParametrizedParseFunction(IRascalValueFactory vf, IValue grammar, IBool allowAmbiguity, IBool allowRecovery, IBool hasSideEffects, IBool firstAmbiguity, ISet filters) {
            super(vf, grammar, allowAmbiguity, allowRecovery, hasSideEffects, firstAmbiguity, filters);
        }

        @Override
        public IValue apply(IValue[] parameters, Map<String, IValue> keywordParameters) {
            if (parameters.length != 3) {
                throw this.fail(parameters);
            }
            if (this.firstAmbiguity) {
                if (parameters[1].getType().isString()) {
                    return this.firstAmbiguity(parameters[0], (IString)parameters[1], RascalRuntimeValueFactory.this.getParserGenerator());
                }
                if (parameters[1].getType().isSourceLocation()) {
                    return this.firstAmbiguity(parameters[0], (ISourceLocation)parameters[1], RascalRuntimeValueFactory.this.getParserGenerator());
                }
            } else {
                if (!(parameters[0].getType() instanceof ReifiedType)) {
                    throw this.fail(parameters);
                }
                if (!parameters[2].getType().isSourceLocation()) {
                    throw this.fail(parameters);
                }
                if (parameters[1].getType().isString()) {
                    return this.parse(parameters[0], (IString)parameters[1], (ISourceLocation)parameters[2], this.allowAmbiguity, this.allowRecovery, this.hasSideEffects, this.filters, RascalRuntimeValueFactory.this.getParserGenerator());
                }
                if (parameters[1].getType().isSourceLocation()) {
                    return this.parse(parameters[0], (ISourceLocation)parameters[1], (ISourceLocation)parameters[2], this.allowAmbiguity, this.allowRecovery, this.hasSideEffects, this.filters, RascalRuntimeValueFactory.this.getParserGenerator());
                }
            }
            throw this.fail(parameters);
        }
    }

    private class ParseFunction
    implements BiFunction<IValue[], Map<String, IValue>, IValue> {
        protected final IValue grammar;
        protected final ISet filters;
        protected final IValueFactory vf;
        protected final boolean allowAmbiguity;
        protected final boolean allowRecovery;
        protected final boolean hasSideEffects;
        protected final boolean firstAmbiguity;

        public ParseFunction(IRascalValueFactory vf, IValue grammar, IBool allowAmbiguity, IBool allowRecovery, IBool hasSideEffects, IBool firstAmbiguity, ISet filters) {
            this.vf = vf;
            this.grammar = grammar;
            this.filters = filters;
            this.allowAmbiguity = allowAmbiguity.getValue() || firstAmbiguity.getValue();
            this.allowRecovery = allowRecovery.getValue();
            this.hasSideEffects = hasSideEffects.getValue();
            this.firstAmbiguity = firstAmbiguity.getValue();
        }

        @Override
        public IValue apply(IValue[] parameters, Map<String, IValue> keywordParameters) {
            if (parameters.length != 2) {
                throw this.fail(parameters);
            }
            if (this.firstAmbiguity) {
                if (parameters[0].getType().isString()) {
                    return this.firstAmbiguity(this.grammar, (IString)parameters[0], RascalRuntimeValueFactory.this.getParserGenerator());
                }
                if (parameters[0].getType().isSourceLocation()) {
                    return this.firstAmbiguity(this.grammar, (ISourceLocation)parameters[0], RascalRuntimeValueFactory.this.getParserGenerator());
                }
            } else {
                if (!parameters[1].getType().isSourceLocation()) {
                    throw this.fail(parameters);
                }
                if (parameters[0].getType().isString()) {
                    return this.parse(this.grammar, (IString)parameters[0], (ISourceLocation)parameters[1], this.allowAmbiguity, this.allowRecovery, this.hasSideEffects, this.filters, RascalRuntimeValueFactory.this.getParserGenerator());
                }
                if (parameters[0].getType().isSourceLocation()) {
                    return this.parse(this.grammar, (ISourceLocation)parameters[0], (ISourceLocation)parameters[1], this.allowAmbiguity, this.allowRecovery, this.hasSideEffects, this.filters, RascalRuntimeValueFactory.this.getParserGenerator());
                }
            }
            throw this.fail(parameters);
        }

        protected Throw fail(IValue ... parameters) {
            return RuntimeExceptionFactory.callFailed(URIUtil.rootLocation("unknown"), Arrays.stream(parameters).collect(this.vf.listWriter()));
        }

        protected IValue firstAmbiguity(IValue start, IString input, ParserGenerator generator) {
            Type reified = start.getType();
            IConstructor grammar = this.checkPreconditions(start, reified);
            try {
                return this.parseObject(grammar, input.getValue(), URIUtil.rootLocation("unknown"), false, false, false, this.filters);
            }
            catch (ParseError pe) {
                ISourceLocation errorLoc = pe.getLocation();
                throw RuntimeExceptionFactory.parseError(errorLoc);
            }
            catch (Ambiguous e) {
                return e.getTree();
            }
            catch (UndeclaredNonTerminalException e) {
                throw RuntimeExceptionFactory.illegalArgument(this.vf.string(e.getName()));
            }
        }

        protected IValue firstAmbiguity(IValue start, ISourceLocation input, ParserGenerator generator) {
            Type reified = start.getType();
            IConstructor grammar = this.checkPreconditions(start, reified);
            try {
                return this.parseObject(grammar, this.filters, input, false, false, false);
            }
            catch (ParseError pe) {
                ISourceLocation errorLoc = pe.getLocation();
                throw RuntimeExceptionFactory.parseError(errorLoc);
            }
            catch (Ambiguous e) {
                return e.getTree();
            }
            catch (UndeclaredNonTerminalException e) {
                throw RuntimeExceptionFactory.illegalArgument(this.vf.string(e.getName()));
            }
        }

        private IString printSymbol(IConstructor symbol) {
            return this.vf.string(SymbolAdapter.toString(symbol, false));
        }

        protected IValue parse(IValue start, IString input, ISourceLocation origin, boolean allowAmbiguity, boolean allowRecovery, boolean hasSideEffects, ISet filters, ParserGenerator generator) {
            Type reified = start.getType();
            IConstructor grammar = this.checkPreconditions(start, reified);
            if (origin == null) {
                origin = URIUtil.rootLocation("unknown");
            }
            try {
                return this.parseObject(grammar, input.getValue(), origin, allowAmbiguity, allowRecovery, hasSideEffects, filters);
            }
            catch (ParseError pe) {
                ISourceLocation errorLoc = pe.getLocation();
                throw RuntimeExceptionFactory.parseError(errorLoc);
            }
            catch (Ambiguous e) {
                ITree tree = e.getTree();
                throw RuntimeExceptionFactory.ambiguity(e.getLocation(), this.printSymbol(TreeAdapter.getType(tree)), this.vf.string(TreeAdapter.yield(tree)));
            }
            catch (UndeclaredNonTerminalException e) {
                throw RuntimeExceptionFactory.illegalArgument(this.vf.string(e.getName()));
            }
        }

        protected IValue parse(IValue start, ISourceLocation input, ISourceLocation origin, boolean allowAmbiguity, boolean allowRecovery, boolean hasSideEffects, ISet filters, ParserGenerator generator) {
            Type reified = start.getType();
            IConstructor grammar = this.checkPreconditions(start, reified);
            if (origin == null) {
                origin = input;
            }
            try {
                return this.parseObject(grammar, filters, input, allowAmbiguity, allowRecovery, hasSideEffects);
            }
            catch (ParseError pe) {
                ISourceLocation errorLoc = pe.getLocation();
                throw RuntimeExceptionFactory.parseError(errorLoc);
            }
            catch (Ambiguous e) {
                ITree tree = e.getTree();
                throw RuntimeExceptionFactory.ambiguity(e.getLocation(), this.printSymbol(TreeAdapter.getType(tree)), this.vf.string(TreeAdapter.yield(tree)));
            }
            catch (UndeclaredNonTerminalException e) {
                throw RuntimeExceptionFactory.illegalArgument(this.vf.string(e.getName()));
            }
        }

        private ITree parseObject(IConstructor grammar, ISourceLocation location, char[] input, boolean allowAmbiguity, boolean allowRecovery, boolean hasSideEffects, ISet filters) {
            IConstructor startSort = (IConstructor)grammar.get("symbol");
            IGTD<IConstructor, ITree, ISourceLocation> parser = RascalRuntimeValueFactory.this.getObjectParser((IMap)grammar.get("definitions"));
            String name = RascalRuntimeValueFactory.this.getParserGenerator().getParserMethodName(startSort);
            IActionExecutor<ITree> exec = filters.isEmpty() ? new NoActionExecutor() : new RascalFunctionActionExecutor(filters, !hasSideEffects);
            URI uri = location.getURI();
            ToTokenRecoverer recoverer = null;
            if (allowRecovery) {
                recoverer = new ToTokenRecoverer(uri, parser, new StackNodeIdDispenser(parser));
            }
            return (ITree)parser.parse(name, uri, input, exec, new DefaultNodeFlattener(), (INodeConstructorFactory<ITree, ISourceLocation>)new UPTRNodeFactory(allowAmbiguity || allowRecovery), recoverer);
        }

        private IConstructor parseObject(IConstructor startSort, ISet filters, ISourceLocation location, boolean allowAmbiguity, boolean allowRecovery, boolean hasSideEffects) {
            try {
                char[] input = this.getResourceContent(location);
                return this.parseObject(startSort, location, input, allowAmbiguity, allowRecovery, hasSideEffects, filters);
            }
            catch (IOException e) {
                throw RuntimeExceptionFactory.io(this.vf.string(e.getMessage()));
            }
        }

        private IConstructor parseObject(IConstructor startSort, String input, ISourceLocation loc, boolean allowAmbiguity, boolean allowRecovery, boolean hasSideEffects, ISet filters) {
            return this.parseObject(startSort, loc, input.toCharArray(), allowAmbiguity, allowRecovery, hasSideEffects, filters);
        }

        private IConstructor checkPreconditions(IValue start, Type reified) {
            if (!(reified instanceof ReifiedType)) {
                throw RuntimeExceptionFactory.illegalArgument(start, "A reified type is required instead of " + reified);
            }
            Type nt = reified.getTypeParameters().getFieldType(0);
            if (!(nt instanceof NonTerminalType)) {
                throw RuntimeExceptionFactory.illegalArgument(start, "A non-terminal type is required instead of  " + nt);
            }
            return (IConstructor)start;
        }

        private char[] getResourceContent(ISourceLocation location) throws IOException {
            try (Reader textStream = URIResolverRegistry.getInstance().getCharacterReader(location);){
                char[] cArray = InputConverter.toChar(textStream);
                return cArray;
            }
        }
    }
}

