/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.runtime.traverse;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.type.Type;
import java.util.Iterator;
import java.util.Stack;
import org.rascalmpl.runtime.traverse.IDescendantDescriptor;
import org.rascalmpl.types.DefaultRascalTypeVisitor;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.types.RascalType;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.iterators.MapKeyValueIterator;
import org.rascalmpl.values.iterators.TupleElementIterator;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class DescendantMatchIterator
implements Iterator<IValue>,
Iterable<IValue> {
    final Stack<Object> spine = new Stack();
    private final boolean debug = false;
    private final IDescendantDescriptor descriptor;
    private final boolean concreteMatch;

    public DescendantMatchIterator(IValue val, IDescendantDescriptor descriptor) {
        this.concreteMatch = descriptor.isConcreteMatch();
        this.descriptor = descriptor;
        this.push(val);
    }

    @Override
    public boolean hasNext() {
        while (this.spine.size() > 0 && this.spine.peek() instanceof Iterator && !((Iterator)this.spine.peek()).hasNext()) {
            this.spine.pop();
        }
        return this.spine.size() > 0;
    }

    @Override
    public IValue next() {
        if (this.spine.peek() instanceof Iterator) {
            Iterator iter = (Iterator)this.spine.peek();
            if (!iter.hasNext()) {
                this.spine.pop();
                return this.next();
            }
            this.push((IValue)iter.next());
            return this.next();
        }
        return (IValue)this.spine.pop();
    }

    private void push(IValue v, Iterator<IValue> children) {
        this.spine.push(v);
        this.spine.push(children);
    }

    private void push(final IValue v) {
        if (this.concreteMatch) {
            if (v.getType().isSubtypeOf(RascalValueFactory.Tree)) {
                this.pushConcreteSyntaxNode((ITree)v);
            }
            return;
        }
        if (this.descriptor.shouldDescentInAbstractValue(v).getValue() && v.getType().accept(new DefaultRascalTypeVisitor<Boolean, RuntimeException>(Boolean.valueOf(false)){

            @Override
            public Boolean visitList(Type type) throws RuntimeException {
                IList lst = (IList)v;
                int len = lst.length();
                if (len == 0) {
                    DescendantMatchIterator.this.spine.push(lst);
                } else if (len == 1) {
                    DescendantMatchIterator.this.spine.push(lst);
                    DescendantMatchIterator.this.push(lst.get(0));
                } else {
                    DescendantMatchIterator.this.push(lst, lst.iterator());
                }
                return true;
            }

            @Override
            public Boolean visitSet(Type type) throws RuntimeException {
                ISet set = (ISet)v;
                if (set.isEmpty()) {
                    DescendantMatchIterator.this.spine.push(set);
                } else {
                    DescendantMatchIterator.this.push(set, set.iterator());
                }
                return true;
            }

            @Override
            public Boolean visitMap(Type type) throws RuntimeException {
                IMap map = (IMap)v;
                if (map.isEmpty()) {
                    DescendantMatchIterator.this.spine.push(map);
                } else {
                    DescendantMatchIterator.this.push(map, new MapKeyValueIterator(map));
                }
                return true;
            }

            @Override
            public Boolean visitTuple(Type type) throws RuntimeException {
                DescendantMatchIterator.this.push(v, new TupleElementIterator((ITuple)v));
                return true;
            }

            @Override
            public Boolean visitNode(Type type) throws RuntimeException {
                INode node = (INode)v;
                int arity = node.arity();
                if (arity == 0) {
                    DescendantMatchIterator.this.spine.push(node);
                } else if (arity == 1) {
                    DescendantMatchIterator.this.spine.push(node);
                    DescendantMatchIterator.this.push(node.get(0));
                } else {
                    DescendantMatchIterator.this.push(node, node.getChildren().iterator());
                }
                if (node.mayHaveKeywordParameters()) {
                    IWithKeywordParameters<? extends INode> nodeKW = node.asWithKeywordParameters();
                    for (String name : nodeKW.getParameterNames()) {
                        DescendantMatchIterator.this.push(nodeKW.getParameter(name));
                    }
                }
                return true;
            }

            @Override
            public Boolean visitConstructor(Type type) throws RuntimeException {
                return this.visitNode(type);
            }

            @Override
            public Boolean visitAbstractData(Type type) throws RuntimeException {
                return this.visitNode(type);
            }

            @Override
            public Boolean visitNonTerminal(RascalType type) throws RuntimeException {
                return this.visitNode(type);
            }
        }).booleanValue()) {
            return;
        }
        this.spine.push(v);
    }

    private void pushConcreteSyntaxNode(ITree tree) {
        if (TreeAdapter.isAmb(tree)) {
            for (IValue alt : TreeAdapter.getAlternatives(tree)) {
                this.pushConcreteSyntaxNode((ITree)alt);
            }
            return;
        }
        if (this.descriptor.shouldDescentInConcreteValue(tree).getValue()) {
            NonTerminalType ctype = (NonTerminalType)tree.getType();
            IConstructor sym = ctype.getSymbol();
            if (SymbolAdapter.isAnyList(sym)) {
                this.spine.push(tree);
                int delta = SymbolAdapter.getListSkipDelta(sym);
                sym = SymbolAdapter.getSymbol(sym);
                IList listElems = (IList)tree.get(1);
                for (int i = listElems.length() - 1; i >= 0; i -= delta) {
                    this.pushConcreteSyntaxNode((ITree)listElems.get(i));
                }
            } else if (SymbolAdapter.isStartSort(sym)) {
                this.pushConcreteSyntaxNode(TreeAdapter.getStartTop(tree));
            } else {
                this.spine.push(tree);
                IList applArgs = (IList)tree.get(1);
                int delta = SymbolAdapter.isLex(sym) ? 1 : 2;
                for (int i = applArgs.length() - 1; i >= 0; i -= delta) {
                    this.pushConcreteSyntaxNode((ITree)applArgs.get(i));
                }
            }
        } else {
            this.spine.push(tree);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove from DescendantMatchIterator");
    }

    @Override
    public Iterator<IValue> iterator() {
        return this;
    }
}

