/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.runtime.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.tools.JavaFileObject;
import org.rascalmpl.runtime.utils.JavaFileObjectImpl;

final class ClassLoaderImpl
extends ClassLoader {
    private final Map<String, JavaFileObject> classes = new HashMap<String, JavaFileObject>();

    ClassLoaderImpl(ClassLoader parentClassLoader) {
        super(parentClassLoader);
    }

    Collection<JavaFileObject> files() {
        return Collections.unmodifiableCollection(this.classes.values());
    }

    @Override
    protected Class<?> findClass(String qualifiedClassName) throws ClassNotFoundException {
        JavaFileObject file = this.classes.get(qualifiedClassName);
        if (file != null) {
            byte[] bytes = ((JavaFileObjectImpl)file).getByteCode();
            return this.defineClass(qualifiedClassName, bytes, 0, bytes.length);
        }
        try {
            Class<?> c = Class.forName(qualifiedClassName);
            return c;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.findClass(qualifiedClassName);
        }
    }

    void add(String qualifiedClassName, JavaFileObject javaFile) {
        this.classes.put(qualifiedClassName, javaFile);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        String qualifiedClassName;
        JavaFileObjectImpl file;
        if (name.endsWith(".class") && (file = (JavaFileObjectImpl)this.classes.get(qualifiedClassName = name.substring(0, name.length() - ".class".length()).replace('/', '.'))) != null) {
            return new ByteArrayInputStream(file.getByteCode());
        }
        return super.getResourceAsStream(name);
    }
}

