/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.runtime.utils;

import io.usethesource.vallang.ISourceLocation;
import java.util.Arrays;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.JavaCompilation;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.runtime.utils.JavaCompiler;
import org.rascalmpl.runtime.utils.JavaCompilerException;

public class JavaBridge {
    public JavaBridge(List<ClassLoader> classLoaders, PathConfig config) {
        if (ToolProvider.getSystemJavaCompiler() == null) {
            throw new ImplementationError("Could not find an installed System Java Compiler, please provide a Java Runtime that includes the Java Development Tools (JDK 1.6 or higher).");
        }
    }

    public <T> Class<T> compileJava(ISourceLocation loc, String className, String source) {
        return this.compileJava(loc, className, this.getClass(), source);
    }

    public <T> Class<T> compileJava(ISourceLocation loc, String className, Class<?> parent, String source) {
        try {
            List<String> commandline = Arrays.asList("-proc:none");
            JavaCompiler javaCompiler = new JavaCompiler(parent.getClassLoader(), null, commandline);
            Class result = javaCompiler.compile(className, source, null, Object.class);
            return result;
        }
        catch (ClassCastException e) {
            throw new JavaCompilation(e.getMessage(), 0L, 0L, className, e);
        }
        catch (JavaCompilerException e) {
            if (!e.getDiagnostics().getDiagnostics().isEmpty()) {
                Diagnostic<JavaFileObject> msg = e.getDiagnostics().getDiagnostics().iterator().next();
                throw new JavaCompilation(msg.getMessage(null), msg.getLineNumber(), msg.getColumnNumber(), className, e);
            }
            throw new JavaCompilation(e.getMessage(), 0L, 0L, className, e);
        }
    }
}

