/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import org.jline.terminal.Terminal;
import org.jline.utils.InfoCmp;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.ast.ShellCommand;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.control_exceptions.QuitException;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.semantics.dynamic.QualifiedName;

public abstract class ShellCommand
extends org.rascalmpl.ast.ShellCommand {
    public ShellCommand(ISourceLocation __param1, IConstructor tree) {
        super(__param1, tree);
    }

    public static class Unimport
    extends ShellCommand.Unimport {
        public Unimport(ISourceLocation __param1, IConstructor tree, QualifiedName __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            ((ModuleEnvironment)__eval.getCurrentEnvt().getRoot()).unImport(Names.fullName(this.getName()));
            return ResultFactory.nothing();
        }
    }

    public static class Test
    extends ShellCommand.Test {
        public Test(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            return ResultFactory.makeResult(TF.boolType(), VF.bool(__eval.runTests(__eval.getMonitor())), __eval);
        }
    }

    public static class SetOption
    extends ShellCommand.SetOption {
        public SetOption(ISourceLocation __param1, IConstructor tree, QualifiedName __param2, Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            String name = "rascal." + ((QualifiedName.Default)this.getName()).fullName();
            String value = this.getExpression().interpret(__eval).getValue().toString();
            switch (name) {
                case "rascal.generatorProfiling": {
                    __eval.getConfiguration().setGeneratorProfiling(Boolean.parseBoolean(value));
                    __eval.getParserGenerator().setGeneratorProfiling(Boolean.parseBoolean(value));
                    break;
                }
                case "rascal.profiling": {
                    __eval.getConfiguration().setProfiling(Boolean.parseBoolean(value));
                    break;
                }
                case "rascal.errors": {
                    __eval.getConfiguration().setErrors(Boolean.parseBoolean(value));
                    break;
                }
                case "rascal.tracing": {
                    __eval.getConfiguration().setTracing(Boolean.parseBoolean(value));
                }
            }
            __eval.updateProperties();
            return ResultFactory.nothing();
        }
    }

    public static class Quit
    extends ShellCommand.Quit {
        public Quit(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            throw new QuitException();
        }
    }

    public static class ListDeclarations
    extends ShellCommand.ListDeclarations {
        public ListDeclarations(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            return ResultFactory.nothing();
        }
    }

    public static class History
    extends ShellCommand.History {
        public History(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }
    }

    public static class Help
    extends ShellCommand.Help {
        public Help(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.printHelpMessage(__eval.getOutPrinter());
            return ResultFactory.nothing();
        }
    }

    public static class Clear
    extends ShellCommand.Clear {
        public Clear(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            IRascalMonitor monitor = __eval.getMonitor();
            if (monitor instanceof IDEServices) {
                IDEServices services = (IDEServices)monitor;
                Terminal term = services.activeTerminal();
                if (term != null) {
                    term.puts(InfoCmp.Capability.clear_screen, new Object[0]);
                } else {
                    __eval.getErrorPrinter().println("There is no terminal available to clear");
                }
            } else {
                __eval.getErrorPrinter().println("The current Rascal execution environment does not know how to clear the REPL.");
            }
            return ResultFactory.nothing();
        }
    }

    public static class Edit
    extends ShellCommand.Edit {
        public Edit(ISourceLocation __param1, IConstructor tree, QualifiedName __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            IRascalMonitor monitor = __eval.getMonitor();
            if (monitor instanceof IDEServices) {
                IDEServices services = (IDEServices)monitor;
                String name = Names.fullName(this.getName());
                ISourceLocation uri = __eval.getRascalResolver().resolveModule(name);
                if (uri == null) {
                    __eval.getErrorPrinter().println("module " + name + " can not be found in the search path.");
                } else {
                    services.edit(uri);
                }
            } else {
                __eval.getErrorPrinter().println("The current Rascal execution environment does not know how to start an editor.");
            }
            return ResultFactory.nothing();
        }
    }
}

