/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.shell;

import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.io.StandardTextWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.jline.terminal.Terminal;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.repl.streams.StreamUtil;
import org.rascalmpl.shell.RascalShell;
import org.rascalmpl.shell.ShellEvaluatorFactory;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.jar.JarURIResolver;

public abstract class AbstractCommandlineTool {
    public static void main(String mainModule, String[] sourceFolders, String[] args) {
        block11: {
            try {
                RascalShell.setupJavaProcessForREPL();
                Terminal term = RascalShell.connectToTerminal();
                IRascalMonitor monitor = IRascalMonitor.buildConsoleMonitor(term);
                PrintWriter err = monitor instanceof Writer ? StreamUtil.generateErrorStream(term, (Writer)((Object)monitor)) : new PrintWriter(System.err, true);
                PrintWriter out = monitor instanceof PrintWriter ? (PrintWriter)((Object)monitor) : new PrintWriter(System.out, false);
                try {
                    Evaluator eval = ShellEvaluatorFactory.getEvaluatorForMain(term.reader(), out, err, monitor);
                    ISourceLocation rascalJar = JarURIResolver.jarify(PathConfig.resolveCurrentRascalRuntimeJar());
                    for (String folder : sourceFolders) {
                        ISourceLocation src = URIUtil.getChildLocation(rascalJar, folder);
                        if (!URIResolverRegistry.getInstance().exists(src)) {
                            throw new FileNotFoundException(src.toString());
                        }
                        eval.addRascalSearchPath(src);
                    }
                    eval.doImport(monitor, mainModule);
                    IValue result = eval.main(monitor, mainModule, "main", args);
                    if (result == null) {
                        System.exit(0);
                        break block11;
                    }
                    if (result.getType().isInteger()) {
                        System.exit(((IInteger)result).intValue());
                        break block11;
                    }
                    System.exit(0);
                }
                catch (Throw e) {
                    try {
                        err.println(e.getException());
                        e.getTrace().prettyPrintedString(err, new StandardTextWriter());
                    }
                    catch (IOException ioe) {
                        err.println(ioe.getMessage());
                    }
                    System.exit(1);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
        }
    }
}

