/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri;

import io.usethesource.vallang.ISourceLocation;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.rascalmpl.uri.ISourceLocationInputOutput;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;

public class CompressedStreamResolver
implements ISourceLocationInputOutput {
    private final URIResolverRegistry registry;

    public CompressedStreamResolver(URIResolverRegistry registry) {
        this.registry = registry;
    }

    @Override
    public String scheme() {
        return "compressed";
    }

    private ISourceLocation getActualURI(ISourceLocation wrappedURI) throws IOException {
        String scheme = wrappedURI.getScheme();
        if (scheme.length() <= "compressed+".length()) {
            throw new IOException("Invalid scheme: \"" + scheme + "\"");
        }
        String actualScheme = scheme.substring("compressed+".length());
        try {
            return URIUtil.changeScheme(wrappedURI, actualScheme);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URI: \"" + wrappedURI + "\"", e);
        }
    }

    private static final InputStream getInputStream(String compressionMethod, InputStream original) throws IOException, CompressorException {
        return new CompressorStreamFactory().createCompressorInputStream(compressionMethod, original);
    }

    @Override
    public InputStream getInputStream(ISourceLocation uri) throws IOException {
        InputStream result = this.registry.getInputStream(this.getActualURI(uri));
        if (result != null) {
            try {
                String detectedCompression = this.detectCompression(uri);
                if (detectedCompression == null) {
                    return new CompressorStreamFactory().createCompressorInputStream(result);
                }
                return CompressedStreamResolver.getInputStream(detectedCompression, result);
            }
            catch (CompressorException e) {
                result.close();
                throw new IOException("We cannot decompress this file.", e);
            }
        }
        return null;
    }

    private static final OutputStream getOutputStream(String compressionMethod, OutputStream original) throws IOException, CompressorException {
        return new CompressorStreamFactory().createCompressorOutputStream(compressionMethod, original);
    }

    @Override
    public OutputStream getOutputStream(ISourceLocation uri, boolean append) throws IOException {
        OutputStream result = this.registry.getOutputStream(this.getActualURI(uri), append);
        if (result != null) {
            String detectedCompression = this.detectCompression(uri);
            if (detectedCompression == null) {
                throw new IOException("We could not detect the compression based on the extension.");
            }
            try {
                return new BufferedOutputStream(CompressedStreamResolver.getOutputStream(detectedCompression, result));
            }
            catch (CompressorException e) {
                result.close();
                throw new IOException("We cannot compress this kind of file. (Only gz,xz,bz2 have write support)", e);
            }
        }
        return null;
    }

    private static String findExtension(String path) {
        char[] result = new char[5];
        int slen = path.length();
        int end = Math.min(5, slen);
        path.getChars(slen - end, slen, result, 0);
        for (int c = end - 1; c >= 0; --c) {
            if (result[c] != '.') continue;
            return new String(result, c + 1, end - (c + 1));
        }
        return null;
    }

    private String detectCompression(ISourceLocation uri) throws IOException {
        String extension = CompressedStreamResolver.findExtension(uri.getPath());
        if (extension != null) {
            switch (extension) {
                case "gz": {
                    return "gz";
                }
                case "bz": {
                    return "bzip2";
                }
                case "bz2": {
                    return "bzip2";
                }
                case "lzma": {
                    return "lzma";
                }
                case "Z": {
                    return "z";
                }
                case "xz": {
                    return "xz";
                }
                case "zst": {
                    return "zstd";
                }
                case "7z": 
                case "zip": 
                case "rar": 
                case "tar": 
                case "jar": {
                    throw new IOException("We only support compression formats. The extension " + extension + " is an archive format, which could decompress to more than one file.");
                }
            }
        }
        return null;
    }

    @Override
    public boolean exists(ISourceLocation uri) {
        try {
            return this.registry.exists(this.getActualURI(uri));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public Charset getCharset(ISourceLocation uri) throws IOException {
        return this.registry.getCharset(this.getActualURI(uri));
    }

    @Override
    public boolean isDirectory(ISourceLocation uri) {
        try {
            return this.registry.isDirectory(this.getActualURI(uri));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isFile(ISourceLocation uri) {
        try {
            return this.registry.isFile(this.getActualURI(uri));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public long lastModified(ISourceLocation uri) throws IOException {
        return this.registry.lastModified(this.getActualURI(uri));
    }

    @Override
    public void setLastModified(ISourceLocation uri, long timestamp) throws IOException {
        this.registry.setLastModified(this.getActualURI(uri), timestamp);
    }

    @Override
    public String[] list(ISourceLocation uri) throws IOException {
        return this.registry.listEntries(this.getActualURI(uri));
    }

    @Override
    public void mkDirectory(ISourceLocation uri) throws IOException {
        this.registry.mkDirectory(this.getActualURI(uri));
    }

    @Override
    public void remove(ISourceLocation uri) throws IOException {
        this.registry.remove(this.getActualURI(uri), false);
    }

    @Override
    public boolean supportsHost() {
        return true;
    }
}

