/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.file;

import io.usethesource.vallang.ISourceLocation;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.rascalmpl.uri.BadURIException;
import org.rascalmpl.uri.ISourceLocationInputOutput;
import org.rascalmpl.uri.ISourceLocationWatcher;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.classloaders.IClassloaderLocationResolver;

public class FileURIResolver
implements ISourceLocationInputOutput,
IClassloaderLocationResolver,
ISourceLocationWatcher {
    private final Map<ISourceLocation, Set<Consumer<ISourceLocationWatcher.ISourceLocationChanged>>> watchers = new ConcurrentHashMap<ISourceLocation, Set<Consumer<ISourceLocationWatcher.ISourceLocationChanged>>>();
    private final Map<WatchKey, ISourceLocation> watchKeys = new ConcurrentHashMap<WatchKey, ISourceLocation>();
    private final WatchService watcher = FileSystems.getDefault().newWatchService();

    public FileURIResolver() throws IOException {
        this.createFileWatchingThread();
    }

    @Override
    public InputStream getInputStream(ISourceLocation uri) throws IOException {
        String path = this.getPath(uri);
        if (path != null) {
            return new FileInputStream(path);
        }
        throw new IOException("uri has no path: " + uri);
    }

    @Override
    public ClassLoader getClassLoader(ISourceLocation loc, ClassLoader parent) throws IOException {
        assert (loc.getScheme().equals(this.scheme()));
        Object path = loc.getPath();
        if (this.isDirectory(loc) && !((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        if (!this.isDirectory(loc) && !((String)path).endsWith(".jar")) {
            throw new IOException("Can only provide classloaders for directories or jar files, not for " + loc);
        }
        return new URLClassLoader(new URL[]{new File((String)path).toURI().toURL()}, parent);
    }

    @Override
    public void setLastModified(ISourceLocation uri, long timestamp) throws IOException {
        this.resolveToFile(uri).setLastModified(timestamp);
    }

    @Override
    public OutputStream getOutputStream(ISourceLocation uri, boolean append) throws IOException {
        String path = this.getPath(uri);
        if (path != null) {
            return new BufferedOutputStream(new FileOutputStream(this.getPath(uri), append));
        }
        throw new IOException("uri has no path: " + uri);
    }

    @Override
    public void remove(ISourceLocation uri) throws IOException {
        this.resolveToFile(uri).delete();
    }

    @Override
    public void rename(ISourceLocation from, ISourceLocation to, boolean overwrite) throws IOException {
        if (this.isFile(from) || this.isDirectory(from) && this.list(from).length == 0) {
            if (this.exists(to) && !overwrite) {
                throw new IOException("file exists " + to);
            }
            if (!this.resolveToFile(from).renameTo(this.resolveToFile(to))) {
                throw new IOException("rename failed: " + from + " to " + to);
            }
        } else {
            ISourceLocationInputOutput.super.rename(from, to, overwrite);
        }
    }

    @Override
    public String scheme() {
        return "file";
    }

    @Override
    public boolean exists(ISourceLocation uri) {
        return this.resolveToFile(uri).exists();
    }

    protected String getPath(ISourceLocation uri) {
        assert (!uri.hasAuthority());
        return uri.getPath();
    }

    @Override
    public boolean isDirectory(ISourceLocation uri) {
        return this.resolveToFile(uri).isDirectory();
    }

    @Override
    public boolean isFile(ISourceLocation uri) {
        return this.resolveToFile(uri).isFile();
    }

    @Override
    public long lastModified(ISourceLocation uri) {
        return this.resolveToFile(uri).lastModified();
    }

    @Override
    public long created(ISourceLocation uri) throws IOException {
        BasicFileAttributeView basicfile = Files.getFileAttributeView(this.resolveToFile(uri).toPath(), BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        BasicFileAttributes attr = basicfile.readAttributes();
        return attr.creationTime().toMillis();
    }

    @Override
    public String[] list(ISourceLocation uri) {
        return this.resolveToFile(uri).list();
    }

    private File resolveToFile(ISourceLocation uri) {
        return new File(this.getPath(uri));
    }

    @Override
    public void mkDirectory(ISourceLocation uri) {
        this.resolveToFile(uri).mkdirs();
    }

    public static ISourceLocation constructFileURI(String path) {
        try {
            return URIUtil.createFileLocation(path);
        }
        catch (URISyntaxException usex) {
            throw new BadURIException(usex);
        }
    }

    @Override
    public boolean supportsHost() {
        return false;
    }

    @Override
    public Charset getCharset(ISourceLocation uri) throws IOException {
        return null;
    }

    @Override
    public boolean supportsReadableFileChannel() {
        return true;
    }

    @Override
    public FileChannel getReadableFileChannel(ISourceLocation uri) throws IOException {
        String path = this.getPath(uri);
        if (path != null) {
            return FileChannel.open(this.resolveToFile(uri).toPath(), StandardOpenOption.READ);
        }
        throw new IOException("uri has no path: " + uri);
    }

    @Override
    public boolean supportsWritableFileChannel() {
        return true;
    }

    @Override
    public FileChannel getWritableOutputStream(ISourceLocation uri, boolean append) throws IOException {
        String path = this.getPath(uri);
        if (path != null) {
            OpenOption[] options = append ? new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.APPEND} : new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
            return FileChannel.open(new File(path).toPath(), options);
        }
        throw new IOException("uri has no path: " + uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watch(ISourceLocation root, Consumer<ISourceLocationWatcher.ISourceLocationChanged> callback) throws IOException {
        this.watchers.computeIfAbsent(root, k -> ConcurrentHashMap.newKeySet()).add(callback);
        WatchKey key = this.resolveToFile(root).toPath().register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        Map<WatchKey, ISourceLocation> map = this.watchKeys;
        synchronized (map) {
            this.watchKeys.put(key, root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unwatch(ISourceLocation root, Consumer<ISourceLocationWatcher.ISourceLocationChanged> callback) throws IOException {
        Set<Consumer<ISourceLocationWatcher.ISourceLocationChanged>> registered = this.watchers.get(root);
        if (registered == null || !registered.remove(callback)) {
            return;
        }
        if (registered.isEmpty()) {
            for (Map.Entry<WatchKey, ISourceLocation> e : this.watchKeys.entrySet()) {
                if (!e.getValue().equals(root)) continue;
                Map<WatchKey, ISourceLocation> map = this.watchKeys;
                synchronized (map) {
                    if (registered.isEmpty()) {
                        WatchKey k = e.getKey();
                        k.cancel();
                        this.watchKeys.remove(k);
                    }
                    break;
                }
            }
        }
    }

    private void createFileWatchingThread() {
        ExecutorService exec = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                SecurityManager s2 = System.getSecurityManager();
                ThreadGroup group = s2 != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup();
                Thread t2 = new Thread(group, r, "file:/// watcher thread-pool");
                t2.setDaemon(true);
                return t2;
            }
        });
        exec.execute(() -> this.lambda$createFileWatchingThread$2(exec));
    }

    private ISourceLocationWatcher.ISourceLocationChanged calculateChange(WatchKey key, ISourceLocation root, WatchEvent.Kind<?> kind, ISourceLocation subject) {
        boolean isDirectory = URIResolverRegistry.getInstance().isDirectory(subject);
        switch (kind.name()) {
            case "ENTRY_CREATE": {
                return ISourceLocationWatcher.makeChange(subject, ISourceLocationWatcher.ISourceLocationChangeType.CREATED, isDirectory ? ISourceLocationWatcher.ISourceLocationType.DIRECTORY : ISourceLocationWatcher.ISourceLocationType.FILE);
            }
            case "ENTRY_DELETE": {
                this.watchers.remove(subject);
                if (root.equals(subject)) {
                    this.watchKeys.remove(key);
                }
                return ISourceLocationWatcher.makeChange(subject, ISourceLocationWatcher.ISourceLocationChangeType.DELETED, isDirectory ? ISourceLocationWatcher.ISourceLocationType.DIRECTORY : ISourceLocationWatcher.ISourceLocationType.FILE);
            }
            case "ENTRY_MODIFY": {
                return ISourceLocationWatcher.makeChange(subject, ISourceLocationWatcher.ISourceLocationChangeType.MODIFIED, isDirectory ? ISourceLocationWatcher.ISourceLocationType.DIRECTORY : ISourceLocationWatcher.ISourceLocationType.FILE);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$createFileWatchingThread$2(ExecutorService exec) {
        while (true) {
            try {
                block8: while (true) {
                    key = this.watcher.take();
                    try {
                        root = this.watchKeys.get(key);
                        if (root == null) continue;
                        var4_6 = key.pollEvents().iterator();
                        block9: while (true) {
                            if (!var4_6.hasNext()) continue block8;
                            event = var4_6.next();
                            kind = event.kind();
                            if (kind == StandardWatchEventKinds.OVERFLOW || (callbacks = this.watchers.get(root)) == null || (change = this.calculateChange(key, root, kind, subject = URIUtil.getChildLocation(root, (filename = (Path)event.context()).toString()))) == null) continue;
                            var11_13 = callbacks.iterator();
                            while (true) {
                                if (var11_13.hasNext()) ** break;
                                continue block9;
                                c = var11_13.next();
                                exec.execute((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$createFileWatchingThread$1(java.util.function.Consumer org.rascalmpl.uri.ISourceLocationWatcher$ISourceLocationChanged ), ()V)(c, (ISourceLocationWatcher.ISourceLocationChanged)change));
                            }
                            break;
                        }
                    }
                    finally {
                        if (key.reset()) continue;
                        this.watchKeys.remove(key);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable x) {
                System.err.println("Error handling callback in FileURIResolver: " + x.getMessage());
                x.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }

    private static /* synthetic */ void lambda$createFileWatchingThread$1(Consumer c, ISourceLocationWatcher.ISourceLocationChanged change) {
        c.accept(change);
    }
}

