/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.jar;

import io.usethesource.vallang.ISourceLocation;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.jar.JarFileResolver;
import org.rascalmpl.uri.jar.JarInputStreamFileTree;
import org.rascalmpl.uri.zip.CompressedFSTree;

public class JarInputStreamResolver
extends JarFileResolver {
    private final URIResolverRegistry CTX;

    public JarInputStreamResolver(URIResolverRegistry registry) {
        this.CTX = registry;
    }

    @Override
    protected CompressedFSTree getFileHierchyCache(ISourceLocation jarLocation) {
        try {
            ISourceLocation lookupKey = URIUtil.changeQuery(jarLocation, "mod=" + this.CTX.lastModified(jarLocation));
            return this.fsCache.get(lookupKey, j -> {
                try {
                    return new JarInputStreamFileTree(this.CTX.getInputStream(jarLocation), this.CTX.created(jarLocation), this.CTX.lastModified(jarLocation));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private JarEntry skipToEntry(JarInputStream stream, ISourceLocation jarLocation, String subPath) throws IOException {
        int pos = this.getFileHierchyCache(jarLocation).getPosition(subPath);
        if (pos != -1) {
            JarEntry entry;
            do {
                entry = stream.getNextJarEntry();
            } while (pos-- > 0);
            return entry;
        }
        return null;
    }

    @Override
    public InputStream getInputStream(ISourceLocation jarLocation, String subPath) throws IOException {
        final JarInputStream stream = new JarInputStream(this.CTX.getInputStream(jarLocation));
        if (this.skipToEntry(stream, jarLocation, subPath) != null) {
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    byte[] result = new byte[1];
                    if (stream.read(result, 0, 1) != -1) {
                        return result[0] & 0xFF;
                    }
                    return -1;
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return stream.read(b, off, len);
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return stream.read(b, 0, b.length);
                }

                @Override
                public void close() throws IOException {
                    stream.close();
                }

                @Override
                public int available() throws IOException {
                    return stream.available();
                }

                @Override
                public long skip(long n) throws IOException {
                    return stream.skip(n);
                }
            };
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

