/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.jar;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValueFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import org.rascalmpl.uri.ISourceLocationInput;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.classloaders.IClassloaderLocationResolver;
import org.rascalmpl.uri.jar.JarFileResolver;
import org.rascalmpl.uri.jar.JarInputStreamResolver;
import org.rascalmpl.values.ValueFactoryFactory;

public class JarURIResolver
implements ISourceLocationInput,
IClassloaderLocationResolver {
    private static final IValueFactory VF = ValueFactoryFactory.getValueFactory();
    private final JarFileResolver file = new JarFileResolver();
    private final JarFileResolver inputStream;
    private final URIResolverRegistry registry;

    public JarURIResolver(URIResolverRegistry registry) {
        this.registry = registry;
        this.inputStream = new JarInputStreamResolver(registry);
    }

    @Override
    public String scheme() {
        return "jar";
    }

    private JarFileResolver getTargetResolver(ISourceLocation uri) {
        if (uri.getScheme().equals("file")) {
            return this.file;
        }
        return this.inputStream;
    }

    private ISourceLocation safeResolve(ISourceLocation loc) {
        try {
            return this.registry.logicalToPhysical(loc);
        }
        catch (Throwable e) {
            return loc;
        }
    }

    private static String getInsideJarPath(ISourceLocation uri) {
        int bang;
        String path = uri.getPath();
        if (path != null && !path.isEmpty() && (bang = path.lastIndexOf(33)) != -1) {
            path = path.substring(bang + 1);
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            return path;
        }
        return "";
    }

    private ISourceLocation getResolvedJarPath(ISourceLocation uri) throws IOException {
        boolean isWrapped = uri.getScheme().startsWith("jar+");
        try {
            int bang;
            String path = uri.getPath();
            if (path != null && !path.isEmpty() && (bang = path.lastIndexOf(33)) != -1) {
                return this.safeResolve(VF.sourceLocation(isWrapped ? uri.getScheme().substring("jar+".length()) : "file", isWrapped ? uri.getAuthority() : "", path.substring(path.indexOf("/"), bang)));
            }
            throw new IOException("The jar and the internal path should be separated with a ! (" + uri.getPath() + ")");
        }
        catch (UnsupportedOperationException | URISyntaxException e) {
            throw new IOException("Invalid URI: \"" + uri + "\"", e);
        }
    }

    @Override
    public InputStream getInputStream(ISourceLocation uri) throws IOException {
        ISourceLocation jarUri = this.getResolvedJarPath(uri);
        return this.getTargetResolver(jarUri).getInputStream(jarUri, JarURIResolver.getInsideJarPath(uri));
    }

    @Override
    public boolean isDirectory(ISourceLocation uri) {
        if (uri.getPath() != null && (uri.getPath().endsWith("!") || uri.getPath().endsWith("!/"))) {
            return true;
        }
        try {
            ISourceLocation jarUri = this.getResolvedJarPath(uri);
            return this.getTargetResolver(jarUri).isDirectory(jarUri, JarURIResolver.getInsideJarPath(uri));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean exists(ISourceLocation uri) {
        try {
            ISourceLocation jarUri = this.getResolvedJarPath(uri);
            return this.getTargetResolver(jarUri).exists(jarUri, JarURIResolver.getInsideJarPath(uri));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isFile(ISourceLocation uri) {
        try {
            ISourceLocation jarUri = this.getResolvedJarPath(uri);
            return this.getTargetResolver(jarUri).isFile(jarUri, JarURIResolver.getInsideJarPath(uri));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public Charset getCharset(ISourceLocation uri) throws IOException {
        return null;
    }

    @Override
    public long lastModified(ISourceLocation uri) throws IOException {
        ISourceLocation jarUri = this.getResolvedJarPath(uri);
        return this.getTargetResolver(jarUri).lastModified(jarUri, JarURIResolver.getInsideJarPath(uri));
    }

    @Override
    public long created(ISourceLocation uri) throws IOException {
        ISourceLocation jarUri = this.getResolvedJarPath(uri);
        return this.getTargetResolver(jarUri).created(jarUri, JarURIResolver.getInsideJarPath(uri));
    }

    @Override
    public String[] list(ISourceLocation uri) throws IOException {
        ISourceLocation jarUri = this.getResolvedJarPath(uri);
        return this.getTargetResolver(jarUri).list(jarUri, JarURIResolver.getInsideJarPath(uri));
    }

    @Override
    public boolean supportsHost() {
        return true;
    }

    @Override
    public ClassLoader getClassLoader(ISourceLocation loc, ClassLoader parent) throws IOException {
        return this.registry.getClassLoader(this.getResolvedJarPath(loc), parent);
    }

    public static ISourceLocation jarify(ISourceLocation loc) {
        if (!loc.getPath().endsWith(".jar")) {
            return loc;
        }
        try {
            loc = URIUtil.changeScheme(loc, "jar+" + loc.getScheme());
            loc = URIUtil.changePath(loc, loc.getPath() + "!/");
            return loc;
        }
        catch (URISyntaxException e) {
            assert (false);
            return loc;
        }
    }
}

