/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.remote;

import io.usethesource.vallang.ISourceLocation;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.rascalmpl.uri.ISourceLocationInput;

public class HttpURIResolver
implements ISourceLocationInput {
    @Override
    public InputStream getInputStream(ISourceLocation uri) throws IOException {
        return new BufferedInputStream(uri.getURI().toURL().openStream());
    }

    @Override
    public String scheme() {
        return "http";
    }

    @Override
    public boolean exists(ISourceLocation uri) {
        try {
            uri.getURI().toURL().openConnection();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isDirectory(ISourceLocation uri) {
        return false;
    }

    @Override
    public boolean isFile(ISourceLocation uri) {
        return true;
    }

    @Override
    public long lastModified(ISourceLocation uri) {
        try {
            return uri.getURI().toURL().openConnection().getLastModified();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public String[] list(ISourceLocation uri) {
        return new String[0];
    }

    @Override
    public boolean supportsHost() {
        return true;
    }

    @Override
    public Charset getCharset(ISourceLocation uri) throws IOException {
        try {
            String encoding = uri.getURI().toURL().openConnection().getContentEncoding();
            if (encoding != null && Charset.isSupported(encoding)) {
                return Charset.forName(encoding);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

