/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.visualize.dot;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.rascalmpl.util.visualize.dot.DotAttribute;
import org.rascalmpl.util.visualize.dot.DotStatement;
import org.rascalmpl.util.visualize.dot.NodeId;

public class DotNode
implements DotStatement {
    private NodeId id;
    private List<DotAttribute> attributes;

    public static DotNode createArrayNode(NodeId id, int size) {
        DotNode node = new DotNode(id);
        node.addAttribute(DotAttribute.createArrayLabel(size));
        node.addAttribute("shape", "record");
        return node;
    }

    public DotNode(String id) {
        this(new NodeId(id));
    }

    public DotNode(NodeId id) {
        this.id = id;
        this.attributes = new ArrayList<DotAttribute>();
    }

    public NodeId getId() {
        return this.id;
    }

    public void addAttribute(String property, String value) {
        this.addAttribute(new DotAttribute(property, value));
    }

    public void addAttribute(DotAttribute attribute) {
        this.attributes.add(attribute);
    }

    public void setAttribute(String property, String value) {
        for (DotAttribute attribute : this.attributes) {
            if (!attribute.getProperty().equals(property)) continue;
            attribute.setValue(value);
            return;
        }
        this.addAttribute(property, value);
    }

    public String getAttributeValue(String property) {
        for (DotAttribute attribute : this.attributes) {
            if (!attribute.getProperty().equals(property)) continue;
            return attribute.getValue();
        }
        return null;
    }

    public void setLabel(String label) {
        this.setAttribute("label", label);
    }

    @Override
    public void writeSource(PrintWriter writer) {
        this.id.writeSource(writer);
        DotAttribute.writeAttributes(writer, this.attributes);
    }
}

