/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.visualize.dot;

import java.io.PrintWriter;
import java.util.Objects;
import org.rascalmpl.util.visualize.dot.CompassPoint;

public class NodeId {
    private String id;
    private String portId;
    private CompassPoint direction;

    public static void writeId(PrintWriter stream, String id) {
        stream.write("\"");
        NodeId.writeString(stream, id);
        stream.write("\"");
    }

    public static void writeString(PrintWriter stream, String s2) {
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c == '\"') {
                stream.append('\\');
            }
            if (c == '\n') {
                stream.append("\\n");
                continue;
            }
            stream.append(c);
        }
    }

    public NodeId(String id) {
        this(id, null, null);
    }

    public NodeId(NodeId original, String portId) {
        this(original.id, portId, null);
    }

    public NodeId(String id, String portId, CompassPoint direction) {
        this.id = id;
        this.portId = portId;
        this.direction = direction;
    }

    public NodeId(NodeId original, String portId, CompassPoint direction) {
        this.id = original.id;
        this.portId = portId;
        this.direction = direction;
    }

    public String getId() {
        return this.id;
    }

    public String getPortId() {
        return this.portId;
    }

    public CompassPoint getDirection() {
        return this.direction;
    }

    void writeSource(PrintWriter writer) {
        NodeId.writeId(writer, this.id);
        if (this.portId != null) {
            writer.write(":");
            NodeId.writeId(writer, this.portId);
            if (this.direction != null) {
                writer.write(":");
                writer.write(this.direction.name().toLowerCase());
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.portId == null ? 0 : this.portId.hashCode());
        result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeId other = (NodeId)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.portId, other.portId) && this.direction == other.direction;
    }

    public String toString() {
        Object result = this.id;
        if (this.portId != null) {
            result = (String)result + ":" + this.portId;
        }
        if (this.direction != null) {
            result = (String)result + ":" + this.direction;
        }
        return result;
    }
}

