/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.values.iterators;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Iterator;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.NotEnumerable;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.staticErrors.UnsupportedOperation;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.types.RascalTypeFactory;
import org.rascalmpl.types.TypeReachability;
import org.rascalmpl.values.iterators.CFListIterator;
import org.rascalmpl.values.iterators.DescendantReader;
import org.rascalmpl.values.iterators.NodeChildIterator;
import org.rascalmpl.values.iterators.SingleIValueIterator;
import org.rascalmpl.values.iterators.TupleElementIterator;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class IteratorFactory {
    public static Type elementType(IEvaluatorContext ctx, Result<IValue> subject) {
        Type subjectType = subject.getStaticUnaliasedType();
        if (subjectType.isList() || subjectType.isSet()) {
            return subjectType.getElementType();
        }
        if (subjectType.isMap()) {
            return subjectType.getKeyType();
        }
        if (subjectType.isExternalType()) {
            NonTerminalType nt;
            if (subjectType instanceof NonTerminalType && ((nt = (NonTerminalType)subjectType).isConcreteListType() || nt.isOptionalType())) {
                IConstructor listSymbol = nt.getSymbol();
                return RascalTypeFactory.getInstance().nonTerminalType(SymbolAdapter.getSymbol(listSymbol));
            }
            throw new NotEnumerable(subjectType.toString(), ctx.getCurrentAST());
        }
        if (subjectType.isNode() || subjectType.isAbstractData() || subjectType.isTuple()) {
            return TypeFactory.getInstance().valueType();
        }
        throw new NotEnumerable(subjectType.toString(), ctx.getCurrentAST());
    }

    public static Iterator<IValue> make(IEvaluatorContext ctx, IMatchingResult matchPattern, Result<IValue> subject, boolean shallow) {
        Type subjectType = subject.getStaticUnaliasedType();
        IValue subjectValue = subject.getValue();
        Type patType = matchPattern.getType(ctx.getCurrentEnvt(), null);
        if (subjectType.isTop()) {
            System.err.println("???");
        }
        if (subjectType.isList()) {
            if (shallow) {
                IteratorFactory.checkMayOccur(patType, subjectType.getElementType(), ctx);
                return ((IList)subjectValue).iterator();
            }
            return new DescendantReader(subjectValue, false);
        }
        if (subjectType.isSet()) {
            if (shallow) {
                IteratorFactory.checkMayOccur(patType, subjectType.getElementType(), ctx);
                return ((ISet)subjectValue).iterator();
            }
            return new DescendantReader(subjectValue, false);
        }
        if (subjectType.isMap()) {
            if (shallow) {
                IteratorFactory.checkMayOccur(patType, subjectType.getKeyType(), ctx);
                return ((IMap)subjectValue).iterator();
            }
            return new DescendantReader(subjectValue, false);
        }
        if (subjectType.isExternalType()) {
            if (subjectType instanceof NonTerminalType) {
                ITree tree = (ITree)subjectValue;
                NonTerminalType nt = (NonTerminalType)subjectType;
                if (!shallow) {
                    return new DescendantReader(tree, patType instanceof NonTerminalType);
                }
                if (nt.isConcreteListType()) {
                    IteratorFactory.checkMayOccur(patType, subjectType, ctx);
                    IConstructor ls = nt.getSymbol();
                    int delta = SymbolAdapter.isSepList(ls) ? SymbolAdapter.getSeparators(ls).length() + 1 : 1;
                    return new CFListIterator(TreeAdapter.getArgs(tree), delta);
                }
                if (nt.isOptionalType()) {
                    IteratorFactory.checkMayOccur(patType, subjectType, ctx);
                    return new CFListIterator(TreeAdapter.getArgs(tree), 1);
                }
            }
            throw new NotEnumerable(subjectType.toString(), ctx.getCurrentAST());
        }
        if (subjectType.isNode() || subjectType.isAbstractData()) {
            if (shallow) {
                if (subjectType.isAbstractData()) {
                    IteratorFactory.checkMayOccur(patType, subjectType, ctx);
                }
                return new NodeChildIterator((INode)subjectValue);
            }
            return new DescendantReader(subjectValue, false);
        }
        if (subjectType.isTuple()) {
            if (shallow) {
                Type lub = TypeFactory.getInstance().voidType();
                int nElems = subjectType.getArity();
                for (int i = 0; i < nElems; ++i) {
                    lub = lub.lub(subjectType.getFieldType(i));
                }
                if (!lub.comparable(patType)) {
                    throw new UnexpectedType(patType, subjectType, ctx.getCurrentAST());
                }
                return new TupleElementIterator((ITuple)subjectValue);
            }
            return new DescendantReader(subjectValue, false);
        }
        if (subjectType.isBool() || subjectType.isInteger() || subjectType.isReal() || subjectType.isString() || subjectType.isSourceLocation() || subjectType.isRational() || subjectType.isDateTime()) {
            if (shallow) {
                throw new NotEnumerable(subjectType.toString(), ctx.getCurrentAST());
            }
            return new SingleIValueIterator(subjectValue);
        }
        throw new UnsupportedOperation("makeIterator", subjectType, ctx.getCurrentAST());
    }

    private static void checkMayOccur(Type patType, Type rType, IEvaluatorContext ctx) {
        if (!TypeReachability.mayOccurIn(patType, rType, ctx.getCurrentEnvt())) {
            throw new UnexpectedType(rType, patType, ctx.getCurrentAST());
        }
    }
}

