---
title: "module Location"
id: Location
slug: /Library//Location
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

Library functions for source locations.
#### Usage

```rascal
import Location;
```

#### Dependencies
```rascal
import IO;
import List;
import Set;
import String;
import Exception;
```

#### Description


The following library functions are defined for source locations:
* [beginsAfter](..//Library/Location.md#Location-beginsAfter)
* [beginsBefore](..//Library/Location.md#Location-beginsBefore)
* [cover](..//Library/Location.md#Location-cover)
* [getContent](..//Library/Location.md#Location-getContent)
* [isAfter](..//Library/Location.md#Location-isAfter)
* [isBefore](..//Library/Location.md#Location-isBefore)
* [isContainedIn](..//Library/Location.md#Location-isContainedIn)
* [isImmediatelyAfter](..//Library/Location.md#Location-isImmediatelyAfter)
* [isImmediatelyBefore](..//Library/Location.md#Location-isImmediatelyBefore)
* [isLexicallyLess](..//Library/Location.md#Location-isLexicallyLess)
* [isOverlapping](..//Library/Location.md#Location-isOverlapping)
* [isSameFile](..//Library/Location.md#Location-isSameFile)
* [isStrictlyContainedIn](..//Library/Location.md#Location-isStrictlyContainedIn)
* [jarify](..//Library/Location.md#Location-jarify)
* [mavenize](..//Library/Location.md#Location-mavenize)
* [relativize](..//Library/Location.md#Location-relativize)

A source location `l` refers to a text fragment in another file or resource. To ease the description we will
talk about _`l` 's text_ instead of _the text `l` refers to_.


## function relativize {#Location-relativize}

Extracts a path relative to a parent location.

```rascal
loc relativize(loc outside, loc inside)
```


So from `x:///a/b` and `x:///a/b/c` this makes `relative:///c`.
If the outside does not envelop the inside, then the original loc is returned.

## function relativize {#Location-relativize}

Find the first `haystack` folder the `needle` can be found in and relativize it, or fail.

```rascal
loc relativize(list[loc] haystack, loc needle)
```

## function mavenize {#Location-mavenize}

Shortens an absolute path to a jar inside the local maven repository.

```rascal
loc mavenize(loc jar)
```

## function jarify {#Location-jarify}

If the location points to a jar file, then this modifies the scheme and the path to point _inside_ of the jar.

```rascal
loc jarify(loc jar)
```

## function isSameFile {#Location-isSameFile}

Check that two locations refer to the same file.

```rascal
bool isSameFile(loc l, loc r)
```

## function isLexicallyLess {#Location-isLexicallyLess}

Compare two location values lexicographically.

```rascal
bool isLexicallyLess(loc l, loc r)
```


When the two locations refer to different files, their paths are compared as string.
When they refer to the same file, their offsets are compared when present.

## function getContent {#Location-getContent}

Get the textual content a location refers to.

```rascal
str getContent(loc l)
```

## function isStrictlyContainedIn {#Location-isStrictlyContainedIn}

Is a location textually (strictly) contained in another location?

```rascal
bool isStrictlyContainedIn(loc inner, loc outer)
```


Strict containment between two locations `inner` and `outer` holds when


- `outer` 's text begins before `inner` 's text, or
- `outer` 's text ends after `inner` 's text, or
- both.

## function isContainedIn {#Location-isContainedIn}

Is a location textually contained in another location?

```rascal
bool isContainedIn(loc inner, loc outer)
```


Containment between two locations `inner` and `outer` holds when


- `inner` and `outer` are equal, or
- `inner` is strictly contained in `outer`.

## function beginsBefore {#Location-beginsBefore}

Begins a location's text before (but may overlap with) another location's text?

```rascal
bool beginsBefore(loc l, loc r)
```

## function isBefore {#Location-isBefore}

Begins and ends a location's text before another location's text?

```rascal
bool isBefore(loc l, loc r)
```


`isBefore(l, r)` holds when `l` 's text occurs textually before `r` 's text.

## function isImmediatelyBefore {#Location-isImmediatelyBefore}

Occurs a location's text _immediately_ before another location's text?

```rascal
bool isImmediatelyBefore(loc l, loc r)
```


`isImmediatelyBefore(l, r)` holds when `l` 's text occurs textually before, and is adjacent to, `r` 's text.

## function beginsAfter {#Location-beginsAfter}

Begins a location's text after (but may overlap with) another location's text?

Description
`beginsAfter(l, r)` holds when `l` 's text begins after `r` 's text. No assumption is made about the end of both texts.
In other words, `l` 's text may end before or after the end of `r` 's text.

```rascal
bool beginsAfter(loc l, loc r)
```

## function isAfter {#Location-isAfter}

Is a location's text completely after another location's text?

```rascal
bool isAfter(loc l, loc r)
```

## function isImmediatelyAfter {#Location-isImmediatelyAfter}

Is a location's text _immediately_ after another location's text?

```rascal
bool isImmediatelyAfter(loc l, loc r)
```

## function isOverlapping {#Location-isOverlapping}

Refer two locations to text that overlaps?

```rascal
bool isOverlapping(loc l, loc r)
```

## function cover {#Location-cover}

Compute a location that textually covers the text of a list of locations.

```rascal
loc cover(list[loc] locs)
```


Create a new location that refers to the smallest text area that overlaps with the text of the given locations.
The given locations should all refer to the same file but they may be overlapping or be contained in each other.

