---
title: "module analysis::statistics::Descriptive"
id: Descriptive
slug: /Library/analysis/statistics/Descriptive
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

Descriptive Statistics.
#### Usage

```rascal
import analysis::statistics::Descriptive;
```

#### Dependencies
```rascal
import Exception;
import util::Math;
import List;
```

#### Description


Provides the following univariate (single variable) statistics functions:

* [centralMoment](../../..//Library/analysis/statistics/Descriptive.md#analysis-statistics-Descriptive-centralMoment)
* [geometricMean](../../..//Library/analysis/statistics/Descriptive.md#analysis-statistics-Descriptive-geometricMean)
* [kurtosis](../../..//Library/analysis/statistics/Descriptive.md#analysis-statistics-Descriptive-kurtosis)
* [kurtosisExcess](../../..//Library/analysis/statistics/Descriptive.md#analysis-statistics-Descriptive-kurtosisExcess)
* [max](../../..//Library/analysis/statistics/Descriptive.md#analysis-statistics-Descriptive-max)
* [mean](../../..//Library/analysis/statistics/Descriptive.md#analysis-statistics-Descriptive-mean)
* [median](../../..//Library/analysis/statistics/Descriptive.md#analysis-statistics-Descriptive-median)
* [middle](../../..//Library/analysis/statistics/Descriptive.md#analysis-statistics-Descriptive-middle)
* [min](../../..//Library/analysis/statistics/Descriptive.md#analysis-statistics-Descriptive-min)
* [moment](../../..//Library/analysis/statistics/Descriptive.md#analysis-statistics-Descriptive-moment)
* [percentile](../../..//Library/analysis/statistics/Descriptive.md#analysis-statistics-Descriptive-percentile)
* [skewness](../../..//Library/analysis/statistics/Descriptive.md#analysis-statistics-Descriptive-skewness)
* [standardDeviation](../../..//Library/analysis/statistics/Descriptive.md#analysis-statistics-Descriptive-standardDeviation)
* [sum](../../..//Library/analysis/statistics/Descriptive.md#analysis-statistics-Descriptive-sum)
* [sumsq](../../..//Library/analysis/statistics/Descriptive.md#analysis-statistics-Descriptive-sumsq)
* [variance](../../..//Library/analysis/statistics/Descriptive.md#analysis-statistics-Descriptive-variance)

#### Examples



```rascal-shell 
rascal>import analysis::statistics::Descriptive;
ok
rascal>D = [67, 88, 55, 92.5, 102, 51];
list[num]: [67,88,55,92.5,102,51]
rascal>mn = min(D);
num: 51
rascal>mx = max(D);
num: 102
rascal>range = mx - mn;
num: 51
rascal>midrange =  mn + range/2;
num: 76.5
rascal>sum(D);
num: 455.5
rascal>mean(D);
real: 75.91666667
rascal>geometricMean(D);
real: 73.3734107237
rascal>standardDeviation(D);
real: 21.1622698845
rascal>variance(D);
num: 447.841666666666666666666666666
rascal>percentile(D,25);
num: 55
rascal>percentile(D,50);
num: 67
rascal>percentile(D,75);
num: 92.5
```


## function geometricMean {#analysis-statistics-Descriptive-geometricMean}

Geometric mean of data values.

```rascal
real geometricMean([num hd, *num tl])
```


Computes the [geometric mean](http://en.wikipedia.org/wiki/Geometric_mean) of the given data values.

## function kurtosis {#analysis-statistics-Descriptive-kurtosis}

Kurtosis of data values.

```rascal
real kurtosis(list[num] values:[_, *_])
```


Computes the [kurtosis](http://en.wikipedia.org/wiki/Kurtosis) of the given data values.
Kurtosis is a measure of the "peakedness" of a distribution.

## function kurtosisExcess {#analysis-statistics-Descriptive-kurtosisExcess}

Kurtosis excess of data values.

```rascal
real kurtosisExcess(list[num] values)
```


Computes the [kurtosis excess](http://en.wikipedia.org/wiki/Kurtosis) of the given data values.
Kurtosis excess is a measure of the "peakedness" of a distribution corrected such that a normal distribution will be 0.

## function max {#analysis-statistics-Descriptive-max}

Largest data value.

```rascal
(&T <: num) max([(&T <: num) h, *(&T <: num) t])
```

## function mean {#analysis-statistics-Descriptive-mean}

Arithmetic mean of data values.

```rascal
real mean(list[num] nums:[_, *_])
```


Computes the [arithmetic mean](http://en.wikipedia.org/wiki/Arithmetic_mean) of the data values.

## function median {#analysis-statistics-Descriptive-median}

Median of data values.

```rascal
default real median(list[num] nums:[_, *_])
```


Returns the [median](http://en.wikipedia.org/wiki/Median) of the available values.
This is the same as the 50th [Percentile](../../..//Library/analysis/statistics/Descriptive.md#analysis-statistics-Descriptive-percentile).

#### Examples



```rascal-shell 
rascal>import analysis::statistics::Descriptive;
ok
rascal>median([1,2,5,7,8]);
real: 5.
rascal>median([1,2,2,6,7,8]);
real: 4.
```

## function middle {#analysis-statistics-Descriptive-middle}

```rascal
list[&T] middle(list[&T] nums)
```

## function min {#analysis-statistics-Descriptive-min}

Smallest data value.

```rascal
(&T <: num) min([(&T <: num) h, *(&T <: num) t])
```

## function percentile {#analysis-statistics-Descriptive-percentile}

Percentile of data values.

```rascal
&T <: num percentile(list[&T <: num] nums, num p)
```


Returns the `p`th [percentile](http://en.wikipedia.org/wiki/Percentile) of the data values.
 0 < `p` <= 100 should hold.

## function variance {#analysis-statistics-Descriptive-variance}

Variance of data values.

```rascal
num variance([num hd, *num tl])
```


Computes the [variance](http://en.wikipedia.org/wiki/Variance) of the data values.
It measures how far a set of numbers is spread out.

## function skewness {#analysis-statistics-Descriptive-skewness}

Skewness of data values.

```rascal
real skewness(list[num] values:[_, *_])
```


Returns the [skewness](http://en.wikipedia.org/wiki/Skewness) of the available values. Skewness is a measure of the asymmetry of a given distribution.

## function standardDeviation {#analysis-statistics-Descriptive-standardDeviation}

Standard deviation of data values.

```rascal
real standardDeviation(list[num] values)
```


Computes the [standard deviation](http://en.wikipedia.org/wiki/Standard_deviation)
of the data values. It shows how much variation exists from the average (mean, or expected value).

## function sum {#analysis-statistics-Descriptive-sum}

Sum of data values.

```rascal
(&T <:num) sum([(&T <: num) hd, *(&T <: num) tl])
```

## function sumsq {#analysis-statistics-Descriptive-sumsq}

Sum of the squares of data values.

```rascal
(&T <:num) sumsq(list[&T <:num] values)
```

## function centralMoment {#analysis-statistics-Descriptive-centralMoment}

Calculate the k-th central moment

```rascal
real centralMoment(list[num] nums:[_, *_], int order = 1)
```

## function moment {#analysis-statistics-Descriptive-moment}

Calculate the k-th moment

```rascal
real moment(list[num] nums:[_, *_], int order = 1)
```

