---
title: Standard Library
sidebar_position: 9
---
<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>


#### Synopsis

The Rascal Standard Library contains basic utility functions in relation to all built-in data structures,
reusable tools (intermediate formats) for analysis and visualization of software languages,
and language support for a number of common exchange formats and programming languages.

#### Description

The basic `Prelude` modules that contain utility functions for daily usage are right here in the 
root of the library. To include them all in one go, use the [Prelude](..//Library/Prelude.md) module:


```rascal-shell 
rascal>import Prelude;
ok
rascal>println("Hello Rascal!");
Hello Rascal!
ok
```

The [IO](..//Library/IO.md) module is otherwise most commonly used, because it contains [Println](..//Library/IO.md#IO-println).

The standard library has its own location scheme `std:///` which can be used to explore
its folder structure on the REPL. Note that source locations have auto-complete for the path component.


```rascal-shell 
rascal>|std:///|.ls
list[loc]: [
  |std:///Boolean.rsc|,
  |std:///Content.rsc|,
  |std:///DateTime.rsc|,
  |std:///Exception.rsc|,
  |std:///Grammar.rsc|,
  |std:///IO.rsc|,
  |std:///List.rsc|,
  |std:///ListRelation.rsc|,
  |std:///Location.rsc|,
  |std:///Map.rsc|,
  |std:///Message.rsc|,
  |std:///Messages.class|,
  |std:///Node.rsc|,
  |std:///ParseTree.rsc|,
  |std:///Prelude$1.class|,
  |std:///Prelude$2.class|,
  |std:///Prelude$3.class|,
  |std:///Prelude$4.class|,
  |std:///Prelude$Backtrack.class|,
  |std:///Prelude$ByteBufferBackedInputStream.class|,
  |std:///Prelude$Distance.class|,
  |std:///Prelude$Less.class|,
  |std:///Prelude$NodeComparator.class|,
  |std:///Prelude$ReleasableCallback.class|,
  |std:///Prelude$Sorting.class|,
  |std:///Prelude.class|,
  |std:///Prelude.rsc|,
  |std:///Relation.rsc|,
  |std:///Set.rsc|,
  |std:///String.rsc|,
  |std:///Type.class|,
  |std:///Type.rsc|,
  |std:///ValueIO.rsc|,
  |std:///analysis|,
  |std:///index.md|,
  |std:///lang|,
  |std:///resource|,
  |std:///util|,
  |std:///vis|
]
```

These are the entry points to the entire library:
* [Boolean](..//Library/Boolean.md)
* [Content](..//Library/Content.md)
* [Date Time](..//Library/DateTime.md)
* [Exception](..//Library/Exception.md)
* [Grammar](..//Library/Grammar.md)
* [IO](..//Library/IO.md)
* [List](..//Library/List.md)
* [List Relation](..//Library/ListRelation.md)
* [Location](..//Library/Location.md)
* [Map](..//Library/Map.md)
* [Message](..//Library/Message.md)
* [Node](..//Library/Node.md)
* [Parse Tree](..//Library/ParseTree.md)
* [Prelude](..//Library/Prelude.md)
* [Relation](..//Library/Relation.md)
* [Set](..//Library/Set.md)
* [String](..//Library/String.md)
* [Type](..//Library/Type.md)
* [Value IO](..//Library/ValueIO.md)
* [Analysis](../Library/analysis/index.md)
* [Lang](../Library/lang/index.md)
* [Util](../Library/util/index.md)
* [Vis](../Library/vis/index.md)

#### Benefits

* The standard library comes with "batteries included", a number of reusable data-types and data-structures for building code analysis and manipulation tools. See for example [Core](..//Library/analysis/m3/Core.md).
* Utility functions are sorted per data-type. So if you need something that operates on lists then look in the [List](..//Library/List.md) module of the library. For sets look in [Set](..//Library/Set.md), etc.
* To process [CSV](../Library/lang/csv/index.md), [XML](../Library/lang/xml/index.md), [JSON](../Library/lang/json/index.md), [YAML](../Library/lang/yaml/index.md) you will find utilities here, even support to access [SQL](..//Library/resource/jdbc/JDBC.md) databases via JDBC.

#### Pitfalls

* [Prelude](..//Library/Prelude.md) is a rather big collection of functions to have imported. It is sometimes better to cherry-pick the modules you need.
* Some languages in [Lang](../Library/lang/index.md) are not 100% tested and up-to-date. We are extracting these one-by-one to experimental library packages.

