---
title: "module lang::dimacs::\\syntax::Dimacs"
id: Dimacs
slug: /Library/lang/dimacs/syntax/Dimacs
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

Standard format for boolean formulas in conjunctive normal form.
#### Usage

```rascal
import lang::dimacs::\syntax::Dimacs;
```



This format is used by the yearly SAT competition, see https://www.satcompetition.org/ .

#### Examples


This is a sample `.cnf` file:
```dimacs
c A sample .cnf file.
p cnf 3 2
1 -3 0
2 3 -1 0 
```


## syntax L {#lang-dimacs-\syntax-Dimacs-L}

```rascal
layout L = [\t\ \r]*;
```

## syntax Comment {#lang-dimacs-\syntax-Dimacs-Comment}

```rascal
lexical Comment = comment: "c" ![\n]* "\n";
```

## syntax Prologue {#lang-dimacs-\syntax-Dimacs-Prologue}

```rascal
lexical Prologue = prologue: "p" "cnf" Number variables Number clauses ![\n]* "\n";
```

## syntax Number {#lang-dimacs-\syntax-Dimacs-Number}

```rascal
lexical Number 
  = positive: [0-9]+ !>> [0-9]
  | non-assoc negative: "-" Number number
  ;
```

## syntax Dimacs {#lang-dimacs-\syntax-Dimacs-Dimacs}

```rascal
start syntax Dimacs
  = Prologue prologue {Line "\n"}+ lines "\n";
```

## syntax Line {#lang-dimacs-\syntax-Dimacs-Line}

```rascal
syntax Line 
  = disjunct: Disjunct disjunct
  | comment: Comment comment
  ;
```

## syntax Disjunct {#lang-dimacs-\syntax-Dimacs-Disjunct}

```rascal
syntax Disjunct = Number+ numbers;
```

