---
title: "module lang::dot::\\syntax::Dot"
id: Dot
slug: /Library/lang/dot/syntax/Dot
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

#### Usage

```rascal
import lang::dot::\syntax::Dot;
```



## syntax DOT {#lang-dot-\syntax-Dot-DOT}

```rascal
start syntax DOT = Graph  Id "{" StatementList "}" "\n"?;
```

## syntax Reserved {#lang-dot-\syntax-Dot-Reserved}

```rascal
keyword Reserved 
  = "graph" 
  | "digraph" 
  | "node" 
  | "edge" 
  | "subgraph"
  ;
```

## syntax Graph {#lang-dot-\syntax-Dot-Graph}

```rascal
syntax Graph 
  = "graph" 
  | "digraph" 
  | AttrTag
  ;
```

## syntax AttrTag {#lang-dot-\syntax-Dot-AttrTag}

```rascal
syntax AttrTag 
  = "node" 
  | "edge" 
  | "graph"
  ;
```

## syntax Nod {#lang-dot-\syntax-Dot-Nod}

```rascal
syntax Nod 
  = NodeId
  | Subgraph
  ;
```

## syntax Id {#lang-dot-\syntax-Dot-Id}

```rascal
lexical Id 
  = ([A-Z a-z 0-9 _] !<< [a-z A-Z 0-9 _][a-z A-Z 0-9 _]* !>> [0-9 A-Z _ a-z]) \ Reserved 
  | [\"] (![\"] | "\\\"")* [\"]
  | [\-]? "." [0-9]+
  | [\-]? [0-9]+ "." [0-9]*
  ;
```

## syntax StatementList {#lang-dot-\syntax-Dot-StatementList}

```rascal
syntax StatementList = StatementOptional*;
```

## syntax Statement {#lang-dot-\syntax-Dot-Statement}

```rascal
syntax Statement 
  = NodeStatement
  | EdgeStatement
  | AttrStatement  
  | Id "=" Id
  ;
```

## syntax StatementOptional {#lang-dot-\syntax-Dot-StatementOptional}

```rascal
syntax StatementOptional = Statement ";"?;
```

## syntax NodeStatement {#lang-dot-\syntax-Dot-NodeStatement}

```rascal
syntax NodeStatement = Nod AttrList;
```

## syntax EdgeStatement {#lang-dot-\syntax-Dot-EdgeStatement}

```rascal
syntax EdgeStatement = Nod EdgeRhs AttrList ;
```

## syntax Edg {#lang-dot-\syntax-Dot-Edg}

```rascal
syntax Edg =  EdgeOp Nod;
```

## syntax EdgeOp {#lang-dot-\syntax-Dot-EdgeOp}

```rascal
syntax EdgeOp = "-\>" | "--";
```

## syntax EdgeRhs {#lang-dot-\syntax-Dot-EdgeRhs}

```rascal
syntax EdgeRhs = Edg+;
```

## syntax NodeId {#lang-dot-\syntax-Dot-NodeId}

```rascal
syntax NodeId 
  = Id 
  | Id Port
  ;
```

## syntax Port {#lang-dot-\syntax-Dot-Port}

```rascal
syntax Port = ":" Id (":" Id)?
//          | ":" Id
//          | ":" CompassPt
            ;
```

## syntax AttrList {#lang-dot-\syntax-Dot-AttrList}

```rascal
syntax AttrList =   AttrList0*;
```

## syntax AttrList0 {#lang-dot-\syntax-Dot-AttrList0}

```rascal
syntax AttrList0 =  "[" DotAttr* "]";
```

## syntax DotAttr {#lang-dot-\syntax-Dot-DotAttr}

```rascal
syntax DotAttr = Id "=" Id | Id "=" Id "," ;
```

## syntax AttrStatement {#lang-dot-\syntax-Dot-AttrStatement}

```rascal
syntax AttrStatement = AttrTag AttrList;
```

## syntax Subgraph {#lang-dot-\syntax-Dot-Subgraph}

```rascal
syntax Subgraph = ("subgraph" Id? )?  "{" StatementList "}";
```

## syntax Comment {#lang-dot-\syntax-Dot-Comment}

```rascal
lexical Comment = "/*" (![*] | [*] !>> "/")* "*/"
                | "//" ![\n]* $
                ;
```

## syntax LAYOUTLIST {#lang-dot-\syntax-Dot-LAYOUTLIST}

```rascal
layout LAYOUTLIST = LAYOUT* !>> [\ \t\n\r] !>> "//" !>> "/*"
                    ;
```

## syntax LAYOUT {#lang-dot-\syntax-Dot-LAYOUT}

```rascal
lexical LAYOUT = Whitespace: [\ \t\n\r] 
               | @category="comment" Comment
               ;
```

